/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.farm_and_charm.client.renderer.block.StorageTypeRenderer;
import net.satisfy.farm_and_charm.client.util.ClientUtil;
import net.satisfy.farm_and_charm.core.block.entity.StorageBlockEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ChickenNestRenderer
implements StorageTypeRenderer {
    private static final TransformData[] TRANSFORMS = new TransformData[]{new TransformData(new Vector3f(-0.2f, 0.3f, -0.2f), 45.0f, 65.0f), new TransformData(new Vector3f(0.2f, 0.3f, -0.2f), 20.0f, 60.0f)};

    @Override
    public void render(StorageBlockEntity entity, PoseStack matrixStack, MultiBufferSource bufferSource, NonNullList<ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return;
        }
        matrixStack.m_85836_();
        this.setupInitialTransform(matrixStack);
        Random random = new Random(entity.m_58899_().hashCode());
        for (int index = 0; index < itemStacks.size(); ++index) {
            ItemStack stack = (ItemStack)itemStacks.get(index);
            if (stack.m_41619_()) continue;
            matrixStack.m_85836_();
            TransformData transform = this.getTransform(index);
            this.applyItemTransform(matrixStack, transform);
            this.renderItems(matrixStack, bufferSource, entity, stack, random);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    private void setupInitialTransform(PoseStack matrixStack) {
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252880_(0.1f, 0.0f, 0.3f);
    }

    private TransformData getTransform(int index) {
        return index < TRANSFORMS.length ? TRANSFORMS[index] : new TransformData(new Vector3f(0.0f, 0.3f, 0.0f), 0.0f, 0.0f);
    }

    private void applyItemTransform(PoseStack matrixStack, TransformData data) {
        matrixStack.m_252880_(data.position.x, data.position.y, data.position.z);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(data.rotYDeg)).rotateX((float)Math.toRadians(data.rotXDeg));
        matrixStack.m_252781_(rotation);
    }

    private void renderItems(PoseStack matrixStack, MultiBufferSource bufferSource, StorageBlockEntity entity, ItemStack stack, Random random) {
        for (int i = 0; i <= stack.m_41613_() / 8; ++i) {
            matrixStack.m_85836_();
            Vector3f offset = this.offsetRandomly(random);
            matrixStack.m_252880_(offset.x, offset.y, offset.z);
            ClientUtil.renderItem(stack, matrixStack, bufferSource, entity);
            matrixStack.m_85849_();
        }
    }

    private Vector3f offsetRandomly(Random random) {
        return new Vector3f((random.nextFloat() - 0.5f) * 0.125f, (random.nextFloat() - 0.5f) * 0.125f, (random.nextFloat() - 0.5f) * 0.125f);
    }

    private record TransformData(Vector3f position, float rotYDeg, float rotXDeg) {
    }
}

