/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.mixin;

import com.peeko32213.seafarer.common.entity.Brushable;
import com.peeko32213.seafarer.core.events.BrushingEvent;
import com.peeko32213.seafarer.core.events.ForgeEvents;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BrushItem.class})
public class BrushItemMixin
extends Item {
    public BrushItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (pPlayer != null && ForgeEvents.calculateHitResult((LivingEntity)pPlayer).m_6662_() == HitResult.Type.ENTITY) {
            pPlayer.m_6672_(pUsedHand);
        }
        return InteractionResult.CONSUME;
    }

    @Inject(method={"onUseTick"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/phys/BlockHitResult;getBlockPos()Lnet/minecraft/core/BlockPos;")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void seafarer$injectBlockBrushEvent(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration, CallbackInfo ci, Player player, HitResult hitresult, BlockHitResult blockhitresult, int i, boolean flag) {
        BlockPos blockpos = blockhitresult.m_82425_();
        BrushingEvent.Block brushingEvent = new BrushingEvent.Block(pLevel, pStack, player, blockhitresult, blockpos);
        MinecraftForge.EVENT_BUS.post((Event)brushingEvent);
    }

    @Inject(method={"onUseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;releaseUsingItem()V")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private void seafarer$injectEntityBrushEventAndBrushable(Level level, LivingEntity pLivingEntity, ItemStack stack, int pRemainingUseDuration, CallbackInfo ci) {
        Player player;
        HitResult hitresult;
        if (pLivingEntity instanceof Player && (hitresult = ForgeEvents.calculateHitResult((LivingEntity)(player = (Player)pLivingEntity))) instanceof EntityHitResult) {
            Entity targetEntity;
            EntityHitResult entityHitResult = (EntityHitResult)hitresult;
            if (hitresult.m_6662_() == HitResult.Type.ENTITY && (targetEntity = entityHitResult.m_82443_()) instanceof Brushable) {
                boolean flag;
                Brushable brushable = (Brushable)targetEntity;
                brushable.startBrusing();
                int i = stack.m_41779_() - pRemainingUseDuration + 1;
                boolean bl = flag = i % 10 == 5;
                if (flag) {
                    BlockPos pos = targetEntity.m_20183_();
                    BrushingEvent.Entity brushingEvent = new BrushingEvent.Entity(level, stack, player, entityHitResult, targetEntity, pos);
                    MinecraftForge.EVENT_BUS.post((Event)brushingEvent);
                    if (!brushingEvent.isCanceled() && brushable.isBrushable(player, stack, level, pos)) {
                        if (brushable.brushSound() != null) {
                            level.m_247517_(null, pos, brushable.brushSound(), player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
                        }
                        List<ItemStack> drops = brushable.brush(level.m_46467_(), player, entityHitResult.m_82443_().m_6350_(), stack, targetEntity.m_9236_(), pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack));
                        Random rand = new Random();
                        drops.forEach(d -> {
                            ItemEntity ent = targetEntity.m_5552_(d, 1.0f);
                            ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                        });
                        stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
                        brushable.endBrushing();
                    }
                }
            }
            ci.cancel();
        }
    }
}

