/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.seafarer.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SFShellDecorationBlock
extends BushBlock
implements SimpleWaterloggedBlock {
    protected final VoxelShape Z_AXIS_AABB;
    protected final VoxelShape X_AXIS_AABB;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final Block deadBlock;

    public SFShellDecorationBlock(BlockBehaviour.Properties properties, VoxelShape z_axis_aabb, VoxelShape x_axis_aabb, Block pDeadBlock) {
        super(properties);
        this.Z_AXIS_AABB = z_axis_aabb;
        this.X_AXIS_AABB = x_axis_aabb;
        this.deadBlock = pDeadBlock;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_56089_) {
        FluidState fluidstate;
        if (!this.scanForWater((BlockGetter)p_56089_.m_43725_(), p_56089_.m_8083_())) {
            p_56089_.m_43725_().m_186460_(p_56089_.m_8083_(), (Block)this, 60 + p_56089_.m_43725_().m_213780_().m_188503_(40));
        }
        boolean flag = (fluidstate = p_56089_.m_43725_().m_6425_(p_56089_.m_8083_())).m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(p_56089_).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.scanForWater((BlockGetter)pLevel, pPos)) {
            pLevel.m_7731_(pPos, this.deadBlock.m_49966_(), 2);
        }
    }

    protected boolean scanForWater(BlockGetter pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        for (Direction direction : Direction.values()) {
            FluidState fluidstate = pLevel.m_6425_(pPos.m_121945_(direction));
            if (!state.canBeHydrated(pLevel, pPos, fluidstate, pPos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ((Direction)pState.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? this.X_AXIS_AABB : this.Z_AXIS_AABB;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (!this.scanForWater((BlockGetter)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 60 + pLevel.m_213780_().m_188503_(40));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return this.m_6266_(world.m_8055_(below), (BlockGetter)world, below);
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return (!state.m_60812_(world, pos).m_83263_(Direction.UP).m_83281_() || state.m_60783_(world, pos, Direction.UP)) && !state.m_204336_(BlockTags.f_13035_);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.AIR && !this.f_60443_ || super.m_7357_(state, world, pos, type);
    }

    public FluidState m_5888_(BlockState p_56131_) {
        return (Boolean)p_56131_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_56131_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_56120_) {
        p_56120_.m_61104_(new Property[]{WATERLOGGED});
    }
}

