/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.mounts;

import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.registery.Sounds;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import software.bernie.geckolib.core.animation.RawAnimation;

public class NightmareEntity
extends MountEntity {
    private static final UUID SOUL_SPEED_BOOST_ID = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private int frameCount = 0;
    private int currentFrame = 0;
    private final String[] textureFrames = new String[]{"_frame1.png", "_frame1b.png", "_frame2.png", "_frame2b.png", "_frame3.png", "_frame3b.png", "_frame4.png", "_frame4b.png"};
    int bookTick = 0;
    final String[] idleAnimations = new String[]{"animation.mount.idle", "animation.mount.idle2", "animation.mount.idle3", "animation.mount.idle4", "animation.mount.idle5", "animation.mount.idle6", "animation.mount.idle7", "animation.mount.idle8"};
    final String[] mountedIdleAnimations = new String[]{"animation.mount.idle", "animation.mount.idle2", "animation.mount.idle3", "animation.mount.idle5", "animation.mount.idle6", "animation.mount.idle7", "animation.mount.idle8"};

    public NightmareEntity(EntityType<? extends MountEntity> type, Level worldIn) {
        super(type, worldIn, Entities.EntityKey.NIGHTMARE, true, false);
        this.armorTextureBaseStr = "textures/model/entity/armor/nightmare_armor";
        String a = "nightmare_mount1";
        String b = "nightmare_mount2";
        String c = "nightmare_mount5";
        for (int i = 0; i < 3; ++i) {
            this.textures.add("nightmare_mount1");
            this.textures.add("nightmare_mount1");
            this.textures.add("nightmare_mount1");
            this.textures.add("nightmare_mount2");
            this.textures.add("nightmare_mount2");
            this.textures.add("nightmare_mount5");
        }
        this.textures.add("nightmare_mount3");
        this.textures.add("nightmare_mount4");
        this.textures.add("nightmare_mount6");
        this.childScale = 0.6f;
        this.childHeadScale = 1.0f;
        this.miniYOffset = 0.8f;
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        boolean res = effect.m_19544_() != MobEffects.f_19615_;
        return res && super.m_7301_(effect);
    }

    protected void m_21186_() {
        if (!this.m_217002_().m_60795_() && this.m_6046_()) {
            AttributeInstance entityAttributeInstance = this.m_21051_(Attributes.f_22279_);
            if (entityAttributeInstance == null) {
                return;
            }
            entityAttributeInstance.m_22118_(new AttributeModifier(SOUL_SPEED_BOOST_ID, "Soul speed boost", 0.07724998891353607, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    protected void m_214179_(RandomSource random) {
        super.m_214179_(random);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(Settings.settings.get((Object)((Object)this.mountKey)).health + (double)this.f_19796_.m_188503_(6) + (double)this.f_19796_.m_188503_(6));
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)NightmareEntity.calcSpeedStat(this.mountKey));
        Objects.requireNonNull(this.m_21051_(Attributes.f_22288_)).m_22100_(NightmareEntity.m_272017_(() -> ((RandomSource)random).m_188500_()) * 1.5);
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13132_);
    }

    private void updateFloating() {
        if (this.m_20077_()) {
            CollisionContext shapeContext = CollisionContext.m_82750_((Entity)this);
            if (shapeContext.m_6513_(LiquidBlock.f_54690_, this.m_20097_(), true) && !this.m_9236_().m_6425_(this.m_20097_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    @Override
    public boolean m_6914_(LevelReader world) {
        return !world.m_45784_((Entity)this) && !world.m_46855_(this.m_20191_());
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        this.m_20101_();
        if (this.m_20077_() || this.m_9236_().m_8055_(this.m_20097_().m_7495_()).m_60713_(Blocks.f_49991_)) {
            this.f_19789_ = 0.0f;
        } else {
            super.m_7840_(0.75 * heightDifference, onGround, landedState, landedPosition);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.updateFloating();
        this.m_20101_();
        ++this.frameCount;
        this.frameCount %= 2;
        if (this.frameCount == 0) {
            ++this.currentFrame;
            this.currentFrame %= this.textureFrames.length;
        }
        if (this.m_9236_().m_5776_()) {
            if (this.f_19796_.m_188503_(10) == 0) {
                this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, (SoundEvent)Sounds.FIRE.get(), SoundSource.NEUTRAL, 0.5f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.6f, false);
            }
            if (this.f_19796_.m_188503_(5) == 0) {
                for (int i = 0; i < this.f_19796_.m_188503_(1) + 1; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, (double)(this.f_19796_.m_188501_() / 2.0f), 5.0E-5, (double)(this.f_19796_.m_188501_() / 2.0f));
                }
            }
            if (this.m_20077_()) {
                this.m_6034_(this.m_20185_(), (float)this.m_146904_() + 0.8f, this.m_20189_());
            }
        }
    }

    @Override
    public String getTextureFile() {
        if (super.getTextureFile() == null || super.getTextureFile().equals("textures/model/entity/")) {
            ++this.bookTick;
            this.bookTick %= 60;
            if (this.bookTick == 0) {
                ++this.currentFrame;
                this.currentFrame %= this.textureFrames.length;
            }
            return "textures/model/entity/nightmare_mount1" + this.textureFrames[this.currentFrame];
        }
        return super.getTextureFile() + this.textureFrames[this.currentFrame];
    }

    @Override
    public String getDefaultTexture() {
        return "nightmare_mount1_frame1.png";
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.m_5912_()) {
            return (SoundEvent)Sounds.NIGHTMARE_ANGRY_EVENT.get();
        }
        return (SoundEvent)Sounds.NIGHTMARE_AMBIENT_EVENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)Sounds.NIGHTMARE_HURT_EVENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)Sounds.NIGHTMARE_DEATH_EVENT.get();
    }

    @Override
    protected SoundEvent m_7871_() {
        return (SoundEvent)Sounds.NIGHTMARE_ANGRY_EVENT.get();
    }

    @Override
    public RawAnimation getIdleAnimation() {
        if (this.m_217005_()) {
            return this.getRandomAnimation(this.mountedIdleAnimations);
        }
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    public RawAnimation getSleepingIdleAnimation() {
        return this.getRandomAnimation(this.idleAnimations);
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12035_, 1.0f, 1.0f);
    }

    @Override
    protected void m_7486_() {
        if (this.getIsFlying()) {
            this.playFlapSound();
        } else {
            this.m_5496_(SoundEvents.f_11979_, 1.0f, 1.0f);
        }
    }
}

