/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity.ai;

import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import java.util.ArrayList;

public class MountAnimationStateManager {
    private MountAnimationState currentState;
    private MountAnimationState noneState;
    private MountAnimationState sitState;
    private MountAnimationState sleepState;
    private MountAnimationState tamedSitState;
    private MountAnimationState tamedSleepState;
    private MountAnimationState flyingState;

    public MountAnimationStateManager(MountEntity mountEntity) {
        VoidFunction none = () -> MountAnimationStateManager.setEntityNone(mountEntity);
        VoidFunction sit = () -> MountAnimationStateManager.setEntitySit(mountEntity);
        VoidFunction sleep = () -> MountAnimationStateManager.setEntitySleep(mountEntity);
        this.noneState = new MountAnimationState(none, "None", 100, 400);
        this.sitState = new MountAnimationState(sit, "Sit", 100, 200);
        this.sleepState = new MountAnimationState(sleep, "Sleep", 100, 200);
        this.tamedSitState = new MountAnimationState(sit, "Tamed Sit", 30, 30);
        this.tamedSleepState = new MountAnimationState(sleep, "Tamed Sleep", 100, 200);
        this.flyingState = new MountAnimationState(none, "Flying", 100, 400);
        ArrayList<MountAnimationState> noneNext = new ArrayList<MountAnimationState>();
        noneNext.add(this.noneState);
        noneNext.add(this.sitState);
        noneNext.add(this.sleepState);
        this.noneState.setNextPhases(noneNext);
        ArrayList<MountAnimationState> sitNext = new ArrayList<MountAnimationState>();
        sitNext.add(this.sitState);
        sitNext.add(this.noneState);
        sitNext.add(this.sleepState);
        this.sitState.setNextPhases(sitNext);
        ArrayList<MountAnimationState> sleepNext = new ArrayList<MountAnimationState>();
        sleepNext.add(this.sleepState);
        sleepNext.add(this.sitState);
        this.sleepState.setNextPhases(sleepNext);
        ArrayList<MountAnimationState> tamedSitNext = new ArrayList<MountAnimationState>();
        tamedSitNext.add(this.tamedSitState);
        tamedSitNext.add(this.tamedSleepState);
        this.tamedSitState.setNextPhases(tamedSitNext);
        ArrayList<MountAnimationState> tamedSleepNext = new ArrayList<MountAnimationState>();
        tamedSleepNext.add(this.tamedSleepState);
        tamedSleepNext.add(this.tamedSitState);
        this.tamedSleepState.setNextPhases(tamedSleepNext);
        ArrayList<MountAnimationState> flyingNext = new ArrayList<MountAnimationState>();
        flyingNext.add(this.noneState);
        this.flyingState.setNextPhases(flyingNext);
        this.currentState = this.noneState;
        this.currentState.startAction();
    }

    public void setOwnerSitting() {
        this.currentState = this.tamedSitState;
    }

    public void setOwnerWander() {
        this.currentState = this.noneState;
    }

    public void setFlying() {
        this.currentState = this.flyingState;
    }

    public void reset() {
        this.currentState = this.noneState;
    }

    public void tick() {
        this.currentState = this.currentState.updateState();
    }

    public static void setEntityNone(MountEntity mountEntity) {
        mountEntity.setIsSitting(false);
        mountEntity.setIsSleeping(false);
    }

    private static void setEntitySit(MountEntity mountEntity) {
        mountEntity.setIsSitting(true);
        mountEntity.setIsSleeping(false);
        mountEntity.setIsFlying(false);
    }

    private static void setEntitySleep(MountEntity mountEntity) {
        mountEntity.setIsSleeping(true);
        mountEntity.setIsSitting(true);
        mountEntity.setIsFlying(false);
    }

    private static interface VoidFunction {
        public void run();
    }

    private class MountAnimationState {
        private int stateTimer = 0;
        private int minTime = 0;
        private int maxTime = 0;
        private String stateName = "";
        private ArrayList<MountAnimationState> nextPhases;
        private VoidFunction action;

        public MountAnimationState(VoidFunction mountAction, String name, int minTime, int maxTime) {
            this.action = mountAction;
            this.stateName = name;
            this.minTime = minTime;
            this.maxTime = maxTime;
        }

        private void setNextPhases(ArrayList<MountAnimationState> nextPhases) {
            this.nextPhases = nextPhases;
        }

        private void startAction() {
            this.action.run();
            this.stateTimer = this.minTime + (int)(Math.random() * (double)(this.maxTime - this.minTime));
        }

        private MountAnimationState updateState() {
            --this.stateTimer;
            if (this.stateTimer <= 0) {
                MountAnimationState nextState = this.nextPhases.get((int)(Math.random() * (double)this.nextPhases.size()));
                nextState.startAction();
                return nextState;
            }
            return this;
        }
    }
}

