/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.entity;

import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountData;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.MountAnimationManager;
import com.yahoo.chirpycricket.mythicmounts.entity.ai.MountGoals;
import com.yahoo.chirpycricket.mythicmounts.items.SummoningStaff;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.registery.Sounds;
import com.yahoo.chirpycricket.mythicmounts.screen.MountScreenHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MountEntity
extends Horse
implements GeoEntity,
HasCustomInventoryScreen,
MenuProvider {
    public Entities.EntityKey mountKey;
    protected Settings.EntitySettings settings;
    protected Item[] breedingItems = new Item[]{Items.f_42677_};
    protected Item[] foodItems = new Item[0];
    protected Item[] tamingItems = new Item[0];
    public Block[] seekingBlocks = new Block[0];
    protected boolean canFly = false;
    public boolean shouldSwim = true;
    public boolean shouldSwimInLava = true;
    public boolean canWalkOnPowderedSnow = false;
    public static final float miniScale = 0.75f;
    public float childScale = 0.5f;
    public float childHeadScale = 1.25f;
    public float leashYOffset = 0.5f;
    public float sittingLeashYOffset = 0.25f;
    public float leashZOffset = 0.4f;
    public float childLeashZOffset = 1.0f;
    public float miniYOffset = 1.0f;
    public float tamingChance = 0.33f;
    protected Predicate<LivingEntity> PREY_PREDICATE;
    protected Predicate<LivingEntity> PLAYER_PREDICATE;
    protected Predicate<LivingEntity> PUMPKIN_PREDICATE;
    protected Predicate<LivingEntity> ATTACKER_PREDICATE;
    int clickTimer = 0;
    protected int flapTimer = 0;
    protected int f_19797_ = 0;
    boolean playerLastRidingState = false;
    int walkCounter = 0;
    int maxWalkTime = (int)(500.0 + Math.random() * 5000.0);
    int sitCounter = 0;
    int maxSitTime = (int)(100.0 + Math.random() * 1000.0);
    int sleepCounter = 0;
    int maxSleepTime = (int)(100.0 + Math.random() * 1000.0);
    boolean wakeUp = false;
    public MountAnimationManager mountAnimationManager;
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float soundVolume = 1.0f;
    private static final EntityDataAccessor<Boolean> DOMESTICATED = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_MINI = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SITTING = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> OWNER_TOLD_TO_SIT = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SLEEPING = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_CLIMBING = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHEST;
    private static final EntityDataAccessor<Boolean> SHOULDFOLLOW;
    private static final EntityDataAccessor<Boolean> HAS_TRACKED_POS;
    private static final EntityDataAccessor<Boolean> FLIGHT_ALLOWED;
    private static final EntityDataAccessor<String> TEXTURE_VARIANT;
    private static final EntityDataAccessor<Integer> TRACKED_POS_X;
    private static final EntityDataAccessor<Integer> TRACKED_POS_Y;
    private static final EntityDataAccessor<Integer> TRACKED_POS_Z;
    private static final EntityDataAccessor<Integer> SPECIAL_NUM;
    protected String armorTextureBaseStr = "";
    public ArrayList<String> textures = new ArrayList();

    public MountEntity(EntityType<? extends Horse> type, Level worldIn, Entities.EntityKey mountKey) {
        super(type, worldIn);
        this.init(mountKey, true, true);
    }

    public MountEntity(EntityType<? extends Horse> type, Level worldIn, Entities.EntityKey mountKey, boolean shouldSwim) {
        super(type, worldIn);
        this.init(mountKey, shouldSwim, true);
    }

    public MountEntity(EntityType<? extends Horse> type, Level worldIn, Entities.EntityKey mountKey, boolean shouldSwim, boolean shouldSwimInLava) {
        super(type, worldIn);
        this.init(mountKey, shouldSwim, shouldSwimInLava);
    }

    private void init(Entities.EntityKey mountKey, boolean shouldSwim, boolean shouldSwimInLava) {
        this.setHasChest(false);
        this.mountKey = mountKey;
        this.settings = Settings.settings.get((Object)mountKey);
        this.m_30625_();
        this.mountAnimationManager = new MountAnimationManager(this);
        this.shouldSwim = shouldSwim;
        this.shouldSwimInLava = shouldSwimInLava;
        this.breedingItems = this.settings.breedingItems;
        this.foodItems = this.settings.foodItems;
        this.tamingItems = this.settings.tamingItems;
        this.tamingChance = (float)this.settings.tamingChance / 100.0f;
        this.seekingBlocks = new Block[this.settings.seekingBlocks.length];
        for (int i = 0; i < this.seekingBlocks.length; ++i) {
            this.seekingBlocks[i] = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)this.settings.seekingBlocks[i]));
        }
        this.soundVolume = (float)(this.settings.volume / 100.0);
        this.m_146915_(this.settings.spawnDebug || Settings.globalSettings.debug);
        this.initConfigurableGoals();
        if (this.settings.spawnDebug || Settings.globalSettings.debug) {
            System.out.println("init() for " + mountKey + " called.");
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new MountGoals.MountSitGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MountGoals.MountBreedGoal((Animal)this, 1.0, MountEntity.class));
        this.f_21345_.m_25352_(7, (Goal)new MountGoals.MountWanderAroundGoal(this, 1.0, 50));
        this.f_21345_.m_25352_(14, (Goal)new MountGoals.MountLookAtPlayerGoal(this, Player.class, 20.0f));
        this.f_21345_.m_25352_(15, (Goal)new MountGoals.MountLookAtPlayerGoal(this, LivingEntity.class, 20.0f));
        this.f_21345_.m_25352_(16, (Goal)new MountGoals.MountRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(9, (Goal)new MountGoals.MountFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
    }

    public void initConfigurableGoals() {
        this.PREY_PREDICATE = livingEntity -> {
            if (this.m_30614_() || this.getIsDomesticated()) {
                return false;
            }
            for (EntityType c : this.settings.mobHostile) {
                if (!c.equals(livingEntity.m_6095_())) continue;
                return true;
            }
            return false;
        };
        this.PLAYER_PREDICATE = livingEntity -> {
            if (this.m_30614_() || this.getIsDomesticated()) {
                return false;
            }
            return livingEntity instanceof Player;
        };
        this.PUMPKIN_PREDICATE = livingEntity -> {
            if (this.m_30614_() || this.getIsDomesticated()) {
                return false;
            }
            if (livingEntity instanceof SnowGolem && ((SnowGolem)livingEntity).m_29930_()) {
                return true;
            }
            for (ItemStack i : livingEntity.m_6168_()) {
                if (!i.m_150930_(Items.f_42047_) && !i.m_150930_(Items.f_42046_) && !i.m_41614_()) continue;
                return true;
            }
            return false;
        };
        this.ATTACKER_PREDICATE = livingEntity -> {
            if (this.m_30614_() && livingEntity == this.getOwner()) {
                return false;
            }
            return livingEntity == this.m_271686_();
        };
        if (this.shouldSwim) {
            this.f_21345_.m_25352_(0, (Goal)new MountGoals.MountSwimGoal(this));
        }
        if (this.settings.battleWithOwner) {
            this.f_21346_.m_25352_(2, (Goal)new MountGoals.MountTrackOwnerAttackerGoal(this));
            this.f_21346_.m_25352_(2, (Goal)new MountGoals.MountAttackWithOwnerGoal(this));
        }
        if (this.settings.playerHostile) {
            this.f_21346_.m_25352_(4, new MountGoals.MountFollowTargetIfTamedGoal<Player>(this, Player.class, true, this.PLAYER_PREDICATE));
        }
        if (this.settings.fleeFromPlayer) {
            this.f_21345_.m_25352_(5, new MountGoals.MountFleeGoal<Player>(this, Player.class, 16.0f, 2.0 * Settings.settings.get((Object)((Object)this.mountKey)).speed, 4.0 * Settings.settings.get((Object)((Object)this.mountKey)).speed));
        }
        if (this.settings.mobHostile.length > 0) {
            this.f_21346_.m_25352_(5, new MountGoals.MountFollowTargetIfTamedGoal<LivingEntity>(this, LivingEntity.class, false, this.PREY_PREDICATE));
        }
        if (this.settings.playerHostile || this.settings.mobHostile.length > 0 || this.settings.battleWithOwner) {
            this.f_21346_.m_25352_(3, new MountGoals.MountFollowTargetIfTamedGoal<LivingEntity>(this, LivingEntity.class, true, this.ATTACKER_PREDICATE));
            this.f_21346_.m_25352_(3, (Goal)new MountGoals.MountRevengeGoal(this, new Class[0]));
        } else {
            this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        }
        if (this.settings.seekingBlocks.length > 0) {
            this.f_21345_.m_25352_(7, (Goal)new MountGoals.MountGoToBlockGoal(this, 1.1, this.seekingBlocks));
            this.f_21345_.m_25352_(7, (Goal)new MountGoals.LookAtBlockGoal(this, 5.0f, 0.5f));
        }
    }

    public boolean canAttackWithOwner(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            if (target instanceof MountEntity) {
                MountEntity mountEntity = (MountEntity)target;
                return !mountEntity.m_30614_() || mountEntity.m_21805_() != owner.m_20148_();
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
        }
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Item newBook;
        if (hand.ordinal() == 1) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl = this.isOwner((LivingEntity)player) || this.m_30614_() || this.isTamingItem(itemStack) && !this.m_30614_();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        this.setIsSleeping(false);
        this.m_5496_(this.m_7515_(), this.m_6121_(), 1.0f);
        if (this.m_30614_()) {
            if (this.canEatFood(item) && this.m_21223_() < this.m_21233_() || this.isBreedingItem(itemStack) || this.isTamingItem(itemStack) && !this.m_30614_()) {
                boolean shouldDecrement = true;
                if (this.isBreedingItem(itemStack)) {
                    if (!this.m_27593_()) {
                        this.m_27595_(player);
                    } else {
                        this.m_27601_(0);
                        shouldDecrement = false;
                        this.showEmoteParticle(ParticleTypes.f_123762_);
                    }
                }
                if (shouldDecrement && !player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                if (item.m_41473_() != null) {
                    this.m_5634_(item.m_41473_().m_38744_());
                } else {
                    this.m_5634_(Items.f_42410_.m_41473_().m_38744_());
                }
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42009_ && !this.hasChest()) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                this.setHasChest(true);
                this.m_30625_();
                this.m_5496_((SoundEvent)Sounds.CHEST_EQUIPS.get(), this.m_6121_(), 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42574_ && this.hasChest()) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                this.dropChestInventory();
                this.m_30625_();
                return InteractionResult.SUCCESS;
            }
            if (player.m_6047_()) {
                if (this.clickTimer == 0) {
                    this.m_5496_(this.m_7515_(), this.m_6121_(), 1.5f);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    this.showEmoteParticle(ParticleTypes.f_123750_);
                    this.clickTimer = 10;
                    return InteractionResult.SUCCESS;
                }
                this.openGUI(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            boolean shouldCommand = false;
            if (item instanceof SummoningStaff && itemStack.m_41783_() != null) {
                UUID id = itemStack.m_41783_().m_128342_("Id");
                shouldCommand = this.m_20148_().equals(id);
            }
            if ((item == Settings.globalSettings.commandItem || shouldCommand) && !this.getIsFlying()) {
                if (this.isOwner((LivingEntity)player)) {
                    if (!this.getIsSitting() && !this.getShouldFollow()) {
                        this.setShouldFollow(true);
                        this.resetWanderBehaviorCycle();
                        this.setIsSitting(false);
                        this.setIsSleeping(false);
                        player.m_5661_((Component)Component.m_237115_((String)"message.mythicmounts.follow"), true);
                    } else if (!this.getIsSitting() && this.getShouldFollow() || this.getIsSitting() && !this.getShouldFollow()) {
                        this.setShouldFollow(false);
                        boolean shouldSit = !this.getOwnerToldToSit();
                        this.setOwnerToldToSit(shouldSit);
                        this.m_7910_(0.0f);
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        if (this.getOwnerToldToSit()) {
                            player.m_5661_((Component)Component.m_237115_((String)"message.mythicmounts.sit"), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"message.mythicmounts.wander"), true);
                        }
                    }
                } else {
                    boolean shouldSit = !this.getOwnerToldToSit();
                    this.setOwnerToldToSit(shouldSit);
                    this.m_7910_(0.0f);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    if (this.getOwnerToldToSit()) {
                        player.m_5661_((Component)Component.m_237115_((String)"message.mythicmounts.sit"), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.mythicmounts.wander"), true);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (this.m_6162_() && item.equals(Items.f_41955_)) {
            this.setIsMini(true);
            this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), 1.0f);
            this.showEmoteParticle(ParticleTypes.f_123748_);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6162_() && item.equals(Items.f_41954_)) {
            this.setIsMini(false);
            this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), 1.0f);
            this.showEmoteParticle(ParticleTypes.f_123748_);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_30614_()) {
            ItemStack itemStack2 = player.m_21120_(hand);
            if (this.isTamingItem(itemStack2) && !this.m_217005_()) {
                if (!player.m_7500_()) {
                    itemStack2.m_41774_(1);
                }
                if (this.m_7555_() > 0 && this.f_19796_.m_188500_() <= (double)this.tamingChance) {
                    this.m_30649_(this.m_7555_() + 1);
                    this.m_30651_(true);
                    this.m_30586_(player.m_20148_());
                    this.m_7910_(0.0f);
                    this.showEmoteParticle(ParticleTypes.f_123750_);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.setIsSitting(true);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                    this.showEmoteParticle(ParticleTypes.f_123762_);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.getIsFlying()) {
                return InteractionResult.PASS;
            }
            if (this.getIsSitting() || this.getIsSleeping()) {
                this.setIsSitting(false);
                this.setIsSleeping(false);
            }
        }
        if (item != null && (item.equals(Items.f_42517_) || item.equals(Items.f_42614_)) && (itemStack.m_41783_() == null || itemStack.m_41783_().m_128456_()) && (newBook = Settings.parseMinecraftItem("patchouli:guide_book")) != null) {
            ItemStack stack = newBook.m_7968_();
            if (stack.m_41783_() == null) {
                stack.m_41784_();
            }
            stack.m_41783_().m_128359_("patchouli:book", "mythicmounts:mythical_mounts");
            itemStack.m_41774_(1);
            player.m_36356_(stack);
            ((ServerLevel)this.m_9236_()).m_5594_(null, this.m_20097_(), (SoundEvent)Sounds.BOOK_CREATED.get(), SoundSource.PLAYERS, 1.0f, 1.5f);
            return InteractionResult.SUCCESS;
        }
        if (this.getIsMini() && (double)player.m_6972_((Pose)player.m_20089_()).f_20378_ > 1.0) {
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public void openGUI(Player playerEntity) {
        if (!this.m_9236_().f_46443_) {
            this.openInfoInventory(this, (Container)this.f_30520_, playerEntity);
        }
    }

    public void openInfoInventory(final MountEntity mount, Container inventoryIn, Player playerEntity) {
        if (!playerEntity.m_9236_().f_46443_ && playerEntity instanceof ServerPlayer) {
            ServerPlayer entityPlayerMP = (ServerPlayer)playerEntity;
            NetworkHooks.openScreen((ServerPlayer)entityPlayerMP, (MenuProvider)new MenuProvider(){

                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new MountScreenHandler(windowId, inventory, mount);
                }

                public Component m_5446_() {
                    return Component.m_237115_((String)"menu.title.mythicmounts.mountmenu");
                }
            }, buf -> buf.writeInt(mount.m_19879_()));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.f_19797_;
            this.f_19797_ %= 10000;
            if (this.m_142038_() && !this.settings.spawnDebug && !Settings.globalSettings.debug) {
                this.m_146915_(false);
            }
            if (this.playerLastRidingState && !this.m_217005_()) {
                this.onDismounted();
            } else if (!this.playerLastRidingState && this.m_217005_()) {
                this.onMounted();
            }
            this.playerLastRidingState = this.m_217005_();
            this.setTrackedAttacking(this.m_5912_());
            if (!this.m_9236_().f_46443_ && this.f_19797_ % 30 == 0 && (this.m_217005_() || this.m_20202_() != null || this.m_21523_())) {
                this.setTrackedPos(this.m_20097_());
            }
            if (this.getIsFlying()) {
                this.updateFlyingSound();
            }
            if (this.getIsSleeping() && this.sleepCounter % 10 == 0 && this.m_21223_() < this.m_21233_()) {
                this.m_21153_(Math.min(this.m_21223_() + 0.5f, this.m_21233_()));
            }
            if (!this.m_9236_().f_46443_ && !this.m_217005_()) {
                this.updateAnimationState();
            }
            if (this.clickTimer > 0) {
                --this.clickTimer;
            }
            if (this.getIsClimbing() && !this.m_217005_()) {
                this.setIsClimbing(false);
            }
        }
    }

    public void updateFlyingSound() {
        ++this.flapTimer;
        this.flapTimer %= 15;
        if (this.flapTimer == 0) {
            this.playFlapSound();
        }
    }

    public void resetWanderBehaviorCycle() {
        this.walkCounter = 0;
        this.sitCounter = 0;
        this.sleepCounter = 0;
        this.maxSitTime = (int)(100.0 + Math.random() * 1000.0);
        this.maxSleepTime = (int)(100.0 + Math.random() * 1000.0);
        this.maxWalkTime = (int)(500.0 + Math.random() * 5000.0);
    }

    public void updateAnimationState() {
        if (this.getShouldFollow()) {
            return;
        }
        if (!this.getIsFlying() && !this.m_5912_()) {
            if (!this.getIsSitting() && !this.getIsSleeping()) {
                ++this.walkCounter;
                if (this.walkCounter > this.maxWalkTime && !this.m_20069_() && !this.m_20077_()) {
                    this.resetWanderBehaviorCycle();
                    this.setIsSitting(true);
                }
            } else if (this.getIsSitting() && !this.getIsSleeping()) {
                ++this.sitCounter;
                if (this.sitCounter > this.maxSitTime) {
                    this.resetWanderBehaviorCycle();
                    if (this.wakeUp) {
                        if (!this.getOwnerToldToSit()) {
                            this.setIsSitting(false);
                        }
                        this.wakeUp = false;
                    } else {
                        this.setIsSleeping(true);
                    }
                }
            } else if (this.getIsSleeping()) {
                ++this.sleepCounter;
                if (this.sleepCounter > this.maxSleepTime) {
                    this.resetWanderBehaviorCycle();
                    this.wakeUp = true;
                    this.setIsSitting(true);
                    this.setIsSleeping(false);
                }
            }
            if (this.m_20069_() || this.m_20077_() || this.m_5912_() && !this.getOwnerToldToSit()) {
                this.resetWanderBehaviorCycle();
                if (this.getIsSitting()) {
                    this.setIsSitting(false);
                    this.setIsSleeping(false);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.mountAnimationManager.registerControllers(controllers);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public RawAnimation getRandomAnimation(String[] animations) {
        return RawAnimation.begin().thenLoop(animations[this.f_19796_.m_188503_(animations.length)]);
    }

    public RawAnimation getNoneAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.none");
    }

    public RawAnimation getNeutralAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.neutral");
    }

    public RawAnimation getBlinkAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.blink");
    }

    public RawAnimation getWalkAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.walk");
    }

    public RawAnimation getSprintAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.sprint");
    }

    public RawAnimation getFlyAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.fly");
    }

    public RawAnimation getClimbAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.walk");
    }

    public RawAnimation getSittingAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.sit");
    }

    public RawAnimation getSleepingAnimation() {
        return RawAnimation.begin().thenLoop("animation.mount.sleep");
    }

    public RawAnimation getSitDownAnimation() {
        return RawAnimation.begin().thenPlay("animation.mount.sitdown").thenLoop("animation.mount.sit");
    }

    public RawAnimation getStandupAnimation() {
        return RawAnimation.begin().thenPlay("animation.mount.standup").thenLoop("animation.mount.neutral");
    }

    public RawAnimation getGoToSleepAnimation() {
        return RawAnimation.begin().thenPlay("animation.mount.gotosleep").thenLoop("animation.mount.sleep");
    }

    public RawAnimation getWakeUpAnimation() {
        return RawAnimation.begin().thenPlay("animation.mount.wakeup").thenLoop("animation.mount.sit");
    }

    public RawAnimation getSwimAnimation() {
        return this.getWalkAnimation();
    }

    public RawAnimation getIdleAnimation() {
        return this.getNoneAnimation();
    }

    public RawAnimation getSittingIdleAnimation() {
        return this.getIdleAnimation();
    }

    public RawAnimation getSleepingIdleAnimation() {
        return this.getWalkAnimation();
    }

    public RawAnimation getAttackAnimation() {
        return this.getWalkAnimation();
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82400_(2.0);
    }

    protected float m_6121_() {
        return 0.25f * this.soundVolume;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    protected void m_7486_() {
        if (this.getIsFlying()) {
            this.playFlapSound();
        } else {
            this.playJumpSound2();
        }
    }

    protected void playJumpSound2() {
        this.m_5496_((SoundEvent)Sounds.JUMP.get(), this.m_6121_(), 1.0f);
    }

    protected void playFlapSound() {
        this.m_5496_((SoundEvent)Sounds.WING_FLAP.get(), this.m_6121_(), 1.0f);
    }

    protected SoundEvent m_7872_() {
        return SoundEvents.f_11912_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11918_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_11917_;
    }

    protected SoundEvent m_5508_() {
        return this.m_5509_();
    }

    protected SoundEvent getLandSound() {
        return (SoundEvent)Sounds.JUMP.get();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12233_;
    }

    protected SoundEvent m_7871_() {
        return SoundEvents.f_12619_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public boolean isBreedingItem(ItemStack stack) {
        return Arrays.asList(this.breedingItems).contains(stack.m_41720_());
    }

    public boolean isTamingItem(ItemStack stack) {
        return Arrays.asList(this.tamingItems).contains(stack.m_41720_());
    }

    public boolean isEdibleItem(ItemStack stack) {
        return Arrays.asList(this.foodItems).contains(stack.m_41720_());
    }

    public boolean m_35506_() {
        return !this.m_217005_() && this.m_20202_() == null && this.m_30614_() && !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        MountEntity childEntity;
        MountEntity otherParent = null;
        if (entity instanceof MountEntity) {
            otherParent = (MountEntity)entity;
        }
        if ((childEntity = (MountEntity)this.m_6095_().m_20615_((Level)world)) != null) {
            this.m_149508_(entity, (AbstractHorse)childEntity);
            if (otherParent != null) {
                childEntity.setVariant(childEntity.getRandomTexture(this, otherParent));
                childEntity.setSpecialNum(childEntity.getRandomSpecialNum(this.getSpecialNum(), otherParent.getSpecialNum()));
            } else {
                childEntity.setVariant(childEntity.getRandomTexture(this));
                childEntity.setSpecialNum(childEntity.getRandomSpecialNum());
            }
            childEntity.setIsDomesticated(true);
        }
        return childEntity;
    }

    public boolean m_7848_(Animal other) {
        if (other == this) {
            return false;
        }
        if (!(other instanceof MountEntity)) {
            return false;
        }
        if (other.m_6095_() != this.m_6095_()) {
            return false;
        }
        MountEntity a = (MountEntity)other;
        return this.m_35506_() && ((MountEntity)other).m_35506_();
    }

    public void m_6863_(boolean baby) {
        super.m_6863_(baby);
        this.setIsMini(this.getIsMini());
    }

    public float m_6134_() {
        if (this.m_6162_()) {
            return 0.5f;
        }
        if (this.getIsMini()) {
            return 0.375f;
        }
        return 1.0f;
    }

    public void m_30232_() {
        super.m_30232_();
        this.setIsMini(this.getIsMini());
    }

    public static AttributeSupplier setAttributes(Entities.EntityKey mountKey) {
        Random random = new Random();
        float speed = MountEntity.calcSpeedStat(mountKey);
        float health = (float)(Settings.settings.get((Object)((Object)mountKey)).health + (double)random.nextInt(6) + (double)random.nextInt(6));
        float jump = (float)(((double)0.4f + random.nextDouble() * (double)0.2f + random.nextDouble() * (double)0.2f + random.nextDouble() * (double)0.2f) * 1.25);
        return Animal.m_21552_().m_22268_(Attributes.f_22288_, (double)jump).m_22268_(Attributes.f_22279_, (double)speed).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22276_, (double)health).m_22268_(Attributes.f_22281_, Settings.settings.get((Object)((Object)mountKey)).attack).m_22265_();
    }

    public static ArrayList<String> getStats(Entities.EntityKey mountKey) {
        ArrayList<String> stats = new ArrayList<String>();
        stats.add("Health: " + Settings.settings.get((Object)((Object)mountKey)).health);
        stats.add("Speed: " + (double)Math.round(MountEntity.calcMinSpeedStat(mountKey) * 100.0f) / 100.0);
        stats.add("Attack: " + Settings.settings.get((Object)((Object)mountKey)).attack);
        stats.add("Inventory: " + Settings.settings.get((Object)((Object)mountKey)).inventorySize * 3);
        stats.add("Hostile to players: " + (Settings.settings.get((Object)((Object)mountKey)).playerHostile ? "yes" : "no"));
        Object mobStr = "no";
        if (Settings.settings.get((Object)((Object)mountKey)).mobHostile.length > 0) {
            mobStr = "";
            for (EntityType e : Settings.settings.get((Object)((Object)mountKey)).mobHostile) {
                mobStr = (String)mobStr + "$(br)" + e.m_20676_().getString();
            }
        }
        stats.add("Hostile to mobs: " + (String)mobStr);
        return stats;
    }

    protected void m_214179_(RandomSource random) {
        super.m_214179_(random);
        double healthFactor = Settings.globalSettings.healthRange / 2.0;
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(Settings.settings.get((Object)((Object)this.mountKey)).health + (double)this.f_19796_.m_188503_((int)Math.floor(healthFactor)) + (double)this.f_19796_.m_188503_((int)Math.ceil(healthFactor)));
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)MountEntity.calcSpeedStat(this.mountKey));
        Objects.requireNonNull(this.m_21051_(Attributes.f_22288_)).m_22100_(MountEntity.generateJumpStrength(() -> ((RandomSource)random).m_188500_()) * 1.25);
    }

    protected static float calcMinSpeedStat(Entities.EntityKey mountKey) {
        float minFactor = 0.5f;
        double speedFactor = Settings.globalSettings.speedRange / 3.0;
        float min = (float)((Settings.settings.get((Object)((Object)mountKey)).speed + (double)minFactor * speedFactor + (double)minFactor * speedFactor + (double)minFactor * speedFactor) * 0.25);
        return min;
    }

    protected static float calcSpeedStat(Entities.EntityKey mountKey) {
        float min;
        double speedFactor = Settings.globalSettings.speedRange / 3.0;
        double res = (Settings.settings.get((Object)((Object)mountKey)).speed + Math.random() * speedFactor + Math.random() * speedFactor + Math.random() * speedFactor) * 0.25;
        if (res < (double)(min = MountEntity.calcMinSpeedStat(mountKey))) {
            res = min;
        }
        return (float)res;
    }

    protected static double generateJumpStrength(DoubleSupplier rand) {
        double jumpFactor = Settings.globalSettings.jumpRange / 3.0;
        return 0.4 + rand.getAsDouble() * jumpFactor + rand.getAsDouble() * jumpFactor + rand.getAsDouble() * jumpFactor;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        if (this.settings.spawnDebug || Settings.globalSettings.debug) {
            System.out.println("finalizeSpawn() for " + this.mountKey + " " + this.m_20182_());
        }
        if (!(entityData instanceof MountData)) {
            entityData = new MountData(this.getTextureVariant(), false, false, false, Settings.globalSettings.mountedFlightAllowed, false, false, false, false, 0, 0, 0, this.getRandomSpecialNum());
        }
        MountData data = (MountData)((Object)entityData);
        data.read(this);
        if (this.getIsFlying()) {
            this.setOwnerToldToSit(false);
            this.setIsSitting(false);
            this.setIsSleeping(false);
        }
        this.m_6863_(this.m_6162_());
        this.setIsMini(data.isMini);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DOMESTICATED, (Object)false);
        this.f_19804_.m_135372_(IS_MINI, (Object)false);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(IS_SITTING, (Object)false);
        this.f_19804_.m_135372_(OWNER_TOLD_TO_SIT, (Object)false);
        this.f_19804_.m_135372_(IS_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(IS_CLIMBING, (Object)false);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)"");
        this.f_19804_.m_135372_(HAS_TRACKED_POS, (Object)false);
        this.f_19804_.m_135372_(FLIGHT_ALLOWED, (Object)true);
        this.f_19804_.m_135372_(TRACKED_POS_X, (Object)0);
        this.f_19804_.m_135372_(TRACKED_POS_Y, (Object)0);
        this.f_19804_.m_135372_(TRACKED_POS_Z, (Object)0);
        this.f_19804_.m_135372_(SPECIAL_NUM, (Object)0);
        this.f_19804_.m_135372_(CHEST, (Object)true);
        this.f_19804_.m_135372_(SHOULDFOLLOW, (Object)false);
    }

    public static float getKnockbackResistance() {
        return 0.95f;
    }

    public boolean getIsMini() {
        return (Boolean)this.f_19804_.m_135370_(IS_MINI);
    }

    public void setIsMini(boolean isMini) {
        this.f_19804_.m_135381_(IS_MINI, (Object)isMini);
        this.m_6210_();
        if (this.m_6162_() || this.getIsMini()) {
            this.m_20011_(this.m_6972_(this.m_20089_()).m_20388_(this.childScale).m_20393_(this.m_20318_(0.0f)));
        } else {
            this.m_20011_(this.m_6972_(this.m_20089_()).m_20393_(this.m_20318_(0.0f)));
        }
    }

    public boolean getIsDomesticated() {
        return (Boolean)this.f_19804_.m_135370_(DOMESTICATED);
    }

    public void setIsDomesticated(boolean isDomesticated) {
        this.f_19804_.m_135381_(DOMESTICATED, (Object)isDomesticated);
    }

    public boolean getTrackedAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void setTrackedAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }

    public boolean getIsSitting() {
        return (Boolean)this.f_19804_.m_135370_(IS_SITTING);
    }

    public void setIsSitting(boolean setSitting) {
        this.f_19804_.m_135381_(IS_SITTING, (Object)setSitting);
    }

    public boolean getOwnerToldToSit() {
        return (Boolean)this.f_19804_.m_135370_(OWNER_TOLD_TO_SIT);
    }

    public void setOwnerToldToSit(boolean setSitting) {
        this.f_19804_.m_135381_(OWNER_TOLD_TO_SIT, (Object)setSitting);
        this.setIsSitting(setSitting);
    }

    public boolean getIsSleeping() {
        return (Boolean)this.f_19804_.m_135370_(IS_SLEEPING);
    }

    public void setIsSleeping(boolean setAsleep) {
        this.f_19804_.m_135381_(IS_SLEEPING, (Object)setAsleep);
        if (setAsleep && !this.getIsSitting()) {
            this.setIsSitting(true);
        }
    }

    public boolean m_21515_() {
        return !this.m_5803_() && !this.m_9236_().f_46443_ && !this.m_21525_();
    }

    public boolean shouldMove() {
        return !this.getIsSitting();
    }

    public void printMovementStates() {
        System.out.println("Can Move: " + this.shouldMove() + "; Sitting: " + this.getIsSitting() + "; Sleeping: " + this.getIsSleeping() + "; Flying: " + this.getIsFlying());
    }

    public boolean getIsFlying() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setIsFlying(boolean flying) {
        this.f_19804_.m_135381_(IS_FLYING, (Object)flying);
    }

    public boolean getIsClimbing() {
        return (Boolean)this.f_19804_.m_135370_(IS_CLIMBING);
    }

    public void setIsClimbing(boolean setSitting) {
        this.f_19804_.m_135381_(IS_CLIMBING, (Object)setSitting);
    }

    public boolean getShouldFollow() {
        return (Boolean)this.f_19804_.m_135370_(SHOULDFOLLOW);
    }

    public void setShouldFollow(boolean shouldFollow) {
        this.f_19804_.m_135381_(SHOULDFOLLOW, (Object)shouldFollow);
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(CHEST);
    }

    public void setHasChest(boolean hasChest) {
        this.f_19804_.m_135381_(CHEST, (Object)hasChest);
    }

    public String getTextureFile() {
        return "textures/model/entity/" + this.getTextureVariant();
    }

    public String getDefaultTexture() {
        return "textures/model/entity/direwolf_mount.png";
    }

    public String getArmorTextureFile() {
        Object texture = this.armorTextureBaseStr;
        if (this.m_7481_()) {
            Item equippedArmor = this.m_30722_().m_41720_();
            texture = equippedArmor.equals(Items.f_42654_) || equippedArmor.equals(Items.f_42408_) ? (String)texture + "_leather.png" : (equippedArmor.equals(Items.f_42651_) || equippedArmor.equals(Items.f_42469_) ? (String)texture + "_iron.png" : (equippedArmor.equals(Items.f_42652_) || equippedArmor.equals(Items.f_42477_) ? (String)texture + "_gold.png" : (equippedArmor.equals(Items.f_42653_) || equippedArmor.equals(Items.f_42473_) ? (String)texture + "_diamond.png" : (String)texture + "_other.png")));
        }
        return texture;
    }

    public String[] getOverlays() {
        return null;
    }

    protected String getRandomTexture() {
        return this.textures.get(this.f_19796_.m_188503_(this.textures.size()));
    }

    protected String getRandomTexture(MountEntity m) {
        return this.f_19796_.m_188499_() ? m.getTextureVariant() : this.textures.get(this.f_19796_.m_188503_(this.textures.size()));
    }

    protected String getRandomTexture(MountEntity m1, MountEntity m2) {
        if (this.f_19796_.m_188500_() < 0.25) {
            return this.textures.get(this.f_19796_.m_188503_(this.textures.size()));
        }
        return this.f_19796_.m_188499_() ? m1.getTextureVariant() : m2.getTextureVariant();
    }

    public void setVariant(String variant) {
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)variant);
    }

    public String getTextureVariant() {
        String res = (String)this.f_19804_.m_135370_(TEXTURE_VARIANT);
        if (res.length() <= 0 && !this.m_9236_().f_46443_) {
            res = this.getRandomTexture();
            this.setVariant(res);
        }
        return res;
    }

    public Boolean getHasTrackedPos() {
        return (Boolean)this.f_19804_.m_135370_(HAS_TRACKED_POS);
    }

    public void setHasTrackedPos(boolean hasPos) {
        this.f_19804_.m_135381_(HAS_TRACKED_POS, (Object)hasPos);
    }

    public Boolean getFlightAllowed() {
        return (Boolean)this.f_19804_.m_135370_(FLIGHT_ALLOWED);
    }

    public void setFlightAllowed(boolean flightAllowed) {
        this.f_19804_.m_135381_(FLIGHT_ALLOWED, (Object)flightAllowed);
    }

    public Vec3i getTrackedPos() {
        Integer posX = (Integer)this.f_19804_.m_135370_(TRACKED_POS_X);
        Integer posY = (Integer)this.f_19804_.m_135370_(TRACKED_POS_Y);
        Integer posZ = (Integer)this.f_19804_.m_135370_(TRACKED_POS_Z);
        return new Vec3i(posX.intValue(), posY.intValue(), posZ.intValue());
    }

    protected int getRandomSpecialNum() {
        return 0;
    }

    protected int getRandomSpecialNum(int num1, int num2) {
        return 0;
    }

    protected int getSpecialNum() {
        return (Integer)this.f_19804_.m_135370_(SPECIAL_NUM);
    }

    protected void setSpecialNum(int num) {
        this.f_19804_.m_135381_(SPECIAL_NUM, (Object)num);
    }

    protected void setTrackedPos(int x, int y, int z) {
        this.f_19804_.m_135381_(TRACKED_POS_X, (Object)x);
        this.f_19804_.m_135381_(TRACKED_POS_Y, (Object)y);
        this.f_19804_.m_135381_(TRACKED_POS_Z, (Object)z);
    }

    protected void setTrackedPos(BlockPos pos) {
        this.f_19804_.m_135381_(TRACKED_POS_X, (Object)pos.m_123341_());
        this.f_19804_.m_135381_(TRACKED_POS_Y, (Object)pos.m_123342_());
        this.f_19804_.m_135381_(TRACKED_POS_Z, (Object)pos.m_123343_());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Variant", this.getTextureVariant());
        tag.m_128379_("IsDomesticated", this.getIsDomesticated());
        tag.m_128379_("IsMini", this.getIsMini());
        tag.m_128379_("HasTrackedPos", this.getHasTrackedPos().booleanValue());
        tag.m_128379_("IsFlying", this.getIsFlying());
        tag.m_128379_("ShouldFollow", this.getShouldFollow());
        tag.m_128379_("IsClimbing", this.getIsClimbing());
        tag.m_128379_("IsSitting", this.getIsSitting());
        tag.m_128379_("OwnerToldToSit", this.getOwnerToldToSit());
        Vec3i trackedPos = this.getTrackedPos();
        tag.m_128405_("TrackedPosX", trackedPos.m_123341_());
        tag.m_128405_("TrackedPosY", trackedPos.m_123342_());
        tag.m_128405_("TrackedPosZ", trackedPos.m_123343_());
        tag.m_128405_("SpecialNum", this.getSpecialNum());
        tag.m_128379_("ChestedHorse", this.hasChest());
        if (this.hasChest()) {
            ListTag ListTag2 = new ListTag();
            for (int i = 2; i < this.f_30520_.m_6643_(); ++i) {
                ItemStack itemStack = this.f_30520_.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                CompoundTag CompoundTag2 = new CompoundTag();
                CompoundTag2.m_128344_("Slot", (byte)i);
                itemStack.m_41739_(CompoundTag2);
                ListTag2.add((Object)CompoundTag2);
            }
            tag.m_128365_("Items", (Tag)ListTag2);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128461_("Variant"));
        this.setIsDomesticated(tag.m_128471_("IsDomesticated"));
        this.setIsMini(tag.m_128471_("IsMini"));
        this.setIsFlying(tag.m_128471_("IsFlying"));
        this.setIsClimbing(tag.m_128471_("IsClimbing"));
        this.setIsSitting(tag.m_128471_("IsSitting"));
        this.setShouldFollow(tag.m_128471_("ShouldFollow"));
        this.setOwnerToldToSit(tag.m_128471_("OwnerToldToSit"));
        this.setHasTrackedPos(tag.m_128471_("HasTrackedPos"));
        int x = tag.m_128451_("TrackedPosX");
        int y = tag.m_128451_("TrackedPosY");
        int z = tag.m_128451_("TrackedPosZ");
        this.setTrackedPos(x, y, z);
        this.setSpecialNum(tag.m_128451_("SpecialNum"));
        this.setHasChest(tag.m_128471_("ChestedHorse"));
        this.m_30625_();
        if (this.hasChest()) {
            ListTag listTag = tag.m_128437_("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                int j = compoundTag.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.f_30520_.m_6643_()) continue;
                this.f_30520_.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundTag));
            }
        }
        this.m_7493_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (Settings.globalSettings.friendlyFireProtection && source.m_7639_() != null && source.m_7639_().equals((Object)this.getOwner())) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.setIsSleeping(false);
        this.setIsSitting(false);
        return super.m_6469_(source, amount);
    }

    public boolean m_142535_(float checkFallDamageDistance, float hurtMultiplier, DamageSource hurtSource) {
        int i;
        if (checkFallDamageDistance > 1.0f) {
            this.m_5496_(this.getLandSound(), this.m_6121_(), 1.0f);
        }
        if ((i = this.m_5639_(checkFallDamageDistance, hurtMultiplier)) <= 0) {
            return false;
        }
        this.m_6469_(hurtSource, i);
        if (this.m_217005_()) {
            for (Entity entity : this.m_20197_()) {
                entity.m_6469_(hurtSource, (float)i);
            }
        }
        this.m_21229_();
        return !this.canFly;
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.getIsSitting()) {
            super.m_7023_(Vec3.f_82478_);
        }
        super.m_7023_(movementInput);
    }

    public boolean isBeingRidden() {
        return this.m_217005_() && this.m_30614_() && this.m_6254_();
    }

    public boolean m_20142_() {
        if (this.m_6688_() != null) {
            return this.m_6688_().m_20142_();
        }
        return super.m_20142_();
    }

    public boolean isOwner(LivingEntity entity) {
        return entity.m_20148_().equals(this.m_21805_());
    }

    public Player getOwner() {
        return this.m_21805_() == null ? null : this.m_9236_().m_46003_(this.m_21805_());
    }

    public void m_27595_(Player player) {
        this.m_6710_(null);
        this.setTrackedPos(this.m_20097_());
        super.m_27595_(player);
    }

    public boolean m_6914_(LevelReader levelReader) {
        return true;
    }

    public boolean m_5545_(LevelAccessor p_21686_, MobSpawnType p_21687_) {
        return true;
    }

    public int getRealInventorySize() {
        if (this.settings.inventorySize >= 10) {
            return 56;
        }
        return 3 * this.settings.inventorySize + 2;
    }

    public int m_7506_() {
        return 56;
    }

    public int getInventoryColumns() {
        return this.settings.inventorySize;
    }

    public SimpleContainer getItemInventory() {
        return this.f_30520_;
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_30614_()) {
            this.openGUI(player);
        }
    }

    protected void dropChestInventory() {
        if (this.f_30520_ != null) {
            int a = 0;
            if (this.m_7481_()) {
                ++a;
            }
            if (this.m_6254_()) {
                ++a;
            }
            for (int i = a; i < this.f_30520_.m_6643_(); ++i) {
                ItemStack itemStack = this.f_30520_.m_8020_(i);
                if (!itemStack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemStack)) {
                    this.m_19983_(itemStack);
                }
                this.f_30520_.m_6836_(i, ItemStack.f_41583_);
            }
        }
        if (this.hasChest()) {
            this.m_5552_(new ItemStack((ItemLike)Items.f_42009_, 1), 1.0f);
            this.m_5496_((SoundEvent)Sounds.CHEST_EQUIPS.get(), this.m_6121_(), 1.0f);
        }
        this.setHasChest(false);
    }

    protected void m_30625_() {
        SimpleContainer simpleInventory = this.f_30520_;
        this.f_30520_ = new SimpleContainer(this.m_7506_());
        if (simpleInventory != null) {
            simpleInventory.m_19181_((ContainerListener)this);
            int i = Math.min(simpleInventory.m_6643_(), this.f_30520_.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemStack = simpleInventory.m_8020_(j);
                if (itemStack.m_41619_()) continue;
                this.f_30520_.m_6836_(j, itemStack.m_41777_());
            }
        }
        this.f_30520_.m_19164_((ContainerListener)this);
        this.m_7493_();
    }

    protected boolean canEatFood(Item item) {
        return this.isTamingItem(item.m_7968_()) || this.isEdibleItem(item.m_7968_()) || this.isBreedingItem(item.m_7968_());
    }

    protected void showEmoteParticle(SimpleParticleType type) {
        for (int i = 0; i < 7; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            if (this.m_9236_().f_46443_) continue;
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)type, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d, e, f, 0.005);
        }
    }

    public void onDismounted() {
        BlockPos pos = this.m_20097_();
        this.setTrackedPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public void onMounted() {
        this.setIsSitting(false);
        this.setIsSleeping(false);
        BlockPos pos = this.m_20097_();
        this.setTrackedPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public double m_6048_() {
        if (this.getIsMini()) {
            return this.miniYOffset;
        }
        return super.m_6048_();
    }

    public void m_7350_(EntityDataAccessor<?> p_146754_) {
        super.m_7350_(p_146754_);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new MountScreenHandler(syncId, playerInventory, this);
    }

    public Vec3 m_7939_() {
        Vec3 attachPoint = new Vec3(0.0, (double)this.m_20192_() * (double)this.leashYOffset, (double)(this.m_20205_() * this.leashZOffset));
        if (this.m_6162_()) {
            attachPoint = new Vec3(0.0, (double)this.m_20192_() * (double)this.leashYOffset, (double)(this.m_20205_() * this.leashZOffset * this.childLeashZOffset));
        }
        if (this.getIsSitting()) {
            attachPoint = new Vec3(attachPoint.f_82479_, attachPoint.f_82480_ * (double)this.sittingLeashYOffset, attachPoint.f_82481_);
        }
        return attachPoint;
    }

    static {
        TEXTURE_VARIANT = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        HAS_TRACKED_POS = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        FLIGHT_ALLOWED = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        TRACKED_POS_X = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TRACKED_POS_Y = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TRACKED_POS_Z = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SPECIAL_NUM = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CHEST = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SHOULDFOLLOW = SynchedEntityData.m_135353_(MountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

