/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yahoo.chirpycricket.mythicmounts.client.renderer.entity.LeashRenderer;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class MountRenderer
extends GeoEntityRenderer<MountEntity> {
    LeashRenderer leashRender;
    boolean glowing = false;
    float shadRad = 1.0f;

    public MountRenderer(EntityRendererProvider.Context renderManager, GeoModel<MountEntity> modelProvider, float shadowRadius) {
        super(renderManager, modelProvider);
        this.f_114477_ = shadowRadius;
        this.shadRad = shadowRadius;
        this.addRenderLayer(new ArmorOverlayFeatureRenderer((GeoRenderer<MountEntity>)this, new ArmorOverlayEntityRenderer(renderManager, modelProvider)));
    }

    public MountRenderer(EntityRendererProvider.Context renderManager, GeoModel<MountEntity> modelProvider, float shadowRadius, boolean glow) {
        super(renderManager, modelProvider);
        this.f_114477_ = shadowRadius;
        this.shadRad = shadowRadius;
        this.glowing = glow;
        this.addRenderLayer(new ArmorOverlayFeatureRenderer((GeoRenderer<MountEntity>)this, new ArmorOverlayEntityRenderer(renderManager, modelProvider)));
    }

    public void render(MountEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        this.f_114477_ = entity.m_6162_() || entity.getIsMini() ? this.shadRad * entity.childScale : this.shadRad;
        if (this.glowing) {
            super.m_7392_((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, 255);
        } else {
            super.m_7392_((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
    }

    public ResourceLocation getTextureLocation(MountEntity entity) {
        Object filename = entity.getTextureFile() != null && !entity.getTextureFile().equals("") && !entity.getTextureFile().equals("textures/model/entity/") ? entity.getTextureFile() : "textures/model/entity/" + entity.getDefaultTexture();
        return new ResourceLocation("mythicmounts", (String)filename);
    }

    public RenderType getRenderType(MountEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        String guiBookClass = "class vazkii.patchouli.client.book.gui.GuiBookEntry";
        if (Minecraft.m_91087_().f_91080_ != null && Minecraft.m_91087_().f_91080_.getClass().toString().equals("class vazkii.patchouli.client.book.gui.GuiBookEntry")) {
            return super.getRenderType((GeoAnimatable)animatable, texture, bufferSource, partialTick);
        }
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    public class ArmorOverlayFeatureRenderer
    extends GeoRenderLayer<MountEntity> {
        private final ArmorOverlayEntityRenderer armorOverlayEntityRenderer;
        ResourceLocation armorTextureLocation;

        public ArmorOverlayFeatureRenderer(GeoRenderer<MountEntity> entityRendererIn, ArmorOverlayEntityRenderer armorOverlayEntityRenderer) {
            super(entityRendererIn);
            this.armorTextureLocation = null;
            this.armorOverlayEntityRenderer = armorOverlayEntityRenderer;
        }

        public void render(PoseStack poseStack, MountEntity mountEntity, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            String[] overlays = mountEntity.getOverlays();
            if (overlays != null && overlays.length > 0) {
                this.armorOverlayEntityRenderer.useTint = false;
                for (String overlay : overlays) {
                    if (overlay.length() <= 0) continue;
                    this.armorTextureLocation = new ResourceLocation("mythicmounts", overlay);
                    this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)mountEntity, renderType, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.armorTextureLocation)), partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            if (mountEntity.m_7481_()) {
                this.armorTextureLocation = new ResourceLocation("mythicmounts", mountEntity.getArmorTextureFile());
                Item equippedArmor = mountEntity.m_30722_().m_41720_();
                float a = 1.0f;
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (equippedArmor instanceof DyeableArmorItem) {
                    DyeableArmorItem c = (DyeableArmorItem)equippedArmor;
                    int m = c.m_41121_(mountEntity.m_30722_());
                    r = (float)(m >> 16 & 0xFF) / 255.0f;
                    g = (float)(m >> 8 & 0xFF) / 255.0f;
                    b = (float)(m & 0xFF) / 255.0f;
                }
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)mountEntity, renderType, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.armorTextureLocation)), partialTick, packedLight, packedOverlay, r, g, b, a);
            }
        }
    }

    public class ArmorOverlayEntityRenderer
    extends GeoEntityRenderer<MountEntity> {
        public boolean useTint;

        protected ArmorOverlayEntityRenderer(EntityRendererProvider.Context ctx, GeoModel<MountEntity> modelProvider) {
            super(ctx, modelProvider);
            this.useTint = false;
        }
    }
}

