/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts;

import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.screen.MountScreenHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="mythicmounts", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonListener {
    public static final MenuType<MountScreenHandler> MOUNT_SCREEN_HANDLER = IForgeMenuType.create((windowId, inv, data) -> {
        Entity entity = inv.f_35978_.m_9236_().m_6815_(data.readInt());
        if (entity instanceof MountEntity) {
            return new MountScreenHandler(windowId, inv, (MountEntity)entity);
        }
        return null;
    });

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        Entities.initEntityTypes();
        for (Entities.EntityInfo entry : Entities.EntityInfo.values()) {
            event.put((EntityType)entry.type.get(), MountEntity.setAttributes(entry.key));
        }
    }

    @SubscribeEvent
    public static void onContainerTypeRegistry(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.MENU_TYPES, helper -> helper.register(new ResourceLocation("mythicmounts", "mount_inventory"), MOUNT_SCREEN_HANDLER));
    }

    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            event.accept(Entities.FIREBIRD_FEATHER_ITEM);
            event.accept(Entities.FIREBIRD_FEATHER_ITEM2);
            event.accept(Entities.FIREBIRD_FEATHER_ITEM3);
            event.accept(Entities.FIREBIRD_FEATHER_ITEM4);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(Entities.SUMMONING_STAFF_ITEM);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.accept(Entities.ACENCIA_EGG_ITEM);
            event.accept(Entities.ARCHELON_EGG_ITEM);
            event.accept(Entities.COLELYTRA_EGG_ITEM);
            event.accept(Entities.DIREWOLF_EGG_ITEM);
            event.accept(Entities.DRAGON_EGG_ITEM);
            event.accept(Entities.FIREBIRD_EGG_ITEM);
            event.accept(Entities.GECKOTOA_EGG_ITEM);
            event.accept(Entities.GRIFFON_EGG_ITEM);
            event.accept(Entities.MOTH_EGG_ITEM);
            event.accept(Entities.NIGHTMARE_EGG_ITEM);
            event.accept(Entities.NUDIBRANCH_EGG_ITEM);
            event.accept(Entities.COURIER_BIRD_EGG_ITEM);
            event.accept(Entities.NETHER_BAT_EGG_ITEM);
            event.accept(Entities.RIDING_LIZARD_EGG_ITEM);
        }
    }
}

