/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.entity.collisions.movement;

import com.abdelaziz.canary.common.entity.CanaryEntityCollisions;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Redirect(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntityCollisions(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;"))
    private List<VoxelShape> getEntitiesLater(Level world, Entity entity, AABB box) {
        return List.of();
    }

    @Redirect(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"), require=5)
    private Vec3 adjustMovementForCollisionsGetEntitiesLater(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> collisions) {
        return EntityMixin.canaryCollideMultiAxisMovement(entity, movement, entityBoundingBox, world, true, collisions);
    }

    @Overwrite
    public static Vec3 m_198894_(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> collisions) {
        return EntityMixin.canaryCollideMultiAxisMovement(entity, movement, entityBoundingBox, world, false, collisions);
    }

    private static Vec3 canaryCollideMultiAxisMovement(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, boolean getEntityCollisions, List<VoxelShape> otherCollisions) {
        boolean velXSmallerVelZ;
        AABB movementSpace;
        boolean isVerticalOnly;
        double velX = movement.f_82479_;
        double velY = movement.f_82480_;
        double velZ = movement.f_82481_;
        boolean bl = isVerticalOnly = velX == 0.0 && velZ == 0.0;
        if (isVerticalOnly) {
            if (velY < 0.0) {
                double v;
                VoxelShape voxelShape = CanaryEntityCollisions.getCollisionShapeBelowEntity(world, entity, entityBoundingBox);
                if (voxelShape != null && (v = voxelShape.m_83259_(Direction.Axis.Y, entityBoundingBox, velY)) == 0.0) {
                    return Vec3.f_82478_;
                }
                movementSpace = new AABB(entityBoundingBox.f_82288_, entityBoundingBox.f_82289_ + velY, entityBoundingBox.f_82290_, entityBoundingBox.f_82291_, entityBoundingBox.f_82289_, entityBoundingBox.f_82293_);
            } else {
                movementSpace = new AABB(entityBoundingBox.f_82288_, entityBoundingBox.f_82292_, entityBoundingBox.f_82290_, entityBoundingBox.f_82291_, entityBoundingBox.f_82292_ + velY, entityBoundingBox.f_82293_);
            }
        } else {
            movementSpace = entityBoundingBox.m_82369_(movement);
        }
        List<VoxelShape> blockCollisions = CanaryEntityCollisions.getBlockCollisions(world, entity, movementSpace);
        List<VoxelShape> entityWorldBorderCollisions = null;
        if (velY != 0.0 && (velY = Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)entityBoundingBox, blockCollisions, (double)velY)) != 0.0) {
            if (!otherCollisions.isEmpty()) {
                velY = Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)entityBoundingBox, otherCollisions, (double)velY);
            }
            if (velY != 0.0 && getEntityCollisions) {
                entityWorldBorderCollisions = CanaryEntityCollisions.getEntityWorldBorderCollisions(world, entity, movementSpace, entity != null);
                velY = Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)entityBoundingBox, entityWorldBorderCollisions, (double)velY);
            }
            if (velY != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82386_(0.0, velY, 0.0);
            }
        }
        boolean bl2 = velXSmallerVelZ = Math.abs(velX) < Math.abs(velZ);
        if (velXSmallerVelZ && (velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, blockCollisions, (double)velZ)) != 0.0) {
            if (!otherCollisions.isEmpty()) {
                velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, otherCollisions, (double)velZ);
            }
            if (velZ != 0.0 && getEntityCollisions) {
                if (entityWorldBorderCollisions == null) {
                    entityWorldBorderCollisions = CanaryEntityCollisions.getEntityWorldBorderCollisions(world, entity, movementSpace, entity != null);
                }
                velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, entityWorldBorderCollisions, (double)velZ);
            }
            if (velZ != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82386_(0.0, 0.0, velZ);
            }
        }
        if (velX != 0.0 && (velX = Shapes.m_193135_((Direction.Axis)Direction.Axis.X, (AABB)entityBoundingBox, blockCollisions, (double)velX)) != 0.0) {
            if (!otherCollisions.isEmpty()) {
                velX = Shapes.m_193135_((Direction.Axis)Direction.Axis.X, (AABB)entityBoundingBox, otherCollisions, (double)velX);
            }
            if (velX != 0.0 && getEntityCollisions) {
                if (entityWorldBorderCollisions == null) {
                    entityWorldBorderCollisions = CanaryEntityCollisions.getEntityWorldBorderCollisions(world, entity, movementSpace, entity != null);
                }
                velX = Shapes.m_193135_((Direction.Axis)Direction.Axis.X, (AABB)entityBoundingBox, entityWorldBorderCollisions, (double)velX);
            }
            if (velX != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82386_(velX, 0.0, 0.0);
            }
        }
        if (!velXSmallerVelZ && velZ != 0.0 && (velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, blockCollisions, (double)velZ)) != 0.0) {
            if (!otherCollisions.isEmpty()) {
                velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, otherCollisions, (double)velZ);
            }
            if (velZ != 0.0 && getEntityCollisions) {
                if (entityWorldBorderCollisions == null) {
                    entityWorldBorderCollisions = CanaryEntityCollisions.getEntityWorldBorderCollisions(world, entity, movementSpace, entity != null);
                }
                velZ = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, entityWorldBorderCollisions, (double)velZ);
            }
        }
        return new Vec3(velX, velY, velZ);
    }
}

