/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.fight;

import com.cupboard.util.BlockSearch;
import com.dragonfight.DragonfightMod;
import com.dragonfight.config.CommonConfiguration;
import com.dragonfight.config.ConfigurationCache;
import com.dragonfight.fight.CrystalLevelData;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonDeathPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DragonFightManagerCustom {
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnCrystalDeath = ImmutableList.of();
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnCrystalRespawn = ImmutableList.of();
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnDragonSitting = ImmutableList.of();
    private static final float CRYSTAL_RESPAWN_TIME = 8000.0f;
    private static final int LIGHTNING_DESTROY_RANGE = 100;
    private static final int ADD_TIMER = 2000;
    private static BlockPos crystalRespawnPos = null;
    private static int crystalRespawnTimer = 0;
    private static int timeSinceLastLanding = 0;
    private static boolean spawnAdds = false;
    private static final BlockPos spawnPos = new BlockPos(0, 68, 0);
    private static int spawnCounter = 0;
    private static List<LivingEntity> meleeAdds = new ArrayList<LivingEntity>();
    private static int advancingLightningCurrent = 0;
    private static int advancingLightningStop = 0;
    private static int advancingExplosionCurrent = 0;
    private static int advancingExplosionStop = 0;
    private static EnderDragon dragonEntity = null;
    public static boolean isFightRunning = true;
    public static AttributeModifier AA_GRAVITY_MOD = new AttributeModifier("fall", 5.0, AttributeModifier.Operation.ADDITION);
    private static AttributeModifier MAX_HP_MOD = new AttributeModifier("dragonhp", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static Map<UUID, Integer> flyingPlayers = new HashMap<UUID, Integer>();

    public static void onCrystalDeath(EndCrystal enderCrystalEntity, DamageSource damageSource) {
        if (enderCrystalEntity.m_20182_().m_82554_(new Vec3(0.0, 65.0, 0.0)) < 30.0 || CrystalLevelData.getForLevel((ServerLevel)enderCrystalEntity.m_9236_()).isIgnored(enderCrystalEntity.m_20148_())) {
            return;
        }
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(enderCrystalEntity.m_9236_(), enderCrystalEntity.m_20185_(), enderCrystalEntity.m_20186_(), enderCrystalEntity.m_20189_());
        if (dragonEntity != null) {
            areaeffectcloudentity.m_19718_((LivingEntity)dragonEntity);
        }
        DragonFightManagerCustom.notifyPlayer(enderCrystalEntity.m_9236_(), "Crystal died from:" + damageSource);
        areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
        areaeffectcloudentity.m_19712_(1.0f);
        areaeffectcloudentity.m_19734_((int)((double)(8000.0f / (float)DragonFightManagerCustom.getDifficulty()) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).crystalRespawnTimeModifier));
        areaeffectcloudentity.m_19738_((5.0f - areaeffectcloudentity.m_19743_()) / (float)areaeffectcloudentity.m_19748_());
        areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 100, 1));
        areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffects.f_19610_, 100, 1));
        areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        enderCrystalEntity.m_9236_().m_7967_((Entity)areaeffectcloudentity);
        DragonFightManagerCustom.addCrystalRespawnPos(enderCrystalEntity.m_20183_());
        if (!(damageSource.m_7639_() instanceof Player)) {
            return;
        }
        if (damageSource.m_7639_().m_20183_().m_123331_((Vec3i)enderCrystalEntity.m_20183_()) > 100.0) {
            if (!((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning) {
                LightningBolt lightningboltentity = (LightningBolt)DragonFightManagerCustom.spawnEntity((ServerLevel)enderCrystalEntity.m_9236_(), new ConfigurationCache.EntitySpawnData(EntityType.f_20465_, null), damageSource.m_7639_().m_20182_());
                lightningboltentity.m_20874_(false);
            }
            if (!spawnOnCrystalDeath.isEmpty()) {
                int i = 0;
                while ((double)i < Math.max(1.0, (double)DragonFightManagerCustom.getDifficulty() / 4.0 * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).mobSpawnAmountModifier)) {
                    LivingEntity entity;
                    BlockPos searchedPos = BlockSearch.findAround((BlockGetter)enderCrystalEntity.m_9236_(), (BlockPos)damageSource.m_7639_().m_20183_().m_7918_(i + 1, 5, i + 1), (int)15, (int)15, (int)1, (level, checkPos) -> level.m_8055_(checkPos).m_60795_() && level.m_8055_(checkPos.m_7494_()).m_60795_());
                    if (searchedPos == null) {
                        searchedPos = damageSource.m_7639_().m_20183_();
                    }
                    if ((entity = (LivingEntity)DragonFightManagerCustom.spawnEntity((ServerLevel)enderCrystalEntity.m_9236_(), (ConfigurationCache.EntitySpawnData)spawnOnCrystalDeath.get(DragonfightMod.rand.nextInt(spawnOnCrystalDeath.size())), DragonFightManagerCustom.createVec3(searchedPos))) instanceof Mob) {
                        ((Mob)entity).m_6710_((LivingEntity)damageSource.m_7639_());
                    }
                    ++i;
                }
            }
        } else if (dragonEntity != null && dragonEntity.m_21223_() > 100.0f) {
            dragonEntity.m_21153_(dragonEntity.m_21223_() * 0.9f);
            float f = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (DragonfightMod.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            dragonEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, dragonEntity.m_20185_() + (double)f, dragonEntity.m_20186_() + 2.0 + (double)f1, dragonEntity.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
    }

    private static void addCrystalRespawnPos(BlockPos position) {
        if (dragonEntity == null || Math.sqrt(dragonEntity.m_20183_().m_123331_((Vec3i)position)) > 1000.0) {
            return;
        }
        CrystalLevelData.getForLevel((ServerLevel)dragonEntity.m_9236_()).addPosition(position);
    }

    private static Set<BlockPos> getCrystalRespawnPositions(ServerLevel level) {
        HashSet<BlockPos> existing = new HashSet<BlockPos>();
        for (BlockPos pos : CrystalLevelData.getForLevel(level).getCrystalPendingRespawns()) {
            if (dragonEntity != null && Math.sqrt(dragonEntity.m_20183_().m_123331_((Vec3i)pos)) > 1000.0) continue;
            existing.add(pos);
        }
        return existing;
    }

    public static void onWorldTick(Level world) {
        EndDragonFight manager = ((ServerLevel)world).m_8586_();
        if (manager == null || manager.f_64060_.m_8324_().isEmpty() || dragonEntity == null) {
            DragonFightManagerCustom.reset();
            return;
        }
        if (crystalRespawnPos != null) {
            if (--crystalRespawnTimer > 0) {
                if (crystalRespawnTimer == 200) {
                    DragonFightManagerCustom.spawnLightningAtCircle(crystalRespawnPos, 5, world);
                }
            } else {
                DragonFightManagerCustom.notifyPlayer(world, "Respawning crystal at" + crystalRespawnPos);
                DragonFightManagerCustom.respawnCrystalAt(crystalRespawnPos, world);
            }
        }
        if (dragonEntity.m_21223_() < dragonEntity.m_21233_() && dragonEntity.m_6084_()) {
            if (!isFightRunning && !manager.f_64060_.m_8324_().isEmpty()) {
                List monsterEntities = world.m_45976_(Monster.class, dragonEntity.m_20191_().m_82400_(150.0));
                for (Monster entity : monsterEntities) {
                    if (entity instanceof Npc || entity.m_21532_()) continue;
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                DragonFightManagerCustom.setDragonHealth();
                isFightRunning = true;
            }
        } else {
            if (isFightRunning) {
                DragonFightManagerCustom.reset();
            }
            isFightRunning = false;
        }
        if (!isFightRunning) {
            return;
        }
        if (dragonEntity.m_31157_().m_31415_() instanceof DragonDeathPhase && dragonEntity.m_31157_().m_31415_().m_5535_() != null && dragonEntity.m_31157_().m_31415_().m_5535_().m_82531_((double)dragonEntity.m_20183_().m_123341_(), (double)dragonEntity.m_20183_().m_123342_(), dragonEntity.m_20189_()) < 10.0) {
            dragonEntity.m_21153_(0.0f);
        }
        if (++timeSinceLastLanding > 2400 && dragonEntity != null) {
            timeSinceLastLanding = 0;
            dragonEntity.m_31157_().m_31416_(EnderDragonPhase.f_31379_);
            DragonFightManagerCustom.notifyPlayer(world, "Forcing landing phase");
        }
        if ((double)dragonEntity.m_21223_() > (double)dragonEntity.m_21233_() * 0.9) {
            return;
        }
        if (((CommonConfiguration)DragonfightMod.config.getCommonConfig()).antiflightAbility) {
            for (Player player : manager.f_64060_.m_8324_()) {
                int time = flyingPlayers.computeIfAbsent(player.m_20148_(), s -> 0);
                if (DragonFightManagerCustom.isFlying(player)) {
                    flyingPlayers.put(player.m_20148_(), ++time);
                    if (time == 300) {
                        flyingPlayers.put(player.m_20148_(), ++time);
                        player.m_213846_((Component)Component.m_237115_((String)"player.gravity.warn").m_130940_(ChatFormatting.DARK_PURPLE));
                        continue;
                    }
                    if (time == 400) {
                        flyingPlayers.put(player.m_20148_(), ++time);
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200));
                        player.m_213846_((Component)Component.m_237115_((String)"player.gravity.warn").m_130940_(ChatFormatting.DARK_PURPLE));
                        continue;
                    }
                    if (time <= 700) continue;
                    player.m_20256_(player.m_20184_().m_82520_(0.0, -1.0, 0.0));
                    player.f_19864_ = true;
                    continue;
                }
                if (time > 700) {
                    player.m_6469_(dragonEntity.m_269291_().m_268989_(), player.m_21233_() * 0.9f);
                    player.m_21153_(1.0f);
                    player.m_213846_((Component)Component.m_237115_((String)"player.gravity.hurt").m_130940_(ChatFormatting.RED));
                }
                flyingPlayers.put(player.m_20148_(), 0);
            }
        }
        if (advancingLightningCurrent > 0 && world.m_46467_() % 100L == 0L) {
            DragonFightManagerCustom.spawnLightningAtCircle(spawnPos, advancingLightningCurrent += 3, world);
            if (advancingLightningCurrent > advancingLightningStop) {
                advancingLightningCurrent = 0;
                advancingLightningStop = 0;
            }
        }
        if (dragonEntity != null && advancingExplosionCurrent == 0 && advancingLightningCurrent == 0) {
            double d = dragonEntity.m_21223_() / dragonEntity.m_21233_();
            double d2 = ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning ? 0.5 : 0.2;
            if (d < d2) {
                advancingExplosionCurrent = 8;
                advancingExplosionStop = 50;
            }
        }
        if (advancingExplosionCurrent > 0 && world.m_46467_() % 200L == 0L) {
            DragonFightManagerCustom.explodeInCircleAround(spawnPos, advancingExplosionCurrent += 3, world);
            if (advancingExplosionCurrent > advancingExplosionStop) {
                advancingExplosionCurrent = 0;
                advancingExplosionStop = 0;
            }
        }
        if (spawnAdds) {
            int n = spawnCounter++;
            if ((double)n > 2000.0 / ((double)DragonFightManagerCustom.getDifficulty() * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).mobSpawnAmountModifier)) {
                DragonFightManagerCustom.notifyPlayer(world, "Spawning melee add");
                DragonFightManagerCustom.spawnMeleeAdds(world);
                spawnCounter = 0;
            }
        }
    }

    private static void setDragonHealth() {
        double pct = dragonEntity.m_21223_() / dragonEntity.m_21233_();
        if (dragonEntity.m_21051_(Attributes.f_22276_).m_22109_(MAX_HP_MOD)) {
            dragonEntity.m_21051_(Attributes.f_22276_).m_22130_(MAX_HP_MOD);
        }
        MAX_HP_MOD = new AttributeModifier("dragonhp", (double)Math.max(1, DragonFightManagerCustom.getDifficulty() / 5) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonHealthModifier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        dragonEntity.m_21051_(Attributes.f_22276_).m_22118_(MAX_HP_MOD);
        dragonEntity.m_21153_((float)((double)dragonEntity.m_21233_() * pct));
    }

    private static boolean isFlying(Player player) {
        return player != null && (player.f_19812_ || !player.m_20096_()) && player.m_9236_().m_46859_(player.m_20183_().m_6625_(2)) && player.m_9236_().m_46859_(player.m_20183_()) && player.m_9236_().m_46859_(player.m_20183_().m_6625_(1));
    }

    private static void reset() {
        crystalRespawnPos = null;
        spawnAdds = false;
        spawnCounter = 0;
        for (LivingEntity living : meleeAdds) {
            living.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        for (UUID playerUUID : flyingPlayers.keySet()) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerUUID);
            if (player == null) continue;
            player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22130_(AA_GRAVITY_MOD);
        }
        flyingPlayers.clear();
        meleeAdds.clear();
    }

    private static void spawnMeleeAdds(Level world) {
        LivingEntity entity;
        meleeAdds.removeIf(Entity::m_213877_);
        if ((double)meleeAdds.size() >= (double)DragonFightManagerCustom.getDifficulty() * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).mobSpawnAmountModifier || spawnOnDragonSitting.isEmpty()) {
            return;
        }
        BlockPos searchedPos = BlockSearch.findAround((BlockGetter)world, (BlockPos)spawnPos, (int)30, (int)30, (int)1, (level, checkPos) -> level.m_8055_(checkPos).m_60795_() && level.m_8055_(checkPos.m_7494_()).m_60795_() && level.m_8055_(checkPos.m_7495_()).m_280296_());
        if (searchedPos == null) {
            searchedPos = spawnPos;
        }
        if ((entity = (LivingEntity)DragonFightManagerCustom.spawnEntity((ServerLevel)world, (ConfigurationCache.EntitySpawnData)spawnOnDragonSitting.get(DragonfightMod.rand.nextInt(spawnOnDragonSitting.size())), DragonFightManagerCustom.createVec3(searchedPos))) instanceof Mob) {
            List closesPlayers = world.m_45955_(TargetingConditions.f_26872_, entity, entity.m_20191_().m_82400_(20.0));
            if (!closesPlayers.isEmpty()) {
                Player closestPlayer = (Player)closesPlayers.get(DragonfightMod.rand.nextInt(closesPlayers.size()));
                ((Mob)entity).m_6710_((LivingEntity)closestPlayer);
            }
        } else {
            List farPlayers = world.m_45955_(TargetingConditions.f_26872_, entity, entity.m_20191_().m_82377_(60.0, 120.0, 60.0));
            if (!farPlayers.isEmpty()) {
                Player closestPlayer = (Player)farPlayers.get(DragonfightMod.rand.nextInt(farPlayers.size()));
                ((Mob)entity).m_6710_((LivingEntity)closestPlayer);
            }
        }
        meleeAdds.add(entity);
    }

    private static void respawnCrystalAt(BlockPos pos, Level world) {
        if (world.m_45976_(EndCrystal.class, new AABB(pos).m_82400_(2.0)).isEmpty()) {
            EndCrystal crystal = (EndCrystal)DragonFightManagerCustom.spawnEntity((ServerLevel)world, new ConfigurationCache.EntitySpawnData(EntityType.f_20564_, null), DragonFightManagerCustom.createVec3(pos));
            Vec3 spawnPos = DragonFightManagerCustom.createVec3(new BlockPos((int)((double)pos.m_123341_() * 0.8), pos.m_123342_(), (int)((double)pos.m_123343_() * 0.8)));
            if (!spawnOnCrystalRespawn.isEmpty()) {
                int i = 0;
                while ((double)i < Math.max(1.0, (double)DragonFightManagerCustom.getDifficulty() / 3.0 * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).mobSpawnAmountModifier)) {
                    Entity entity = DragonFightManagerCustom.spawnEntity((ServerLevel)world, (ConfigurationCache.EntitySpawnData)spawnOnCrystalRespawn.get(DragonfightMod.rand.nextInt(spawnOnCrystalRespawn.size())), spawnPos.m_82520_(0.0, (double)i, 0.0));
                    if (entity instanceof Mob) {
                        ((Mob)entity).m_6710_((LivingEntity)world.m_45930_(entity, 100.0));
                    }
                    ++i;
                }
            }
            float f = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (DragonfightMod.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, crystal.m_20185_() + (double)f, crystal.m_20186_() + 2.0 + (double)f1, crystal.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
        CrystalLevelData.getForLevel((ServerLevel)world).removePosition(crystalRespawnPos);
        crystalRespawnPos = null;
        DragonFightManagerCustom.checkCrystalsToRespawn(world);
    }

    public static void onDragonHeal(EnderDragon dragonEntity) {
        dragonEntity.m_21153_(Math.min(dragonEntity.m_21233_(), dragonEntity.m_21223_() + (float)DragonFightManagerCustom.getDifficulty() / 7.0f));
    }

    public static float onAttackPlayer(float damage) {
        return (float)((double)(damage + (float)DragonFightManagerCustom.getDifficulty() / 2.0f) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonDamageModifier);
    }

    public static void onPhaseChange(EnderDragonPhase<?> newPhase, EnderDragonPhase<? extends DragonPhaseInstance> oldphase, EnderDragon dragon) {
        if (dragonEntity != dragon) {
            dragonEntity = dragon;
            return;
        }
        if (dragon == null || !(dragon.m_9236_() instanceof ServerLevel) || !dragonEntity.m_6084_()) {
            return;
        }
        EndDragonFight manager = ((ServerLevel)dragon.m_9236_()).m_8586_();
        if (manager == null || manager.f_64060_.m_8324_().isEmpty()) {
            return;
        }
        DragonFightManagerCustom.notifyPlayer(dragon.m_9236_(), "Next phase:" + newPhase.toString());
        if (newPhase == EnderDragonPhase.f_31381_) {
            spawnAdds = true;
            DragonFightManagerCustom.checkCrystalsToRespawn(dragon.m_9236_());
            if ((double)(dragon.m_21223_() / dragon.m_21233_()) < 0.25 && dragon.m_31158_() != null) {
                dragon.m_9236_().m_7785_(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), SoundEvents.f_11894_, dragon.m_5720_(), 2.5f, 0.8f + DragonfightMod.rand.nextFloat() * 0.3f, false);
                for (Player playerEntity : dragon.m_31158_().f_64060_.m_8324_()) {
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, DragonFightManagerCustom.getDifficulty() / 3));
                    if (!((double)(dragon.m_21223_() / dragon.m_21233_()) < 0.1)) continue;
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200, 1));
                }
            }
        }
        if (newPhase == EnderDragonPhase.f_31379_ || newPhase == EnderDragonPhase.f_31386_) {
            timeSinceLastLanding = 0;
            spawnAdds = false;
        }
        if (oldphase == EnderDragonPhase.f_31380_ && newPhase == EnderDragonPhase.f_31383_) {
            timeSinceLastLanding = 0;
            double healthpercent = dragon.m_21223_() / dragon.m_21233_();
            if (healthpercent < 0.5) {
                advancingLightningCurrent = 6;
                advancingLightningStop = 50;
            } else {
                DragonFightManagerCustom.spawnLightningAtCircle(spawnPos, DragonfightMod.rand.nextInt(16) + 8, dragon.m_9236_());
            }
        }
    }

    private static void checkCrystalsToRespawn(Level world) {
        if (crystalRespawnPos != null) {
            return;
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(DragonFightManagerCustom.getCrystalRespawnPositions((ServerLevel)world));
        Collections.shuffle(positions);
        for (BlockPos pos : positions) {
            if (!world.m_45976_(EndCrystal.class, new AABB(pos).m_82400_(5.0)).isEmpty()) continue;
            crystalRespawnPos = pos;
            crystalRespawnTimer = (int)Math.max(400.0, (double)(8000.0f / (float)DragonFightManagerCustom.getDifficulty()) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).crystalRespawnTimeModifier);
            DragonFightManagerCustom.notifyPlayer(world, "Adding respawn at :" + crystalRespawnPos + " in:" + crystalRespawnTimer);
            break;
        }
    }

    private static void spawnLightningAtCircle(BlockPos midPoint, int radius, Level world) {
        if (((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning) {
            return;
        }
        Set<BlockPos> lightningPositions = DragonFightManagerCustom.getCircularPositionsAround(midPoint, radius, 15 - radius / 10);
        for (BlockPos lightningPos : lightningPositions) {
            DragonFightManagerCustom.notifyPlayer(world, "spawning plightning at!" + new BlockPos(lightningPos.m_123341_(), world.m_5452_(Heightmap.Types.WORLD_SURFACE, lightningPos).m_123342_(), lightningPos.m_123343_()));
            int yLevel = world.m_5452_(Heightmap.Types.WORLD_SURFACE, lightningPos).m_123342_();
            if (Math.abs(midPoint.m_123342_() - yLevel) > 20) continue;
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            lightningboltentity.m_6027_((double)lightningPos.m_123341_(), (double)yLevel, (double)lightningPos.m_123343_());
            lightningboltentity.m_20874_(false);
            world.m_7967_((Entity)lightningboltentity);
        }
    }

    private static void explodeInCircleAround(BlockPos midPoint, int radius, Level world) {
        Set<BlockPos> explodePos = DragonFightManagerCustom.getCircularPositionsAround(midPoint, radius, 15);
        for (BlockPos lightningPos : explodePos) {
            DragonFightManagerCustom.notifyPlayer(world, "spawning explosion at!" + new BlockPos(lightningPos.m_123341_(), world.m_5452_(Heightmap.Types.WORLD_SURFACE, lightningPos).m_123342_(), lightningPos.m_123343_()));
            int yLevel = world.m_5452_(Heightmap.Types.WORLD_SURFACE, lightningPos).m_123342_();
            if (Math.abs(midPoint.m_123342_() - yLevel) > 20) continue;
            world.m_255391_((Entity)dragonEntity, (double)lightningPos.m_123341_(), (double)lightningPos.m_123342_(), (double)lightningPos.m_123343_(), (float)(1 + DragonFightManagerCustom.getDifficulty() / 4), false, Level.ExplosionInteraction.NONE);
        }
    }

    private static Set<BlockPos> getCircularPositionsAround(BlockPos start, int radius, int precision) {
        int randomOffset;
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        precision = (int)((double)precision / ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).lightningExplosionDensity);
        for (int i = randomOffset = DragonfightMod.rand.nextInt(40); i < 360 + randomOffset; i += precision) {
            int x = (int)Math.round((double)radius * Math.cos(Math.toRadians(i)));
            int z = (int)Math.round((double)radius * Math.sin(Math.toRadians(i)));
            positions.add(start.m_7918_(x, 0, z));
        }
        return positions;
    }

    public static void notifyPlayer(Level world, String message) {
        if (((CommonConfiguration)DragonfightMod.config.getCommonConfig()).printDragonPhases) {
            for (Player player : ((ServerLevel)world).m_6907_()) {
                if (world.m_7654_() == null || ((ServerLevel)world).m_7654_().m_129944_(player.m_36316_()) <= 0) continue;
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
        }
    }

    private static int getDifficulty() {
        int difficulty = ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonDifficulty;
        if (dragonEntity != null) {
            difficulty += dragonEntity.m_9236_().m_46791_().m_19028_();
            if (dragonEntity.m_31158_() != null) {
                difficulty += DragonFightManagerCustom.dragonEntity.m_31158_().f_64060_.m_8324_().size();
            }
        }
        return Math.max(difficulty, 1);
    }

    private static Vec3 createVec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    private static Entity spawnEntity(ServerLevel world, ConfigurationCache.EntitySpawnData spawnData, Vec3 pos) {
        CompoundTag compoundtag = new CompoundTag();
        if (spawnData.nbt != null) {
            compoundtag = spawnData.nbt.m_6426_();
        }
        compoundtag.m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)spawnData.type).toString());
        Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)world, p_138828_ -> {
            double offset = pos.f_82479_ % 1.0 != 0.0 || pos.f_82481_ % 1.0 != 0.0 ? 0.0 : 0.5;
            p_138828_.m_7678_(pos.f_82479_ + offset, pos.f_82480_, pos.f_82481_ + offset, p_138828_.m_146908_(), p_138828_.m_146909_());
            return p_138828_;
        });
        if (entity == null) {
            return null;
        }
        entity.m_20084_(UUID.randomUUID());
        if (entity instanceof Mob) {
            ((Mob)entity).m_6518_((ServerLevelAccessor)world, world.m_6436_(entity.m_20183_()), MobSpawnType.COMMAND, (SpawnGroupData)null, (CompoundTag)null);
        }
        world.m_7967_(entity);
        return entity;
    }
}

