/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.config;

import com.dragonfight.DragonfightMod;
import com.dragonfight.config.CommonConfiguration;
import com.dragonfight.fight.DragonFightManagerCustom;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigurationCache {
    public static void onConfigChanged() {
        DragonFightManagerCustom.spawnOnCrystalDeath = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnoncrystaldestroy);
        DragonFightManagerCustom.spawnOnCrystalRespawn = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnoncrystalrespawn);
        DragonFightManagerCustom.spawnOnDragonSitting = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnwhilelanded);
    }

    private static ImmutableList<EntitySpawnData> parseEntityTypes(List<String> data) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String entityString : data) {
            int nbtStart = entityString.indexOf("{");
            nbtStart = nbtStart == -1 ? entityString.length() : nbtStart;
            String typeString = entityString.substring(0, nbtStart);
            String nbtString = entityString.substring(nbtStart);
            ResourceLocation id = ResourceLocation.m_135820_((String)typeString);
            if (id == null) {
                DragonfightMod.LOGGER.error("Config entry could not be parsed, not a valid resource location " + entityString);
                continue;
            }
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
            if (type.equals(ForgeRegistries.ENTITY_TYPES.getValue(ForgeRegistries.ENTITY_TYPES.getDefaultKey()))) {
                DragonfightMod.LOGGER.error("Config entry could not be parsed, not a valid entity type" + entityString);
                continue;
            }
            CompoundTag nbt = null;
            if (!nbtString.isEmpty()) {
                try {
                    nbt = TagParser.m_129359_((String)nbtString);
                }
                catch (Exception e) {
                    DragonfightMod.LOGGER.error("Config entry NBT data could not be parsed for " + entityString, (Throwable)e);
                }
            }
            builder.add((Object)new EntitySpawnData(type, nbt));
        }
        return builder.build();
    }

    public static class EntitySpawnData {
        public final EntityType type;
        public final CompoundTag nbt;

        public EntitySpawnData(EntityType type, CompoundTag nbt) {
            this.type = type;
            this.nbt = nbt;
        }
    }
}

