/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.item;

import alabaster.crabbersdelight.common.registry.CDModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CrabClawItem
extends ShearsItem {
    public static final int MAX_DAMAGE = 128;
    private static final AttributeModifier BLOCK_REACH_MOD = new AttributeModifier("crabbersdelight:claw_block_reach", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier ENTITY_REACH_MOD = new AttributeModifier("crabbersdelight:claw_entity_reach", 3.0, AttributeModifier.Operation.ADDITION);

    public CrabClawItem(Item.Properties properties) {
        super(properties.m_41503_(128));
    }

    @SubscribeEvent
    public static void extendRange(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        boolean main = player.m_21205_().m_150930_((Item)CDModItems.CRAB_CLAW.get());
        boolean off = player.m_21206_().m_150930_((Item)CDModItems.CRAB_CLAW.get());
        boolean holdingExactlyOne = main ^ off;
        CrabClawItem.applyModifier(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()), BLOCK_REACH_MOD, holdingExactlyOne);
        CrabClawItem.applyModifier(player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()), ENTITY_REACH_MOD, holdingExactlyOne);
    }

    private static void applyModifier(AttributeInstance attr, AttributeModifier mod, boolean active) {
        if (attr == null) {
            return;
        }
        if (active) {
            if (attr.m_22111_(mod.m_22209_()) == null) {
                attr.m_22118_(mod);
            }
        } else if (attr.m_22111_(mod.m_22209_()) != null) {
            attr.m_22120_(mod.m_22209_());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeOnBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        double dist = player.m_146892_().m_82554_(event.getPos().m_252807_());
        if (dist > CrabClawItem.getVanillaBlockReach(player)) {
            CrabClawItem.damageClaws(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeOnPlace(BlockEvent.EntityPlaceEvent event) {
        Player player;
        double dist;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (dist = (player = (Player)entity).m_146892_().m_82554_(event.getPos().m_252807_())) > CrabClawItem.getVanillaBlockReach(player)) {
            CrabClawItem.damageClaws(player);
        }
    }

    private static double getVanillaBlockReach(Player player) {
        AttributeInstance inst = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        if (inst == null) {
            return 4.5;
        }
        double val = inst.m_22135_();
        if (inst.m_22109_(BLOCK_REACH_MOD)) {
            val -= BLOCK_REACH_MOD.m_22218_();
        }
        return val;
    }

    private static double distanceEyeToAABB(Player player, LivingEntity target) {
        Vec3 eye = player.m_146892_();
        AABB box = target.m_20191_();
        double x = Math.max(box.f_82288_, Math.min(eye.f_82479_, box.f_82291_));
        double y = Math.max(box.f_82289_, Math.min(eye.f_82480_, box.f_82292_));
        double z = Math.max(box.f_82290_, Math.min(eye.f_82481_, box.f_82293_));
        return eye.m_82554_(new Vec3(x, y, z));
    }

    private static boolean beyondBaseEntityReach(Player player, LivingEntity target) {
        double dist = CrabClawItem.distanceEyeToAABB(player, target);
        AttributeInstance attr = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        if (attr == null) {
            return false;
        }
        double reach = attr.m_22135_();
        if (attr.m_22109_(ENTITY_REACH_MOD)) {
            reach -= ENTITY_REACH_MOD.m_22218_();
        }
        return dist > reach;
    }

    public boolean m_7579_(ItemStack claw, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (attacker instanceof Player && !(player = (Player)attacker).m_7500_()) {
            if (CrabClawItem.beyondBaseEntityReach(player, target)) {
                claw.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
            }
            return true;
        }
        return super.m_7579_(claw, target, attacker);
    }

    @SubscribeEvent
    public static void handleAttackEntity(AttackEntityEvent event) {
        Player attackerEntity = event.getEntity();
        if (!(attackerEntity instanceof Player)) {
            return;
        }
        Player player = attackerEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        Entity targetEntity = event.getTarget();
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)targetEntity;
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        boolean clawMain = main.m_150930_((Item)CDModItems.CRAB_CLAW.get());
        boolean clawOff = off.m_150930_((Item)CDModItems.CRAB_CLAW.get());
        if (!clawMain && !clawOff) {
            return;
        }
        if (CrabClawItem.beyondBaseEntityReach(player, target)) {
            if (clawMain) {
                main.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
            }
            if (clawOff) {
                off.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.OFFHAND));
            }
        }
    }

    private static void damageClaws(Player player) {
        if (player == null || player.m_9236_().f_46443_) {
            return;
        }
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        if (main.m_150930_((Item)CDModItems.CRAB_CLAW.get())) {
            main.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
        }
        if (off.m_150930_((Item)CDModItems.CRAB_CLAW.get())) {
            off.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.OFFHAND));
        }
    }
}

