/*
 * Decompiled with CFR 0.152.
 */
package tax.taknax.taxwl.item;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import tax.taknax.taxwl.client.model.Modelwarden_boots;
import tax.taknax.taxwl.client.model.Modelwarden_chestplate;
import tax.taknax.taxwl.client.model.Modelwarden_helmet;
import tax.taknax.taxwl.client.model.Modelwarden_leggings;
import tax.taknax.taxwl.init.TaxwlModItems;

public abstract class WardenArmorItem
extends ArmorItem {
    public WardenArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 43;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{7, 14, 15, 7})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 33;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TaxwlModItems.WARDEN_SCALE.get())});
            }

            public String m_6082_() {
                return "warden_armor";
            }

            public float m_6651_() {
                return 4.0f;
            }

            public float m_6649_() {
                return 0.4f;
            }
        }, type, properties);
    }

    public static class Boots
    extends WardenArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelwarden_boots<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwarden_boots.LAYER_LOCATION)).LeftLeg, "right_leg", new Modelwarden_boots<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwarden_boots.LAYER_LOCATION)).RightLeg, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "taxwl:textures/models/armor/warden_armor__layer_1.png";
        }
    }

    public static class Leggings
    extends WardenArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelwarden_leggings<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwarden_leggings.LAYER_LOCATION)).LeftLeg, "right_leg", new Modelwarden_leggings<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwarden_leggings.LAYER_LOCATION)).RightLeg, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "taxwl:textures/models/armor/warden_armor__layer_2.png";
        }
    }

    public static class Chestplate
    extends WardenArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelwarden_chestplate<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwarden_chestplate.LAYER_LOCATION)).Body, "left_arm", new Modelwarden_chestplate<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwarden_chestplate.LAYER_LOCATION)).LeftArm, "right_arm", new Modelwarden_chestplate<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwarden_chestplate.LAYER_LOCATION)).RightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "taxwl:textures/models/armor/warden_armor__layer_1.png";
        }
    }

    public static class Helmet
    extends WardenArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new Modelwarden_helmet<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwarden_helmet.LAYER_LOCATION)).Head, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "taxwl:textures/models/armor/warden_armor__layer_1.png";
        }
    }
}

