/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.wand.modes;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandMode;
import net.nicguzzo.wands.wand.WandProps;

public class DirectionMode
implements WandMode {
    @Override
    public void place_in_buffer(Wand wand) {
        Direction[] dirs = this.getDirMode0(wand.side, wand.hit.f_82479_, wand.hit.f_82480_, wand.hit.f_82481_, wand);
        boolean invert = WandProps.getFlag(wand.wand_stack, WandProps.Flag.INVERTED);
        if (invert) {
            if (dirs[0] != null) {
                dirs[0] = dirs[0].m_122424_();
            }
            if (dirs[1] != null) {
                dirs[1] = dirs[1].m_122424_();
            }
        }
        Direction d1 = dirs[0];
        Direction d2 = dirs[1];
        if (wand.preview) {
            wand.x = wand.pos.m_123341_();
            wand.y = wand.pos.m_123342_();
            wand.z = wand.pos.m_123343_();
        }
        if (d1 != null) {
            BlockPos dest;
            wand.block_buffer.reset();
            boolean diag = false;
            if (d2 != null) {
                dest = this.find_next_diag(wand.block_state, d1, d2, wand.pos, wand);
                diag = true;
            } else {
                dest = this.find_next_pos(wand.block_state, d1, wand.pos, wand);
            }
            int multiplier = WandProps.getVal(wand.wand_stack, WandProps.Value.MULTIPLIER);
            for (int i = 0; i < multiplier && dest != null; ++i) {
                wand.x1 = dest.m_123341_();
                wand.y1 = dest.m_123342_();
                wand.z1 = dest.m_123343_();
                wand.x2 = wand.x1 + 1;
                wand.y2 = wand.y1 + 1;
                wand.z2 = wand.z1 + 1;
                wand.valid = wand.add_to_buffer(dest.m_123341_(), dest.m_123342_(), dest.m_123343_());
                if (diag) {
                    dest = dest.m_5484_(d1, 1);
                    dest = dest.m_5484_(d2, 1);
                } else {
                    dest = dest.m_5484_(d1, 1);
                }
                BlockState bs = wand.level.m_8055_(dest);
                if (!wand.can_place(bs, dest)) break;
            }
        }
    }

    Direction[] getDirMode0(Direction side, double hit_x, double hit_y, double hit_z, Wand wand) {
        Direction[] ret = new Direction[]{null, null};
        double a = 0.333333f;
        double b = 0.666666f;
        double x = WandUtils.unitCoord(hit_x);
        double y = WandUtils.unitCoord(hit_y);
        double z = WandUtils.unitCoord(hit_z);
        double xo = x;
        double yo = y;
        double zo = z;
        VoxelShape shape = wand.block_state.m_60808_((BlockGetter)wand.level, wand.pos);
        List list = shape.m_83299_();
        int index = 0;
        for (AABB aabb : list) {
            switch (side) {
                case UP: 
                case DOWN: {
                    if (!(xo > aabb.f_82288_) || !(xo < aabb.f_82291_) || !(zo > aabb.f_82290_) || !(zo < aabb.f_82293_)) break;
                    if (aabb.m_82362_() != 0.0) {
                        x = (float)((x - aabb.f_82288_) / aabb.m_82362_());
                    }
                    if (aabb.m_82385_() != 0.0) {
                        z = (float)((z - aabb.f_82290_) / aabb.m_82385_());
                    }
                    wand.grid_voxel_index = index;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (!(yo > aabb.f_82289_) || !(yo < aabb.f_82292_) || !(zo > aabb.f_82290_) || !(zo < aabb.f_82293_)) break;
                    if (aabb.m_82376_() != 0.0) {
                        y = (float)((y - aabb.f_82289_) / aabb.m_82376_());
                    }
                    if (aabb.m_82385_() != 0.0) {
                        z = (float)((z - aabb.f_82290_) / aabb.m_82385_());
                    }
                    wand.grid_voxel_index = index;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (!(xo > aabb.f_82288_) || !(xo < aabb.f_82291_) || !(yo > aabb.f_82289_) || !(yo < aabb.f_82292_)) break;
                    if (aabb.m_82362_() != 0.0) {
                        x = (float)((x - aabb.f_82288_) / aabb.m_82362_());
                    }
                    if (aabb.m_82376_() != 0.0) {
                        y = (float)((y - aabb.f_82289_) / aabb.m_82376_());
                    }
                    wand.grid_voxel_index = index;
                }
            }
            ++index;
        }
        switch (side) {
            case UP: 
            case DOWN: {
                if (x >= a && x <= b) {
                    if (z <= a) {
                        ret[0] = Direction.NORTH;
                        break;
                    }
                    if (z >= b) {
                        ret[0] = Direction.SOUTH;
                        break;
                    }
                    ret[0] = side.m_122424_();
                    break;
                }
                if (z >= a && z <= b) {
                    if (x <= a) {
                        ret[0] = Direction.WEST;
                        break;
                    }
                    ret[0] = Direction.EAST;
                    break;
                }
                if (x <= a && z <= a) {
                    ret[0] = Direction.WEST;
                    ret[1] = Direction.NORTH;
                }
                if (x >= b && z <= a) {
                    ret[0] = Direction.EAST;
                    ret[1] = Direction.NORTH;
                }
                if (x >= b && z >= b) {
                    ret[0] = Direction.EAST;
                    ret[1] = Direction.SOUTH;
                }
                if (!(x <= a) || !(z >= b)) break;
                ret[0] = Direction.WEST;
                ret[1] = Direction.SOUTH;
                break;
            }
            case EAST: 
            case WEST: {
                if (z >= a && z <= b) {
                    if (y <= a) {
                        ret[0] = Direction.DOWN;
                        break;
                    }
                    if (y >= b) {
                        ret[0] = Direction.UP;
                        break;
                    }
                    ret[0] = side.m_122424_();
                    break;
                }
                if (y >= a && y <= b) {
                    if (z <= a) {
                        ret[0] = Direction.NORTH;
                        return ret;
                    }
                    ret[0] = Direction.SOUTH;
                    return ret;
                }
                if (y <= a && z <= a) {
                    ret[0] = Direction.DOWN;
                    ret[1] = Direction.NORTH;
                }
                if (y >= b && z <= a) {
                    ret[0] = Direction.UP;
                    ret[1] = Direction.NORTH;
                }
                if (y >= b && z >= b) {
                    ret[0] = Direction.UP;
                    ret[1] = Direction.SOUTH;
                }
                if (!(y <= a) || !(z >= b)) break;
                ret[0] = Direction.DOWN;
                ret[1] = Direction.SOUTH;
                break;
            }
            case NORTH: 
            case SOUTH: {
                if (x >= a && x <= b) {
                    if (y <= a) {
                        ret[0] = Direction.DOWN;
                        break;
                    }
                    if (y >= b) {
                        ret[0] = Direction.UP;
                        break;
                    }
                    ret[0] = side.m_122424_();
                    break;
                }
                if (y >= a && y <= b) {
                    if (x <= a) {
                        ret[0] = Direction.WEST;
                        break;
                    }
                    ret[0] = Direction.EAST;
                    break;
                }
                if (y <= a && x <= a) {
                    ret[0] = Direction.DOWN;
                    ret[1] = Direction.WEST;
                }
                if (y >= b && x <= a) {
                    ret[0] = Direction.UP;
                    ret[1] = Direction.WEST;
                }
                if (y >= b && x >= b) {
                    ret[0] = Direction.UP;
                    ret[1] = Direction.EAST;
                }
                if (!(y <= a) || !(x >= b)) break;
                ret[0] = Direction.DOWN;
                ret[1] = Direction.EAST;
            }
        }
        return ret;
    }

    BlockPos find_next_diag(BlockState state, Direction dir1, Direction dir2, BlockPos bpos, Wand wand) {
        BlockPos p0 = bpos;
        for (int i = 0; i < wand.limit; ++i) {
            BlockPos p1 = bpos.m_121945_(dir1);
            BlockState bs = wand.level.m_8055_(bpos = p1.m_121945_(dir2));
            if (bs != null) {
                if (wand.destroy || wand.use || wand.replace) {
                    if (!bs.m_60713_(state.m_60734_()) && !wand.palette.state_in_slot(bs) && p0 != null) {
                        return p0;
                    }
                } else {
                    if (wand.can_place(bs, bpos)) {
                        return bpos;
                    }
                    if (!(bs.m_60713_(state.m_60734_()) || wand.palette.state_in_slot(bs) || wand.offhand_state != null && bs.m_60713_(wand.offhand_state.m_60734_()))) {
                        return null;
                    }
                }
            }
            p0 = bpos;
        }
        return null;
    }

    BlockPos find_next_pos(BlockState state, Direction dir, BlockPos bpos, Wand wand) {
        for (int i = 0; i < wand.limit; ++i) {
            BlockPos pos2 = bpos.m_5484_(dir, i + 1);
            BlockState bs = wand.level.m_8055_(pos2);
            if (bs == null || bs.m_60713_(state.m_60734_()) || wand.palette.state_in_slot(bs)) continue;
            if (wand.destroy || wand.use || wand.replace) {
                pos2 = bpos.m_5484_(dir, i);
                if (pos2 == wand.pos) continue;
                return pos2;
            }
            if (wand.can_place(bs, pos2)) {
                return pos2;
            }
            return null;
        }
        return null;
    }
}

