/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.utils;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.nicguzzo.wands.items.MagicBagItem;
import net.nicguzzo.wands.items.WandItem;

public class WandUtils {
    public static boolean is_wand(ItemStack stack) {
        return stack != null && !stack.m_41619_() && stack.m_41720_() instanceof WandItem;
    }

    public static boolean is_shulker(ItemStack item_stack) {
        return Block.m_49814_((Item)item_stack.m_41720_()) instanceof ShulkerBoxBlock;
    }

    public static boolean is_magicbag(ItemStack item_stack) {
        return item_stack.m_41720_() instanceof MagicBagItem;
    }

    public static int count_in_shulker(ItemStack shulker, Item item) {
        CompoundTag entity_tag;
        int n = 0;
        if (item != null && (entity_tag = shulker.m_41737_("BlockEntityTag")) != null) {
            ListTag shulker_items = entity_tag.m_128437_("Items", 10);
            int len = shulker_items.size();
            for (int i = 0; i < len; ++i) {
                CompoundTag itemTag = shulker_items.m_128728_(i);
                ItemStack s = ItemStack.m_41712_((CompoundTag)itemTag);
                if (WandUtils.is_magicbag(s)) {
                    int total = MagicBagItem.getTotal(s);
                    ItemStack stack2 = MagicBagItem.getItem(s);
                    if (stack2.m_41619_() || total <= 0 || stack2.m_41720_() != item) continue;
                    n += total;
                    continue;
                }
                if (s.m_41619_() || s.m_41783_() != null || s.m_41720_() != item) continue;
                n += s.m_41613_();
            }
        }
        return n;
    }

    public static boolean is_plant(BlockState state) {
        return state.m_60734_() instanceof BushBlock || state.m_60734_() instanceof VineBlock;
    }

    public static double unitCoord(double a) {
        double b = a - (double)((int)a);
        if (b < 0.0) {
            b = 1.0 + b;
        }
        return b;
    }

    public static float calc_xp(int level, float prog) {
        float xp = WandUtils.calc_xp_level(level);
        if (prog > 0.0f) {
            xp += prog * (WandUtils.calc_xp_level(level + 1) - xp);
        }
        return xp;
    }

    public static float calc_xp_level(int level) {
        int level2 = level * level;
        float xp_points = level >= 32 ? 4.5f * (float)level2 - 162.5f * (float)level + 2220.0f : (level >= 17 ? 2.5f * (float)level2 - 40.5f * (float)level + 360.0f : (float)(level2 + 6 * level));
        return xp_points;
    }

    public static int calc_xp_to_next_level(int level) {
        int xp = level >= 32 ? 9 * level - 158 : (level >= 17 ? 5 * level - 38 : 2 * level + 7);
        return xp;
    }

    public static boolean pickaxe_minable(BlockState state) {
        return state.m_204336_(BlockTags.f_144282_);
    }
}

