/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.items;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.client.render.ClientRender;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WandItem
extends TieredItem
implements Vanishable {
    public int limit;
    public boolean can_blast;
    public boolean unbreakable;
    public boolean removes_water;
    public boolean removes_lava;

    public WandItem(Tier tier, int limit, boolean removes_water, boolean removes_lava, boolean unbreakable, boolean can_blast, Item.Properties properties) {
        super(tier, properties);
        this.limit = limit;
        this.removes_lava = removes_lava;
        this.removes_water = removes_water;
        this.unbreakable = unbreakable;
        this.can_blast = can_blast;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!world.m_5776_()) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !(stack.m_41720_() instanceof WandItem)) {
            return InteractionResult.FAIL;
        }
        WandProps.Mode mode = WandProps.getMode(stack);
        BlockPos pos = context.m_8083_();
        BlockState block_state = world.m_8055_(pos);
        Direction side = context.m_43719_();
        boolean inc_sel = WandProps.getFlag(stack, WandProps.Flag.INCSELBLOCK);
        if (ClientRender.wand.getP1() == null) {
            ClientRender.wand.setP1(pos);
        } else if (ClientRender.wand.getP2() == null && mode.n_clicks() == 2) {
            ClientRender.wand.setP2(pos);
            if (inc_sel && !block_state.m_60795_()) {
                ClientRender.wand.setP2(ClientRender.wand.getP2().m_5484_(side, 1));
            }
        }
        if (ClientRender.wand.getP1() != null && mode.n_clicks() == 1 || ClientRender.wand.getP1() != null && ClientRender.wand.getP2() != null && mode.n_clicks() == 2) {
            this.send_placement(side, ClientRender.wand.getP1(), ClientRender.wand.getP2(), context.m_43720_(), ClientRender.wand.palette.seed);
            ClientRender.wand.palette.seed = System.currentTimeMillis();
            ClientRender.wand.copy();
            ClientRender.wand.clear();
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!world.m_5776_()) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(interactionHand));
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !(stack.m_41720_() instanceof WandItem)) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(interactionHand));
        }
        Wand wand = ClientRender.wand;
        WandProps.Mode mode = WandProps.getMode(stack);
        if (wand.target_air && mode.can_target_air()) {
            if (wand.getP1() == null) {
                wand.setP1(ClientRender.last_pos);
                wand.setP2(null);
                ClientRender.has_target = true;
            } else {
                if (mode.n_clicks() == 2) {
                    wand.setP2(wand.get_pos_from_air(wand.hit));
                } else {
                    wand.setP2(null);
                }
                this.send_placement(ClientRender.wand.player.m_6350_().m_122424_(), wand.getP1(), wand.getP2(), wand.hit, wand.palette.seed);
                wand.palette.seed = System.currentTimeMillis();
                ClientRender.wand.copy();
                ClientRender.wand.clear();
            }
        } else {
            ClientRender.wand.clear();
            if (player != null) {
                player.m_5661_((Component)Compat.literal("wand cleared"), false);
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(interactionHand));
    }

    public void send_placement(Direction side, BlockPos p1, BlockPos p2, Vec3 hit, long seed) {
        Minecraft client = Minecraft.m_91087_();
        if (client.m_91403_() == null) {
            return;
        }
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeInt(side.ordinal());
        if (p1 != null) {
            packet.writeBoolean(true);
            packet.m_130064_(p1);
        } else {
            packet.writeBoolean(false);
        }
        if (p2 != null) {
            packet.writeBoolean(true);
            packet.m_130064_(p2);
        } else {
            packet.writeBoolean(false);
        }
        packet.writeDouble(hit.f_82479_);
        packet.writeDouble(hit.f_82480_);
        packet.writeDouble(hit.f_82481_);
        packet.writeLong(seed);
        NetworkManager.sendToServer((ResourceLocation)WandsMod.POS_PACKET, (FriendlyByteBuf)packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        CompoundTag tag = stack.m_41784_();
        list.add((Component)Compat.literal("mode: ").m_7220_((Component)Compat.translatable(WandProps.getMode(stack).toString())));
        list.add((Component)Compat.literal("limit: " + this.limit));
        list.add((Component)Compat.literal("orientation: ").m_7220_((Component)Compat.translatable(WandProps.orientations[tag.m_128451_("orientation")].toString())));
        int a = tag.m_128451_("axis");
        if (a < WandProps.axes.length) {
            list.add((Component)Compat.literal("axis: " + WandProps.axes[a].toString()));
        } else {
            list.add((Component)Compat.literal("axis: none"));
        }
        list.add((Component)Compat.literal("plane: " + WandProps.Plane.values()[tag.m_128451_("plane")].toString()));
        list.add((Component)Compat.literal("fill circle: " + tag.m_128471_("cfill")));
        list.add((Component)Compat.literal("rotation: " + tag.m_128451_("rotation")));
        ListTag tools = tag.m_128437_("Tools", 10);
        if (ClientRender.wand != null) {
            tools.forEach(element -> {
                CompoundTag stackTag = (CompoundTag)element;
                ItemStack item = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Tool"));
                list.add((Component)Compat.literal("tool: ").m_7220_(item.m_41611_()));
            });
        }
    }

    public int m_6473_() {
        return this.m_43314_().m_6601_();
    }
}

