/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Color;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.nicguzzo.wands.WandsExpectPlatform;

public class WandsConfig {
    private static WandsConfig INSTANCE = null;
    public static final String[] default_pickaxe_allowed = new String[]{"minecraft:sea_lantern"};
    public static final String[] default_axe_allowed = new String[0];
    public static final String[] default_shovel_allowed = new String[0];
    public static final String[] default_hoe_allowed = new String[]{"minecraft:moss_block"};
    public static final String[] default_shears_allowed = new String[0];
    public static final String[] default_denied = new String[0];
    public static float def_blocks_per_xp = 0.0f;
    public static int def_stone_wand_limit = 16;
    public static int def_iron_wand_limit = 32;
    public static int def_diamond_wand_limit = 64;
    public static int def_netherite_wand_limit = 256;
    public static int def_creative_wand_limit = 512;
    public static int def_stone_wand_durability = 256;
    public static int def_iron_wand_durability = 512;
    public static int def_diamond_wand_durability = 2048;
    public static int def_netherite_wand_durability = 4096;
    public static int max_limit = 8192;
    public int max_limit___increment_this_if_your_machine_can_handle_it = max_limit;
    public float blocks_per_xp = def_blocks_per_xp;
    public int stone_wand_limit = def_stone_wand_limit;
    public int iron_wand_limit = def_iron_wand_limit;
    public int diamond_wand_limit = def_diamond_wand_limit;
    public int netherite_wand_limit = def_netherite_wand_limit;
    public int creative_wand_limit = def_creative_wand_limit;
    public int stone_wand_durability = def_stone_wand_durability;
    public int iron_wand_durability = def_iron_wand_durability;
    public int diamond_wand_durability = def_diamond_wand_durability;
    public int netherite_wand_durability = def_netherite_wand_durability;
    public boolean destroy_in_survival_drop = true;
    public boolean survival_unenchanted_drops = true;
    public boolean allow_wand_to_break = false;
    public boolean allow_offhand_to_break = false;
    public boolean mend_tools = true;
    public boolean enable_vein_mode = true;
    public boolean enable_blast_mode = true;
    public boolean disable_destroy_replace = false;
    public static int def_magic_bag_1_limit = 17280;
    public static int def_magic_bag_2_limit = 172800;
    public int magic_bag_1_limit = def_magic_bag_1_limit;
    public int magic_bag_2_limit = def_magic_bag_2_limit;
    public float wand_mode_display_x_pos = 75.0f;
    public float wand_mode_display_y_pos = 100.0f;
    public float wand_tools_display_x_pos = 0.0f;
    public float wand_tools_display_y_pos = 100.0f;
    public float preview_opacity = 0.8f;
    public int wand_screen_x_offset = 0;
    public int wand_screen_y_offset = 0;
    public boolean fancy_preview = true;
    public boolean block_outlines = true;
    public boolean fill_outlines = true;
    public boolean copy_outlines = true;
    public boolean paste_outlines = true;
    public boolean no_lines = false;
    public boolean fat_lines = true;
    public boolean render_last = false;
    public boolean show_tools_info = true;
    public boolean check_advancements = false;
    public String advancement_allow_stone_wand = "";
    public String advancement_allow_iron_wand = "";
    public String advancement_allow_diamond_wand = "";
    public String advancement_allow_netherite_wand = "";
    public float fat_lines_width = 0.025f;
    public String block_outline_color = "220,220,220,255";
    public String bounding_box_color = "0,0,200,255";
    public String destroy_color = "220,0,0,255";
    public String tool_use_color = "240,240,0,255";
    public String start_color = "0,200,200,255";
    public String end_color = "0,200,0,255";
    public String line_color = "200,0,200,200";
    public String paste_bb_color = "80,40,0,255";
    public String block_color = "255,255,255,255";
    public String[] str_pickaxe_allowed = default_pickaxe_allowed;
    public String[] str_axe_allowed = default_axe_allowed;
    public String[] str_shovel_allowed = default_shovel_allowed;
    public String[] str_hoe_allowed = default_hoe_allowed;
    public String[] str_shears_allowed = default_hoe_allowed;
    public String[] str_denied = default_denied;
    public static List<Block> pickaxe_allowed = new ArrayList<Block>();
    public static List<Block> axe_allowed = new ArrayList<Block>();
    public static List<Block> shovel_allowed = new ArrayList<Block>();
    public static List<Block> hoe_allowed = new ArrayList<Block>();
    public static List<Block> shears_allowed = new ArrayList<Block>();
    public static List<Block> denied = new ArrayList<Block>();
    public static Color c_block_outline;
    public static Color c_bounding_box;
    public static Color c_destroy;
    public static Color c_tool_use;
    public static Color c_start;
    public static Color c_end;
    public static Color c_line;
    public static Color c_paste_bb;
    public static Color c_block;
    public static Color def_c_block_outline;
    public static Color def_c_bounding_box;
    public static Color def_c_destroy;
    public static Color def_c_tool_use;
    public static Color def_c_start;
    public static Color def_c_end;
    public static Color def_c_line;
    public static Color def_c_paste_bb;
    public static Color def_c_block;

    Color parse_color(String col) {
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        String[] temp = col.split(",");
        if (temp.length == 4) {
            try {
                r = Integer.parseInt(temp[0]);
                g = Integer.parseInt(temp[1]);
                b = Integer.parseInt(temp[2]);
                a = Integer.parseInt(temp[3]);
            }
            catch (NumberFormatException e) {
                System.out.printf("error parsing color, " + e.getMessage(), new Object[0]);
            }
        }
        return Color.ofRGBA((int)r, (int)g, (int)b, (int)a);
    }

    public void generate_allow_list(List<Block> out, String[] str) {
        for (String id : str) {
            Block blk;
            Item item;
            ResourceLocation res = ResourceLocation.m_135820_((String)id);
            if (res == null || (item = (Item)BuiltInRegistries.f_257033_.m_7745_(res)) == null || item == Items.f_41852_ || (blk = Block.m_49814_((Item)item)) == null) continue;
            out.add(blk);
        }
    }

    public void parse_colors() {
        c_block_outline = this.parse_color(this.block_outline_color);
        c_bounding_box = this.parse_color(this.bounding_box_color);
        c_destroy = this.parse_color(this.destroy_color);
        c_tool_use = this.parse_color(this.tool_use_color);
        c_start = this.parse_color(this.start_color);
        c_end = this.parse_color(this.end_color);
        c_line = this.parse_color(this.line_color);
        c_paste_bb = this.parse_color(this.paste_bb_color);
        c_block = this.parse_color(this.block_color);
    }

    public void generate_lists() {
        System.out.println("generating allow/deny lists");
        this.generate_allow_list(pickaxe_allowed, this.str_pickaxe_allowed);
        this.generate_allow_list(axe_allowed, this.str_axe_allowed);
        this.generate_allow_list(shovel_allowed, this.str_shovel_allowed);
        this.generate_allow_list(hoe_allowed, this.str_hoe_allowed);
        this.generate_allow_list(shears_allowed, this.str_shears_allowed);
        this.generate_allow_list(denied, this.str_denied);
        System.out.println("denied " + denied.size());
        for (Block b : denied) {
            System.out.println("denied " + b);
        }
        this.parse_colors();
    }

    public static void load_config() {
        INSTANCE = new WandsConfig();
        Gson gson = new Gson();
        File configFile = new File(WandsExpectPlatform.getConfigDirectory().toString(), "wands.json");
        try (FileReader reader = new FileReader(configFile);){
            try {
                WandsConfig ins = (WandsConfig)gson.fromJson((Reader)reader, WandsConfig.class);
                if (ins != null) {
                    INSTANCE = ins;
                    max_limit = WandsConfig.INSTANCE.max_limit___increment_this_if_your_machine_can_handle_it;
                    INSTANCE.parse_colors();
                }
            }
            catch (JsonSyntaxException e3) {
                System.out.println("Failed to parse config file!");
            }
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)INSTANCE));
                System.out.println("Config updated!");
            }
            catch (IOException e2) {
                System.out.println("Failed to update config file!");
            }
            System.out.println("Config loaded!");
        }
        catch (IOException e) {
            System.out.println("No config found, generating!");
            INSTANCE = new WandsConfig();
            INSTANCE.parse_colors();
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)INSTANCE));
            }
            catch (IOException e2) {
                System.out.println("Failed to generate config file!");
            }
        }
    }

    public static String save_color(Color c) {
        return c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha();
    }

    public static void save_config() {
        File configFile = new File(WandsExpectPlatform.getConfigDirectory().toString(), "wands.json");
        if (INSTANCE == null) {
            INSTANCE = new WandsConfig();
        }
        WandsConfig.INSTANCE.block_outline_color = WandsConfig.save_color(c_block_outline);
        WandsConfig.INSTANCE.bounding_box_color = WandsConfig.save_color(c_bounding_box);
        WandsConfig.INSTANCE.destroy_color = WandsConfig.save_color(c_destroy);
        WandsConfig.INSTANCE.tool_use_color = WandsConfig.save_color(c_tool_use);
        WandsConfig.INSTANCE.start_color = WandsConfig.save_color(c_start);
        WandsConfig.INSTANCE.end_color = WandsConfig.save_color(c_end);
        WandsConfig.INSTANCE.line_color = WandsConfig.save_color(c_line);
        WandsConfig.INSTANCE.paste_bb_color = WandsConfig.save_color(c_paste_bb);
        WandsConfig.INSTANCE.block_color = WandsConfig.save_color(c_block);
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)INSTANCE));
        }
        catch (IOException e2) {
            System.out.println("Failed to generate config file!");
        }
    }

    public static WandsConfig get_instance() {
        if (INSTANCE == null) {
            WandsConfig.load_config();
        }
        return INSTANCE;
    }

    static {
        def_c_block_outline = Color.ofRGBA((int)220, (int)220, (int)220, (int)255);
        def_c_bounding_box = Color.ofRGBA((int)0, (int)0, (int)200, (int)255);
        def_c_destroy = Color.ofRGBA((int)220, (int)0, (int)0, (int)255);
        def_c_tool_use = Color.ofRGBA((int)240, (int)240, (int)0, (int)255);
        def_c_start = Color.ofRGBA((int)0, (int)200, (int)200, (int)255);
        def_c_end = Color.ofRGBA((int)0, (int)200, (int)0, (int)255);
        def_c_line = Color.ofRGBA((int)200, (int)0, (int)200, (int)200);
        def_c_paste_bb = Color.ofRGBA((int)80, (int)40, (int)0, (int)255);
        def_c_block = Color.ofRGBA((int)255, (int)255, (int)255, (int)255);
    }
}

