/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.nicguzzo.wands.WandsMod;
import net.nicguzzo.wands.client.WandToast;
import net.nicguzzo.wands.client.render.ClientRender;
import net.nicguzzo.wands.client.screens.MagicBagScreen;
import net.nicguzzo.wands.client.screens.PaletteScreen;
import net.nicguzzo.wands.client.screens.WandScreen;
import net.nicguzzo.wands.items.WandItem;
import net.nicguzzo.wands.utils.Compat;
import net.nicguzzo.wands.utils.WandUtils;
import net.nicguzzo.wands.wand.Wand;
import net.nicguzzo.wands.wand.WandProps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WandsModClient {
    static boolean shift = false;
    static boolean alt = false;
    public static boolean has_optifine = false;
    public static KeyMapping wand_menu_km;
    public static final Logger LOGGER;
    public static final Map keys;
    public static final int wand_menu_key = 89;
    public static final int wand_mode_key = 86;
    public static final int wand_action_key = 72;
    public static final int wand_orientation_key = 88;
    public static final int wand_undo_key = 85;
    public static final int wand_invert_key = 73;
    public static final int wand_fill_circle_key = 75;
    public static final int wand_rotate = 82;
    public static final int palette_mode_key = 80;
    public static final int palette_menu_key = 74;
    public static final int wand_conf_key = -1;
    public static final int wand_m_inc_key = 262;
    public static final int wand_m_dec_key = 263;
    public static final int wand_n_inc_key = 265;
    public static final int wand_n_dec_key = 264;
    public static final int toggle_stair_slab_key = 46;
    public static final int area_diagonal_spread = 44;
    public static final int inc_sel_block = 90;
    static final String tab = "key.categories.wands";
    static final String k = "key.wands.";

    public static void initialize() {
        wand_menu_km = new KeyMapping("key.wands.wand_menu", 89, tab);
        keys.put(wand_menu_km, WandsMod.WandKeys.MENU);
        keys.put(new KeyMapping("key.wands.wand_mode", 86, tab), WandsMod.WandKeys.MODE);
        keys.put(new KeyMapping("key.wands.palette_menu", 74, tab), WandsMod.WandKeys.PALETTE_MENU);
        keys.put(new KeyMapping("key.wands.wand_action", 72, tab), WandsMod.WandKeys.ACTION);
        keys.put(new KeyMapping("key.wands.wand_orientation", 88, tab), WandsMod.WandKeys.ORIENTATION);
        keys.put(new KeyMapping("key.wands.wand_invert", 73, tab), WandsMod.WandKeys.INVERT);
        keys.put(new KeyMapping("key.wands.wand_fill_circle", 75, tab), WandsMod.WandKeys.FILL);
        keys.put(new KeyMapping("key.wands.wand_undo", 85, tab), WandsMod.WandKeys.UNDO);
        keys.put(new KeyMapping("key.wands.wand_palette_mode", 80, tab), WandsMod.WandKeys.PALETTE_MODE);
        keys.put(new KeyMapping("key.wands.wand_rotate", 82, tab), WandsMod.WandKeys.ROTATE);
        keys.put(new KeyMapping("key.wands.m_inc", 262, tab), WandsMod.WandKeys.M_INC);
        keys.put(new KeyMapping("key.wands.m_dec", 263, tab), WandsMod.WandKeys.M_DEC);
        keys.put(new KeyMapping("key.wands.n_inc", 265, tab), WandsMod.WandKeys.N_INC);
        keys.put(new KeyMapping("key.wands.n_dec", 264, tab), WandsMod.WandKeys.N_DEC);
        keys.put(new KeyMapping("key.wands.toggle_stair_slab", 46, tab), WandsMod.WandKeys.TOGGLE_STAIRSLAB);
        keys.put(new KeyMapping("key.wands.area_diagonal_spread", 44, tab), WandsMod.WandKeys.DIAGONAL_SPREAD);
        keys.put(new KeyMapping("key.wands.inc_sel_block", 90, tab), WandsMod.WandKeys.INC_SEL_BLK);
        keys.put(new KeyMapping("key.wands.clear_wand", 67, tab), WandsMod.WandKeys.CLEAR);
        keys.forEach((km, v) -> Compat.register_key((KeyMapping)km));
        ClientTickEvent.CLIENT_PRE.register(e -> {
            boolean any = false;
            for (Map.Entry me : keys.entrySet()) {
                KeyMapping km = (KeyMapping)me.getKey();
                WandsMod.WandKeys key = (WandsMod.WandKeys)((Object)((Object)me.getValue()));
                if (!km.m_90859_()) continue;
                if (!any) {
                    any = true;
                }
                if (key == WandsMod.WandKeys.CLEAR) {
                    WandsModClient.cancel_wand();
                    continue;
                }
                WandsModClient.send_key(key.ordinal(), Screen.m_96638_(), Screen.m_96639_());
            }
            if (!(any || alt == Screen.m_96639_() && shift == Screen.m_96638_())) {
                alt = Screen.m_96639_();
                shift = Screen.m_96638_();
                ClientRender.wand.is_alt_pressed = alt;
                ClientRender.wand.is_shift_pressed = shift;
                WandsModClient.send_key(-1, shift, alt);
            }
        });
        Compat.render_info();
        if (WandsMod.is_forge) {
            ClientLifecycleEvent.CLIENT_SETUP.register(e -> {
                WandsMod.LOGGER.info("registering menues...");
                try {
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.PALETTE_CONTAINER.get()), PaletteScreen::new);
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.WAND_CONTAINER.get()), WandScreen::new);
                    MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.MAGIC_WAND_CONTANIER.get()), MagicBagScreen::new);
                }
                catch (Exception ex) {
                    WandsMod.LOGGER.error(ex.getMessage());
                }
                WandsMod.LOGGER.info("registering menues.");
            });
        } else {
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.PALETTE_CONTAINER.get()), PaletteScreen::new);
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.WAND_CONTAINER.get()), WandScreen::new);
            MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.MAGIC_WAND_CONTANIER.get()), MagicBagScreen::new);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WandsMod.SND_PACKET, (packet, context) -> {
            BlockPos pos = packet.m_130135_();
            boolean destroy = packet.readBoolean();
            ItemStack item_stack = packet.m_130267_();
            boolean no_tool = packet.readBoolean();
            boolean damaged_tool = packet.readBoolean();
            int i_sound = packet.readInt();
            context.queue(() -> {
                if (i_sound > -1 && i_sound < Wand.Sounds.values().length) {
                    Wand.Sounds snd = Wand.Sounds.values()[i_sound];
                    SoundEvent sound = snd.get_sound();
                    Compat.player_level(context.getPlayer()).m_5594_(context.getPlayer(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (!item_stack.m_41619_()) {
                    Block block = Block.m_49814_((Item)item_stack.m_41720_());
                    SoundType sound_type = block.m_49962_(block.m_49966_());
                    SoundEvent sound = destroy ? sound_type.m_56775_() : sound_type.m_56777_();
                    Compat.player_level(context.getPlayer()).m_5594_(context.getPlayer(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (no_tool) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new WandToast("no tool"));
                }
                if (damaged_tool) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new WandToast("invalid or damaged"));
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WandsMod.STATE_PACKET, (packet, context) -> {
            long seed = packet.readLong();
            int mode = packet.readInt();
            int slot = packet.readInt();
            boolean xp = packet.readBoolean();
            int levels = packet.readInt();
            float prog = packet.readFloat();
            context.queue(() -> {
                if (ClientRender.wand != null) {
                    ClientRender.wand.mode = WandProps.Mode.values()[mode];
                    if (ClientRender.wand.mode == WandProps.Mode.DIRECTION) {
                        ClientRender.wand.palette.slot = slot;
                    }
                    if (xp) {
                        context.getPlayer().f_36078_ = levels;
                        context.getPlayer().f_36080_ = prog;
                    }
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WandsMod.CONF_PACKET, (packet, context) -> {
            ServerData srv = Minecraft.m_91087_().m_91089_();
            if (srv != null && WandsMod.config != null) {
                WandsMod.config.blocks_per_xp = packet.readFloat();
                WandsMod.config.destroy_in_survival_drop = packet.readBoolean();
                WandsMod.config.survival_unenchanted_drops = packet.readBoolean();
                WandsMod.config.allow_wand_to_break = packet.readBoolean();
                WandsMod.config.allow_offhand_to_break = packet.readBoolean();
                WandsMod.config.mend_tools = packet.readBoolean();
                LOGGER.info("got config");
                context.queue(() -> {});
            }
        });
    }

    public static void send_key(int key, boolean shift, boolean alt) {
        Minecraft client = Minecraft.m_91087_();
        if (client.m_91403_() != null) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.writeInt(key);
            packet.writeBoolean(shift);
            packet.writeBoolean(alt);
            NetworkManager.sendToServer((ResourceLocation)WandsMod.KB_PACKET, (FriendlyByteBuf)packet);
        }
    }

    public static void send_palette(boolean next_mode, boolean toggle_rotate) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeBoolean(next_mode);
        packet.writeBoolean(toggle_rotate);
        NetworkManager.sendToServer((ResourceLocation)WandsMod.PALETTE_PACKET, (FriendlyByteBuf)packet);
    }

    public static void send_wand(ItemStack item) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130055_(item);
        NetworkManager.sendToServer((ResourceLocation)WandsMod.WAND_PACKET, (FriendlyByteBuf)packet);
    }

    public static void render_wand_info(GuiGraphics gui) {
        Minecraft client = Minecraft.m_91087_();
        if (client != null && client.f_91074_ != null) {
            boolean off;
            ItemStack stack = client.f_91074_.m_21205_();
            ItemStack offhand_stack = client.f_91074_.m_21206_();
            boolean main = stack != null && !stack.m_41619_() && stack.m_41720_() instanceof WandItem;
            boolean bl = off = offhand_stack != null && !offhand_stack.m_41619_() && offhand_stack.m_41720_() instanceof WandItem;
            if (main || off) {
                Font font;
                int screenWidth = client.m_91268_().m_85445_();
                int screenHeight = client.m_91268_().m_85446_();
                if (main) {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    font = client.f_91062_;
                    Compat.set_color(1.0f, 1.0f, 1.0f, 1.0f);
                    Compat.set_pos_tex_shader();
                    Wand wand = ClientRender.wand;
                    WandProps.Mode mode = WandProps.getMode(stack);
                    WandProps.Action action = WandProps.getAction(stack);
                    Rotation r = WandProps.getRotation(stack);
                    String rot = "";
                    switch (r) {
                        case NONE: {
                            rot = "0\u00b0";
                            break;
                        }
                        case CLOCKWISE_90: {
                            rot = "90\u00b0";
                            break;
                        }
                        case CLOCKWISE_180: {
                            rot = "180\u00b0";
                            break;
                        }
                        case COUNTERCLOCKWISE_90: {
                            rot = "270\u00b0";
                        }
                    }
                    Object p1 = "";
                    Object p2 = "";
                    BlockPos bp1 = wand.getP1();
                    BlockPos bp2 = wand.getP2();
                    if (wand.getP1() != null) {
                        p1 = "p1:[" + bp1.m_123341_() + "," + bp1.m_123342_() + "," + bp1.m_123343_() + "]";
                    }
                    if (wand.getP2() != null) {
                        p2 = "p2:[" + bp2.m_123341_() + "," + bp2.m_123342_() + "," + bp2.m_123343_() + "]";
                    } else if (wand.getP1() != null) {
                        p2 = "p2:[" + ClientRender.last_pos.m_123341_() + "," + ClientRender.last_pos.m_123342_() + "," + ClientRender.last_pos.m_123343_() + "]";
                    }
                    Object ln1 = "";
                    String ln2 = "Action: " + Compat.translatable(action.toString()).getString();
                    String ln3 = "Mode: " + Compat.translatable(mode.toString()).getString() + " Rot:" + rot;
                    if (wand.valid) {
                        switch (mode) {
                            case DIRECTION: {
                                int mult = WandProps.getVal(stack, WandProps.Value.MULTIPLIER);
                                ln1 = "pos: [" + wand.pos.m_123341_() + "," + wand.pos.m_123342_() + "," + wand.pos.m_123343_() + "] x" + mult;
                                break;
                            }
                            case GRID: {
                                int gm = WandProps.getVal(stack, WandProps.Value.GRIDM);
                                int gn = WandProps.getVal(stack, WandProps.Value.GRIDN);
                                int gms = WandProps.getVal(stack, WandProps.Value.GRIDMS);
                                int gns = WandProps.getVal(stack, WandProps.Value.GRIDNS);
                                Object skp = "";
                                if (gms > 0 || gns > 0) {
                                    skp = " - (" + gms + "x" + gns + ")";
                                }
                                ln1 = "Grid " + gm + "x" + gn + (String)skp;
                                break;
                            }
                            case ROW_COL: 
                            case LINE: 
                            case AREA: 
                            case VEIN: 
                            case FILL: {
                                if (mode == WandProps.Mode.FILL) {
                                    int nx = wand.fill_nx + 1;
                                    int ny = wand.fill_ny + 1;
                                    int nz = wand.fill_nz + 1;
                                    ln1 = (String)ln1 + "volume [" + nx + "," + ny + "," + nz + "] ";
                                }
                                int arealim = WandProps.getVal(stack, WandProps.Value.AREALIM);
                                ln1 = (String)ln1 + "Blocks: " + wand.block_buffer.get_length();
                                if (arealim <= 0) break;
                                ln1 = (String)ln1 + " Limit: " + arealim;
                                break;
                            }
                            case CIRCLE: {
                                ln1 = "Radius: " + wand.radius + " N: " + wand.block_buffer.get_length();
                                break;
                            }
                            case COPY: 
                            case PASTE: {
                                ln1 = "Copied Blocks: " + wand.copy_paste_buffer.size();
                            }
                        }
                    }
                    Objects.requireNonNull(font);
                    int h = 3 * 9;
                    float x = (int)((float)screenWidth * (WandsMod.config.wand_mode_display_x_pos / 100.0f));
                    float y = (int)((float)(screenHeight - h) * (WandsMod.config.wand_mode_display_y_pos / 100.0f));
                    gui.m_280488_(font, (String)ln1, (int)x, (int)y, 0xFFFFFF);
                    int n = (int)x;
                    int n2 = (int)y;
                    Objects.requireNonNull(font);
                    gui.m_280488_(font, ln2, n, n2 + 9, 0xFFFFFF);
                    int n3 = (int)x;
                    int n4 = (int)y;
                    Objects.requireNonNull(font);
                    gui.m_280488_(font, ln3, n3, n4 + 9 * 2, 0xFFFFFF);
                    int n5 = (int)x;
                    int n6 = (int)y;
                    Objects.requireNonNull(font);
                    gui.m_280488_(font, (String)p1, n5, n6 - 9 * 2, 0xFFFFFF);
                    int n7 = (int)x;
                    int n8 = (int)y;
                    Objects.requireNonNull(font);
                    gui.m_280488_(font, (String)p2, n7, n8 - 9, 0xFFFFFF);
                }
                if (WandsMod.config.show_tools_info) {
                    font = client.f_91062_;
                    ItemRenderer itemRenderer = client.m_91291_();
                    if (!main) {
                        stack = offhand_stack;
                    }
                    CompoundTag ctag = stack.m_41784_();
                    ListTag tag = ctag.m_128437_("Tools", 10);
                    int ix = (int)((float)screenWidth * (WandsMod.config.wand_tools_display_x_pos / 100.0f));
                    int iy = (int)((float)(screenHeight - 20) * (WandsMod.config.wand_tools_display_y_pos / 100.0f));
                    tag.forEach(element -> {
                        CompoundTag stackTag = (CompoundTag)element;
                        int slot = stackTag.m_128451_("Slot");
                        ItemStack item = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Tool"));
                        int yoff = 0;
                        if (ClientRender.has_target && slot == ClientRender.wand.digger_item_slot) {
                            yoff = -5;
                        }
                        gui.m_280203_(item, ix + slot * 16, iy + yoff);
                        gui.m_280370_(font, item, ix + slot * 16, iy);
                        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)item);
                        int silk = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)item);
                        if (fortune != 0) {
                            gui.m_280430_(font, (Component)Compat.literal("F" + fortune), ix + slot * 16, iy + yoff - 5, 0xFFFFFF);
                        } else if (silk != 0) {
                            gui.m_280430_(font, (Component)Compat.literal("S"), ix + slot * 16, iy + yoff - 5, 0xFFFFFF);
                        }
                    });
                }
            }
        }
    }

    public static void cancel_wand() {
        if (ClientRender.wand != null && ClientRender.wand.wand_stack != null && WandUtils.is_wand(ClientRender.wand.wand_stack)) {
            ClientRender.wand.clear();
            if (ClientRender.wand.player != null) {
                ClientRender.wand.player.m_5661_((Component)Compat.literal("wand cleared"), false);
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        keys = new HashMap();
    }
}

