/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.deathknell;

import net.darkhax.deathknell.Constants;
import net.darkhax.deathknell.Services;
import net.darkhax.deathknell.message.DeathMessage;
import net.darkhax.deathknell.message.DeathMessageRandom;
import net.darkhax.deathknell.message.IDeathMessage;
import net.darkhax.deathknell.mixin.AccessorCombatTracker;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DeathKnellCommon {
    private static final TagKey<Item> COOKIES = DeathKnellCommon.bind("cookies");
    private static final TagKey<Item> BOOKS = DeathKnellCommon.bind("books");
    private static final TagKey<Item> AXES = DeathKnellCommon.bind("axes");
    private static final IDeathMessage GENERIC_SLAIN = new DeathMessageRandom("thwarted", "bonked", "defeated", "butchered", "assassinate", "eliminated", "extinguished", "terminated", "done_in", "executed", "stopped", "stifle", "slaughter", "exterminated", "vanquished", "bested", "trounced", "ended", "perished", "demise");
    private static final IDeathMessage DEATH_BY_COOKIE = new DeathMessage("death_by_cookie");
    private static final IDeathMessage DEATH_BY_BOOK = new DeathMessage("death_by_book");
    private static final IDeathMessage DEATH_BY_AXE = new DeathMessage("death_by_axe");
    private static final IDeathMessage BURNED_ALIVE = new DeathMessageRandom("incinerated", "reduce_to_ash", "cooked_alive", "fire_out");
    private static final IDeathMessage SPIDER_VENOM = new DeathMessage("spider_venom");
    private static final IDeathMessage SLIME_DEATH = new DeathMessageRandom("dissolve", "slime_food");
    private static final IDeathMessage POLAR_BEAR_DEATH = new DeathMessageRandom("respect_habitat", "disturb_den");
    private static final IDeathMessage IRON_GOLEM_DEATH = new DeathMessage("saved_from_village");
    private static final IDeathMessage DROWNED_DEATH = new DeathMessage("watery_grave");
    private static final IDeathMessage GUARDIAN_DEATH = new DeathMessage("stared_down");
    private static final IDeathMessage PLAYER_DEATH = new DeathMessage("pwned");
    private static final IDeathMessage FALL_DEATH = new DeathMessageRandom("fall_bounce", "fall_gravity", "fall_parachute", "fall_stub", "free_fall");
    private static final IDeathMessage DROWN_DEATH = new DeathMessageRandom("drown_breath", "drown_fishes", "drown_fish_food", "drown_shark_bait", "drown_floundered");
    private static final IDeathMessage ELYTRA_WALL_DEATH = new DeathMessageRandom("elytra_wall_bang", "elytra_wall_crash");
    private static final IDeathMessage VOID_DEATH = new DeathMessageRandom("void_abyss", "void_infinity", "void_divide");

    private static CombatEntry getLastCombatEntry(AccessorCombatTracker tracker) {
        return tracker.deathknell$getEntries().isEmpty() ? null : tracker.deathknell$getEntries().get(tracker.deathknell$getEntries().size() - 1);
    }

    public static Component getCustomDeathMessage(Component original, CombatTracker tracker) {
        if (tracker instanceof AccessorCombatTracker) {
            AccessorCombatTracker combat = (AccessorCombatTracker)tracker;
            CombatEntry lastEntry = DeathKnellCommon.getLastCombatEntry(combat);
            DamageSource source = lastEntry != null ? lastEntry.f_19250_() : null;
            LivingEntity deadMob = combat.deathknell$getMob();
            LivingEntity killer = deadMob.m_21232_();
            if (killer == null && source != null) {
                if (source.m_269533_(DamageTypeTags.f_268549_) && DeathKnellCommon.tryPercent(0.6f)) {
                    return FALL_DEATH.getMessage(deadMob);
                }
                if (source.m_269533_(DamageTypeTags.f_268581_) && DeathKnellCommon.tryPercent(0.6f)) {
                    return DROWN_DEATH.getMessage(deadMob);
                }
                if (source.m_276093_(DamageTypes.f_268576_) && DeathKnellCommon.tryPercent(0.6f)) {
                    return ELYTRA_WALL_DEATH.getMessage(deadMob);
                }
                if (source.m_269533_(DamageTypeTags.f_268518_) && DeathKnellCommon.tryPercent(0.6f)) {
                    return VOID_DEATH.getMessage(deadMob);
                }
            }
            if (killer != null) {
                boolean wasGenericKill;
                TranslatableContents msg;
                ComponentContents componentContents = original.m_214077_();
                TranslatableContents translatable = componentContents instanceof TranslatableContents ? (msg = (TranslatableContents)componentContents) : null;
                ItemStack murderWeapon = killer.m_21205_();
                boolean bl = wasGenericKill = DeathKnellCommon.wasGenericMobKill(translatable) || DeathKnellCommon.wasGenericPlayerKill(translatable);
                if (killer instanceof Blaze && DeathKnellCommon.tryPercent(0.65f)) {
                    return BURNED_ALIVE.getMessage(deadMob, killer);
                }
                if (killer instanceof CaveSpider && DeathKnellCommon.tryPercent(0.9f)) {
                    return SPIDER_VENOM.getMessage(deadMob, killer);
                }
                if (killer instanceof Slime && DeathKnellCommon.tryPercent(0.9f)) {
                    return SLIME_DEATH.getMessage(deadMob, killer);
                }
                if (killer instanceof PolarBear && DeathKnellCommon.tryPercent(0.9f)) {
                    return POLAR_BEAR_DEATH.getMessage(deadMob, killer);
                }
                if (killer instanceof IronGolem && DeathKnellCommon.tryPercent(0.9f)) {
                    return IRON_GOLEM_DEATH.getMessage(deadMob, killer);
                }
                if (killer instanceof Drowned && DeathKnellCommon.tryPercent(0.4f)) {
                    return DROWNED_DEATH.getMessage(deadMob, killer);
                }
                if (killer instanceof Guardian && DeathKnellCommon.tryPercent(0.4f)) {
                    return GUARDIAN_DEATH.getMessage(deadMob, killer);
                }
                if (killer instanceof Player && DeathKnellCommon.tryPercent(0.2f)) {
                    return murderWeapon.m_41788_() ? PLAYER_DEATH.getSubMessage("item", deadMob, killer, murderWeapon) : PLAYER_DEATH.getMessage(deadMob, killer);
                }
                if (wasGenericKill) {
                    if (murderWeapon.m_204117_(COOKIES)) {
                        return DEATH_BY_COOKIE.getMessage(deadMob, killer);
                    }
                    if (murderWeapon.m_204117_(BOOKS)) {
                        return DEATH_BY_BOOK.getMessage(deadMob, killer);
                    }
                    if (murderWeapon.m_41720_() instanceof AxeItem || murderWeapon.m_204117_(AXES)) {
                        return DEATH_BY_AXE.getMessage(deadMob, killer);
                    }
                    if (DeathKnellCommon.tryPercent(0.85f)) {
                        return murderWeapon.m_41788_() ? GENERIC_SLAIN.getSubMessage("item", deadMob, killer, murderWeapon) : GENERIC_SLAIN.getMessage(deadMob, killer);
                    }
                }
            }
        }
        return original;
    }

    private static boolean wasGenericMobKill(TranslatableContents message) {
        return message != null && message.m_237508_().startsWith("death.attack.mob");
    }

    private static boolean wasGenericPlayerKill(TranslatableContents message) {
        return message != null && message.m_237508_().startsWith("death.attack.player");
    }

    private static TagKey<Item> bind(String tagId) {
        return Services.HELPER.createItemTag("deathknell", tagId);
    }

    private static boolean tryPercent(float percent) {
        return Constants.RAND.nextFloat() < percent;
    }
}

