/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.ConditionContext;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.mixin.RecipeManagerAccess;
import snownee.kiwi.util.Util;

public class AlternativesIngredient
extends AbstractIngredient {
    public static final ResourceLocation ID = Kiwi.id("alternatives");
    public static final Serializer SERIALIZER = new Serializer();
    @Nullable
    private JsonArray options;
    private Ingredient cached;

    public AlternativesIngredient(@Nullable JsonArray options) {
        this.options = options;
    }

    public boolean test(ItemStack stack) {
        return this.internal().test(stack);
    }

    public ItemStack @NotNull [] m_43908_() {
        return this.internal().m_43908_();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean m_43947_() {
        return false;
    }

    public Ingredient internal() {
        if (this.cached == null) {
            Objects.requireNonNull(this.options, "Options in AlternativesIngredient is null");
            this.cached = Ingredient.f_43901_;
            for (JsonElement option : this.options) {
                try {
                    this.cached = this.getIngredient(option);
                    if (this.cached.m_43947_()) continue;
                    this.options = null;
                    break;
                }
                catch (IllegalStateException e) {
                    Kiwi.LOGGER.info("Failed to parse ingredient: %s".formatted(this.options), (Throwable)e);
                    this.cached = null;
                    return Ingredient.f_43901_;
                }
                catch (Exception exception) {
                }
            }
        }
        return this.cached;
    }

    private Ingredient getIngredient(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            if (jsonObject.size() == 1 && jsonObject.has("tag")) {
                RecipeManager recipeManager = Util.getRecipeManager();
                if (recipeManager == null) {
                    throw new IllegalStateException("Unable to get recipe manager");
                }
                ICondition.IContext ctx = ((RecipeManagerAccess)recipeManager).getContext();
                if (!(ctx instanceof ConditionContext)) {
                    throw new IllegalStateException("Unable to get real condition context");
                }
                String s = jsonObject.get("tag").getAsString();
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(s));
                if (ctx.getTag(tagKey).isEmpty()) {
                    throw new JsonSyntaxException("Tag not found: " + s);
                }
            }
            return CraftingHelper.getIngredient((JsonElement)element, (boolean)false);
        }
        if (element.isJsonArray()) {
            JsonArray jsonArray = element.getAsJsonArray();
            if (jsonArray.isEmpty()) {
                throw new JsonSyntaxException("Empty array");
            }
            Ingredient[] ingredients = new Ingredient[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                ingredients[i] = this.getIngredient(jsonArray.get(i));
            }
            return CompoundIngredient.of((Ingredient[])ingredients);
        }
        throw new JsonSyntaxException("Expected item to be object or array of objects");
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", Objects.requireNonNull(CraftingHelper.getID((IIngredientSerializer)SERIALIZER)).toString());
        jsonObject.add("options", (JsonElement)Objects.requireNonNull(this.options));
        return jsonObject;
    }

    public static class Serializer
    implements IIngredientSerializer<AlternativesIngredient> {
        @NotNull
        public AlternativesIngredient parse(FriendlyByteBuf buf) {
            Ingredient internal = Ingredient.m_43940_((FriendlyByteBuf)buf);
            AlternativesIngredient ingredient = new AlternativesIngredient(null);
            ingredient.cached = internal;
            return ingredient;
        }

        public AlternativesIngredient parse(JsonObject json) {
            AlternativesIngredient ingredient = new AlternativesIngredient(GsonHelper.m_13933_((JsonObject)json, (String)"options"));
            ingredient.internal();
            return ingredient;
        }

        public void write(FriendlyByteBuf buf, AlternativesIngredient ingredient) {
            ingredient.internal().m_43923_(buf);
        }
    }
}

