/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.item;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.item.ItemCategoryFiller;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.loader.Platform;

public class ModBlockItem
extends BlockItem
implements ItemCategoryFiller {
    public static final Set<BlockEntityType<?>> INSTANT_UPDATE_TILES = Platform.isPhysicalClient() ? Sets.newHashSet() : null;

    public ModBlockItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    protected boolean m_7274_(BlockPos pos, Level worldIn, Player player, ItemStack stack, BlockState state) {
        CompoundTag data;
        BlockEntity tile;
        if (worldIn.f_46443_ && (tile = worldIn.m_7702_(pos)) != null && INSTANT_UPDATE_TILES.contains(tile.m_58903_()) && (data = ModBlockItem.m_186336_((ItemStack)stack)) != null) {
            data = data.m_6426_();
            tile.m_142466_(data);
            tile.m_6596_();
        }
        return super.m_7274_(pos, worldIn, player, stack, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!KiwiClientConfig.globalTooltip) {
            ModItem.addTip(stack, tooltip, flagIn);
        }
    }

    public Component m_7626_(ItemStack pStack) {
        Block block = this.m_40614_();
        if (block instanceof IKiwiBlock) {
            return ((IKiwiBlock)block).getName(pStack);
        }
        return super.m_7626_(pStack);
    }

    @Override
    public void fillItemCategory(CreativeModeTab tab, FeatureFlagSet flags, boolean hasPermissions, List<ItemStack> items) {
        Block block = this.m_40614_();
        if (block instanceof ItemCategoryFiller) {
            ItemCategoryFiller filler = (ItemCategoryFiller)block;
            filler.fillItemCategory(tab, flags, hasPermissions, items);
        } else {
            items.add(new ItemStack((ItemLike)this));
        }
    }
}

