/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block.def;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;

public interface BlockDefinition {
    public static final Map<String, Factory<?>> MAP = Maps.newConcurrentMap();
    public static final List<Factory<?>> FACTORIES = Lists.newLinkedList();

    public static void registerFactory(Factory<?> factory) {
        MAP.put(factory.getId(), factory);
        if ("Block".equals(factory.getId())) {
            FACTORIES.add(factory);
        } else {
            FACTORIES.add(0, factory);
        }
    }

    public static BlockDefinition fromNBT(CompoundTag tag) {
        Factory<?> factory = MAP.get(tag.m_128461_("Type"));
        if (factory == null) {
            return null;
        }
        return factory.fromNBT(tag);
    }

    public static BlockDefinition fromBlock(BlockState state, BlockEntity blockEntity, LevelReader level, BlockPos pos) {
        for (Factory<?> factory : FACTORIES) {
            Object supplier = factory.fromBlock(state, blockEntity, level, pos);
            if (supplier == null) continue;
            return supplier;
        }
        return null;
    }

    public static BlockDefinition fromItem(ItemStack stack, @Nullable BlockPlaceContext context) {
        if (!stack.m_41619_()) {
            for (Factory<?> factory : FACTORIES) {
                Object supplier = factory.fromItem(stack, context);
                if (supplier == null) continue;
                return supplier;
            }
        }
        return null;
    }

    public Factory<?> getFactory();

    @OnlyIn(value=Dist.CLIENT)
    public BakedModel model();

    @OnlyIn(value=Dist.CLIENT)
    default public ModelData modelData() {
        return ModelData.EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Material renderMaterial(@Nullable Direction var1);

    public void save(CompoundTag var1);

    @OnlyIn(value=Dist.CLIENT)
    default public boolean canRenderInLayer(RenderType layer) {
        return this.getRenderTypes().contains(layer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkRenderTypeSet getRenderTypes();

    public boolean canOcclude();

    @OnlyIn(value=Dist.CLIENT)
    public int getColor(BlockState var1, BlockAndTintGetter var2, BlockPos var3, int var4);

    public Component getDescription();

    public void place(Level var1, BlockPos var2);

    public ItemStack createItem(HitResult var1, BlockGetter var2, @Nullable BlockPos var3, @Nullable Player var4);

    public BlockState getBlockState();

    default public BlockDefinition getCamoDefinition() {
        return null;
    }

    public static BlockDefinition getCamo(BlockDefinition definition) {
        BlockDefinition camo = definition.getCamoDefinition();
        while (camo != null && camo != definition) {
            definition = camo;
            camo = definition.getCamoDefinition();
        }
        return definition;
    }

    default public int getLightEmission(BlockGetter level, BlockPos pos) {
        return this.getBlockState().getLightEmission(level, pos);
    }

    public SoundType getSoundType();

    public static interface Factory<T extends BlockDefinition> {
        public T fromNBT(CompoundTag var1);

        public String getId();

        @Nullable
        public T fromBlock(BlockState var1, BlockEntity var2, LevelReader var3, BlockPos var4);

        @Nullable
        public T fromItem(ItemStack var1, @Nullable BlockPlaceContext var2);
    }
}

