/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.AtlasSourceAggregator;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.core.util.Pair;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public abstract class AtlasSourceGenerator
extends ResourceGenerator {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private final Map<ResourceLocation, AtlasBuilder> builders = new HashMap<ResourceLocation, AtlasBuilder>();

    public AtlasSourceGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (Map.Entry<ResourceLocation, AtlasBuilder> atlas : this.builders.entrySet()) {
            Set<ResourceLocation> textures = this.gatherTextures(atlas.getValue());
            ResourceLocation identifier = atlas.getKey();
            this.cache.saveResource(ResourceType.ASSET, AtlasSourceAggregator.INSTANCE, textures, identifier.m_135827_(), "atlases", identifier.m_135815_(), ".json");
        }
    }

    private Set<ResourceLocation> gatherTextures(AtlasBuilder builder) {
        ResourceLocation parent;
        HashSet<ResourceLocation> textures = new HashSet<ResourceLocation>(builder.textures);
        HashSet<ResourceLocation> parents = new HashSet<ResourceLocation>();
        for (Pair<ResourceLocation, Boolean> pair2 : builder.models) {
            parent = this.readModelData(pair2.left(), true, textures);
            if (parent == null || !pair2.right().booleanValue()) continue;
            parents.add(parent);
        }
        HashSet<ResourceLocation> done = new HashSet<ResourceLocation>();
        builder.models.forEach(pair -> done.add((ResourceLocation)pair.left()));
        while (!parents.isEmpty()) {
            ResourceLocation resourceLocation = (ResourceLocation)parents.iterator().next();
            parents.remove(resourceLocation);
            done.add(resourceLocation);
            parent = this.readModelData(resourceLocation, false, textures);
            if (parent == null || done.contains(parent)) continue;
            parents.add(parent);
        }
        return textures;
    }

    private ResourceLocation readModelData(ResourceLocation model, boolean forced, Set<ResourceLocation> textures) {
        Optional<InputStream> optional = this.cache.getExistingResource(ResourceType.ASSET, model.m_135827_(), "models", model.m_135815_(), ".json");
        if (optional.isEmpty()) {
            if (forced) {
                throw new RuntimeException("Could not find model '" + model + "' to read textures from!");
            }
            return null;
        }
        ResourceLocation parent = null;
        try {
            String identifier;
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(optional.get()), JsonObject.class);
            if (json.has("parent") && json.get("parent").isJsonPrimitive() && json.getAsJsonPrimitive("parent").isString() && RegistryUtil.isValidIdentifier(identifier = json.get("parent").getAsString())) {
                parent = new ResourceLocation(identifier);
            }
            if (json.has("textures") && json.get("textures").isJsonObject()) {
                for (Map.Entry texture : json.getAsJsonObject("textures").entrySet()) {
                    String identifier2;
                    if (!((JsonElement)texture.getValue()).isJsonPrimitive() || !((JsonElement)texture.getValue()).getAsJsonPrimitive().isString() || !RegistryUtil.isValidIdentifier(identifier2 = ((JsonElement)texture.getValue()).getAsString())) continue;
                    textures.add(new ResourceLocation(identifier2));
                }
            }
        }
        catch (Exception ignore) {
            return null;
        }
        return parent;
    }

    protected AtlasBuilder atlas(ResourceLocation identifier) {
        if (identifier.m_135815_().startsWith("textures/atlas/") && identifier.m_135815_().endsWith(".png")) {
            identifier = new ResourceLocation(identifier.m_135827_(), identifier.m_135815_().substring("textures/atlas/".length(), identifier.m_135815_().length() - ".png".length()));
        }
        return this.builders.computeIfAbsent(identifier, i -> new AtlasBuilder(this.modid, (ResourceLocation)i));
    }

    protected AtlasBuilder atlas(String namespace, String identifier) {
        return this.atlas(new ResourceLocation(namespace, identifier));
    }

    protected AtlasBuilder atlas(String identifier) {
        return this.atlas(this.modid, identifier);
    }

    protected AtlasBuilder blockAtlas() {
        return this.atlas(TextureAtlases.getBlocks());
    }

    @Override
    public String getName() {
        return this.modName + " Atlas Source Generator";
    }

    public static class AtlasBuilder {
        private final String modid;
        private final ResourceLocation identifier;
        private final Set<ResourceLocation> textures = new HashSet<ResourceLocation>();
        private final List<Pair<ResourceLocation, Boolean>> models = new ArrayList<Pair<ResourceLocation, Boolean>>();

        private AtlasBuilder(String modid, ResourceLocation identifier) {
            this.modid = modid;
            this.identifier = identifier;
        }

        public AtlasBuilder texture(ResourceLocation location) {
            this.textures.add(location);
            return this;
        }

        public AtlasBuilder texture(String namespace, String path) {
            return this.texture(new ResourceLocation(namespace, path));
        }

        public AtlasBuilder texture(String path) {
            return this.texture(this.modid, path);
        }

        public AtlasBuilder texturesFromModel(ResourceLocation model, boolean includeParents) {
            this.models.add(Pair.of(model, includeParents));
            return this;
        }

        public AtlasBuilder texturesFromModel(String namespace, String path, boolean includeParents) {
            return this.texturesFromModel(new ResourceLocation(namespace, path), includeParents);
        }

        public AtlasBuilder texturesFromModel(String path, boolean includeParents) {
            return this.texturesFromModel(this.modid, path, includeParents);
        }

        public AtlasBuilder texturesFromModel(ResourceLocation model) {
            return this.texturesFromModel(model, true);
        }

        public AtlasBuilder texturesFromModel(String namespace, String path) {
            return this.texturesFromModel(namespace, path, true);
        }

        public AtlasBuilder texturesFromModel(String path) {
            return this.texturesFromModel(path, true);
        }
    }
}

