/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.wind;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilEntOrParticle;
import com.corosus.coroutil.util.CoroUtilMisc;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import weather2.PerlinNoiseHelper;
import weather2.ServerWeatherProxy;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.config.ConfigWind;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.WeatherManager;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.wind.WindInfoCache;

public class WindManager {
    public WeatherManager manager;
    public float windAngleGlobal = 0.0f;
    public float windSpeedGlobal = 0.0f;
    public float windSpeedGlobalChangeRate = 0.05f;
    public int windSpeedGlobalRandChangeTimer = 0;
    public int windSpeedGlobalRandChangeDelay = 10;
    public float windAngleEvent = 0.0f;
    public BlockPos windOriginEvent = BlockPos.f_121853_;
    public float windSpeedEvent = 0.0f;
    public int windTimeEvent = 0;
    public float windAngleGust = 0.0f;
    public float windSpeedGust = 0.0f;
    public int windTimeGust = 0;
    public int windGustEventTimeRand = 60;
    public float chanceOfWindGustEvent = 0.5f;
    public int lowWindTimer = 0;
    public int highWindTimer = 0;
    public static boolean FORCE_ON_DEBUG_TESTING = false;
    public HashMap<Long, WindInfoCache> lookupChunkToWindInfo = new HashMap();
    public HashMap<Long, WindInfoCache> lookupChunkWithHeightToWindInfo = new HashMap();
    public int cachedWindInfoUpdateFrequency = 100;
    public int cachedChunkHeightUpdateFrequency = 6000;
    public float cachedWindSpeedClient = 0.0f;

    public WindManager(WeatherManager parManager) {
        this.manager = parManager;
        Random rand = new Random();
        this.windAngleGlobal = rand.nextInt(360);
    }

    public float getWindSpeed() {
        return this.getWindSpeed(null, 1.0f);
    }

    public float getWindSpeed(@Nullable BlockPos pos) {
        return this.getWindSpeed(pos, 1.0f);
    }

    public float getWindSpeed(@Nullable BlockPos pos, float extraHeightAmpMax) {
        if (pos != null) {
            return this.getWindSpeedPositional(pos, extraHeightAmpMax);
        }
        if (this.windTimeEvent > 0 && this.windSpeedEvent > this.windSpeedGust && this.windSpeedEvent > this.windSpeedGlobal) {
            return this.windSpeedEvent;
        }
        if (this.windTimeGust > 0) {
            return this.windSpeedGust;
        }
        return this.windSpeedGlobal;
    }

    public float getWindSpeedPositional(BlockPos pos) {
        return this.getWindSpeedPositional(pos, 1.0f);
    }

    public float getWindSpeedPositional(BlockPos pos, float extraHeightAmpMax) {
        return this.getWindSpeedPositional(pos, extraHeightAmpMax, true);
    }

    public float getWindSpeedPositional(BlockPos pos, float extraHeightAmpMax, boolean useClientCache) {
        if (this.manager.getWorld().m_5776_() && useClientCache) {
            return this.cachedWindSpeedClient;
        }
        this.manager.getWorld().m_46473_().m_6180_("weather2_wind_calculation");
        boolean eventFastest = false;
        float lastWindSpeed = this.manager.getWorld().m_5776_() ? (this.windTimeEvent > 0 ? this.windSpeedEvent : 0.0f) : this.getCachedWindSpeedEventForChunkPos(pos);
        if (lastWindSpeed > this.windSpeedGlobal && lastWindSpeed > this.windSpeedGlobal) {
            eventFastest = true;
        }
        lastWindSpeed = Math.max(lastWindSpeed, this.windSpeedGlobal);
        if (this.windTimeGust > 0) {
            lastWindSpeed = Math.max(lastWindSpeed, this.windSpeedGust);
        }
        int averageHeight = this.getCachedAverageChunkHeightAround(pos);
        float windSpeedHeightAmp = this.getWindSpeedAmplifierForHeight(pos.m_123342_(), averageHeight, extraHeightAmpMax);
        lastWindSpeed *= windSpeedHeightAmp;
        if (windSpeedHeightAmp > 1.3f) {
            lastWindSpeed += (windSpeedHeightAmp - 1.0f) * 1.0f;
        }
        float cap = 1.0f;
        if (eventFastest) {
            cap = 2.0f;
        }
        if (extraHeightAmpMax >= 2.0f) {
            cap = extraHeightAmpMax + 1.0f;
        }
        this.manager.getWorld().m_46473_().m_7238_();
        return Math.min(cap, lastWindSpeed);
    }

    public void startHighWindEvent() {
        this.highWindTimer = ConfigWind.highWindTimerEnableAmountBase + new Random().nextInt(ConfigWind.highWindTimerEnableAmountRnd);
    }

    public boolean isHighWindEventActive() {
        return this.highWindTimer > 0;
    }

    public void stopHighWindEvent() {
        this.highWindTimer = 0;
    }

    public void startLowWindEvent() {
        this.lowWindTimer = ConfigWind.lowWindTimerEnableAmountBase + new Random().nextInt(ConfigWind.lowWindTimerEnableAmountRnd);
    }

    public void stopLowWindEvent() {
        this.lowWindTimer = 0;
    }

    public float getWindSpeedForGusts() {
        return this.windSpeedGust;
    }

    public float getWindSpeedForClouds() {
        return this.windSpeedGlobal;
    }

    public float getWindAngle(Vec3 pos) {
        if (this.windTimeEvent > 0) {
            return this.getWindAngleForEvents(pos);
        }
        if (this.windTimeGust > 0) {
            return this.windAngleGust;
        }
        return this.windAngleGlobal;
    }

    public float getWindAngleForEvents() {
        return this.windAngleEvent;
    }

    public float getWindAngleForEvents(Vec3 pos) {
        if (pos != null && !this.windOriginEvent.equals((Object)BlockPos.f_121853_)) {
            double var11 = (double)this.windOriginEvent.m_123341_() + 0.5 - pos.f_82479_;
            double var15 = (double)this.windOriginEvent.m_123343_() + 0.5 - pos.f_82481_;
            return -((float)Math.atan2(var11, var15)) * 180.0f / (float)Math.PI - 45.0f;
        }
        return this.windAngleEvent;
    }

    public float getWindAngleForGusts() {
        return this.windAngleGust;
    }

    public float getWindAngleForClouds() {
        return this.windAngleGlobal;
    }

    public void setWindTimeGust(int time) {
        this.windTimeGust = time;
    }

    public void setWindTimeEvent(int parVal) {
        this.windTimeEvent = parVal;
    }

    public void tick() {
        Random rand = CoroUtilMisc.random();
        if (!ConfigWind.Misc_windOn) {
            this.windSpeedGlobal = 0.0f;
            this.windSpeedGust = 0.0f;
            this.windTimeGust = 0;
        } else if (!this.manager.getWorld().m_5776_()) {
            float speedOverride;
            if (!ConfigWind.Wind_LowWindEvents) {
                this.lowWindTimer = 0;
            }
            if (this.lowWindTimer <= 0) {
                if (this.windSpeedGlobalRandChangeTimer-- <= 0) {
                    this.windSpeedGlobal = this.highWindTimer <= 0 ? (float)((double)this.windSpeedGlobal + (rand.nextDouble() * (double)this.windSpeedGlobalChangeRate - (double)(this.windSpeedGlobalChangeRate / 2.0f))) : (float)((double)this.windSpeedGlobal + rand.nextDouble() * (double)this.windSpeedGlobalChangeRate);
                    this.windSpeedGlobalRandChangeTimer = this.windSpeedGlobalRandChangeDelay;
                }
                if (this.highWindTimer <= 0) {
                    if (ConfigWind.Wind_LowWindEvents && rand.nextInt(ConfigWind.lowWindOddsTo1) == 0) {
                        this.startLowWindEvent();
                        Weather.dbg("low wind event started, for ticks: " + this.lowWindTimer);
                    }
                } else {
                    this.stopLowWindEvent();
                }
                if (ConfigWind.Wind_HighWindEvents && this.highWindTimer <= 0 && rand.nextInt(ConfigWind.highWindOddsTo1) == 0) {
                    this.startHighWindEvent();
                    Weather.dbg("high wind event started, for ticks: " + this.highWindTimer);
                }
            } else {
                --this.lowWindTimer;
                if (this.lowWindTimer <= 0) {
                    Weather.dbg("low wind event ended");
                }
                this.windSpeedGlobal -= 0.01f;
            }
            if (this.highWindTimer > 0) {
                --this.highWindTimer;
                if (this.highWindTimer <= 0) {
                    Weather.dbg("high wind event ended");
                }
            }
            if ((double)this.windSpeedGlobal < ConfigWind.windSpeedMin) {
                this.windSpeedGlobal = (float)ConfigWind.windSpeedMin;
            }
            if ((double)this.windSpeedGlobal > ConfigWind.windSpeedMax) {
                this.windSpeedGlobal = (float)ConfigWind.windSpeedMax;
            }
            if (this.windTimeGust > 0) {
                --this.windTimeGust;
                if (this.windTimeGust == 0) {
                    this.windSpeedGust = 0.0f;
                    this.syncData();
                }
            }
            if (ConfigMisc.overcastMode && this.manager.getWorld().m_46471_() && (double)this.windSpeedGlobal < ConfigWind.windSpeedMinGlobalOvercastRaining) {
                this.windSpeedGlobal = (float)ConfigWind.windSpeedMinGlobalOvercastRaining;
            }
            if ((speedOverride = ServerWeatherProxy.getWindSpeed((ServerLevel)this.manager.getWorld())) != -1.0f) {
                this.windSpeedGlobal = speedOverride;
            }
            float randGustWindFactor = 1.0f;
            if (this.windTimeGust == 0 && this.lowWindTimer <= 0 && this.chanceOfWindGustEvent > 0.0f && rand.nextInt((int)((100.0f - this.chanceOfWindGustEvent) * randGustWindFactor)) == 0) {
                this.windSpeedGust = this.windSpeedGlobal + rand.nextFloat() * 0.6f;
                boolean randomDirectionGust = false;
                this.windAngleGust = randomDirectionGust ? (float)(rand.nextInt(360) - 180) : this.windAngleGlobal + (float)rand.nextInt(120) - 60.0f;
                this.setWindTimeGust(rand.nextInt(this.windGustEventTimeRand * 3));
            }
            this.windAngleGlobal = (float)((double)this.windAngleGlobal + ((double)rand.nextFloat() * ConfigWind.globalWindAngleChangeAmountRate - (double)rand.nextFloat() * ConfigWind.globalWindAngleChangeAmountRate));
            if (this.windAngleGlobal < -180.0f) {
                this.windAngleGlobal += 360.0f;
            }
            if (this.windAngleGlobal > 180.0f) {
                this.windAngleGlobal -= 360.0f;
            }
        } else {
            this.tickClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
        LocalPlayer entP = Minecraft.m_91087_().f_91074_;
        if (this.windTimeEvent > 0) {
            --this.windTimeEvent;
            if (this.windTimeEvent == 0) {
                this.windTimeGust = 0;
            }
        }
        if (entP != null) {
            if (entP != null && entP.m_9236_().m_46467_() % 5L == 0L) {
                this.cachedWindSpeedClient = this.getWindSpeedPositional(entP.m_20183_(), 1.0f, false);
            }
            if (this.manager.getWorld().m_46467_() % 20L == 0L) {
                float maxDist = 512.0f;
                StormObject so = this.manager.getClosestStorm(new Vec3(entP.m_20185_(), (double)StormObject.layers.get(0).intValue(), entP.m_20189_()), maxDist, StormObject.STATE_HIGHWIND);
                if (so != null) {
                    float yaw;
                    this.windOriginEvent = CoroUtilBlock.blockPos((double)so.posGround.f_82479_, (double)so.posGround.f_82480_, (double)so.posGround.f_82481_);
                    this.setWindTimeEvent(80);
                    double var11 = so.posGround.f_82479_ - entP.m_20185_();
                    double var15 = so.posGround.f_82481_ - entP.m_20189_();
                    this.windAngleEvent = yaw = -((float)Math.atan2(var11, var15)) * 180.0f / (float)Math.PI;
                    double dist = entP.m_20182_().m_82554_(so.posGround);
                    this.windSpeedEvent = this.getEventSpeedFactor(dist, maxDist);
                }
            }
        }
    }

    public float getEventSpeedFactor(double dist, double maxDist) {
        return (float)(1.0 - dist / maxDist) * 2.0f;
    }

    public WindInfoCache getWindInfoCacheForChunk(BlockPos blockPos, boolean forHeightChunks) {
        BlockPos chunkPos;
        long hash;
        HashMap<Long, WindInfoCache> lookup = forHeightChunks ? this.lookupChunkWithHeightToWindInfo : this.lookupChunkToWindInfo;
        if (lookup.containsKey(hash = (chunkPos = new BlockPos(blockPos.m_123341_() >> 4, forHeightChunks ? blockPos.m_123342_() >> 4 : 0, blockPos.m_123343_() >> 4)).m_121878_())) {
            return lookup.get(hash);
        }
        WindInfoCache cache = new WindInfoCache();
        lookup.put(hash, cache);
        return cache;
    }

    public float getCachedWindSpeedForHeight(BlockPos blockPos, float extraHeightAmpMax) {
        WindInfoCache cache = this.getWindInfoCacheForChunk(blockPos, true);
        if (cache.cacheTimeWindSpeedAtChunkHeight == 0L || cache.cacheTimeWindSpeedAtChunkHeight + (long)this.cachedWindInfoUpdateFrequency <= this.manager.getWorld().m_46467_()) {
            cache.cacheTimeWindSpeedAtChunkHeight = this.manager.getWorld().m_46467_();
            cache.windSpeedAtChunkHeight = this.getWindSpeed(blockPos, extraHeightAmpMax);
        }
        return cache.windSpeedAtChunkHeight;
    }

    public float getCachedWindSpeedEventForChunkPos(BlockPos blockPos) {
        WindInfoCache cache = this.getWindInfoCacheForChunk(blockPos, false);
        if (cache.cacheTimeWindSpeedEvent == 0L || cache.cacheTimeWindSpeedEvent + (long)this.cachedWindInfoUpdateFrequency <= this.manager.getWorld().m_46467_()) {
            cache.cacheTimeWindSpeedEvent = this.manager.getWorld().m_46467_();
            cache.windSpeedEvent = this.calculateWindSpeedEventForPos(blockPos);
        }
        return cache.windSpeedEvent;
    }

    public float calculateWindSpeedEventForPos(BlockPos pos) {
        float maxDist = 512.0f;
        Vec3 posVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        StormObject so = this.manager.getClosestStorm(posVec, maxDist, StormObject.STATE_HIGHWIND);
        if (so != null) {
            double dist = posVec.m_82554_(so.posGround);
            return this.getEventSpeedFactor(dist, maxDist);
        }
        return 0.0f;
    }

    public int getCachedAverageChunkHeightAround(BlockPos blockPos) {
        WindInfoCache cache = this.getWindInfoCacheForChunk(blockPos, false);
        if (cache.cacheTimeChunkHeight == 0L || cache.cacheTimeChunkHeight + (long)this.cachedChunkHeightUpdateFrequency <= this.manager.getWorld().m_46467_()) {
            cache.cacheTimeChunkHeight = this.manager.getWorld().m_46467_();
            BlockPos chunkPos = new BlockPos(blockPos.m_123341_() >> 4, 0, blockPos.m_123343_() >> 4);
            cache.averageChunkHeightAround = this.calculateAverageChunkHeightAround(chunkPos);
        }
        return cache.averageChunkHeightAround;
    }

    public int calculateAverageChunkHeightAround(BlockPos chunkPos) {
        int squareRadius = 2;
        int scanSpacing = 3;
        int count = 0;
        int totalHeight = 0;
        for (int x = -squareRadius; x <= squareRadius; ++x) {
            for (int z = -squareRadius; z <= squareRadius; ++z) {
                BlockPos pos = new BlockPos((chunkPos.m_123341_() + x * scanSpacing) * 16 + 8, 0, (chunkPos.m_123343_() + z * scanSpacing) * 16 + 8);
                int height = this.manager.getWorld().m_5452_(Heightmap.Types.WORLD_SURFACE, pos).m_123342_();
                if (height <= -64) continue;
                totalHeight += height;
                ++count;
            }
        }
        if (count == 0) {
            return -64;
        }
        int avgHeight = totalHeight / count;
        return avgHeight;
    }

    public float getWindSpeedAmplifierForHeight(int height, int averageHeight, float extraHeightAmpMax) {
        int maxSpeedHeight = this.manager.getWorld().m_141928_();
        if (this.manager.getWorld().m_141937_() < 0) {
            int heightAdj = Math.abs(this.manager.getWorld().m_141937_());
            height += heightAdj;
            averageHeight += heightAdj;
        }
        int range = maxSpeedHeight - averageHeight;
        return 1.0f + Math.max(0.0f, (float)(height -= averageHeight) / (float)range * extraHeightAmpMax);
    }

    public void applyWindForceNew(Object ent, float multiplier, float maxSpeed) {
        this.applyWindForceNew(ent, multiplier, maxSpeed, true);
    }

    public void applyWindForceNew(Object ent, float multiplier, float maxSpeed, boolean dynamicWind) {
        Vec3 pos = new Vec3(CoroUtilEntOrParticle.getPosX((Object)ent), CoroUtilEntOrParticle.getPosY((Object)ent), CoroUtilEntOrParticle.getPosZ((Object)ent));
        Vec3 motion = this.applyWindForceImpl(pos, new Vec3(CoroUtilEntOrParticle.getMotionX((Object)ent), CoroUtilEntOrParticle.getMotionY((Object)ent), CoroUtilEntOrParticle.getMotionZ((Object)ent)), WeatherUtilEntity.getWeight(ent), multiplier, maxSpeed, dynamicWind);
        CoroUtilEntOrParticle.setMotionX((Object)ent, (double)motion.f_82479_);
        CoroUtilEntOrParticle.setMotionZ((Object)ent, (double)motion.f_82481_);
    }

    public Vec3 applyWindForceImpl(Vec3 pos, Vec3 motion, float weight, float multiplier, float maxSpeed, boolean dynamicWind) {
        float windSpeed = 0.0f;
        windSpeed = pos != null && ConfigWind.Wind_UsePerlinNoise ? this.getWindSpeed(dynamicWind ? CoroUtilBlock.blockPos((Vec3)pos) : null) * 0.5f + this.getWindSpeedPerlinNoise(pos) * 0.5f : this.getWindSpeed(dynamicWind ? CoroUtilBlock.blockPos((Vec3)pos) : null);
        float windAngle = this.getWindAngle(pos);
        float windX = (float)(-Math.sin(Math.toRadians(windAngle))) * windSpeed;
        float windZ = (float)Math.cos(Math.toRadians(windAngle)) * windSpeed;
        float objX = (float)motion.f_82479_;
        float objZ = (float)motion.f_82481_;
        float windWeight = 1.0f;
        float objWeight = weight;
        if (objWeight <= 0.0f) {
            objWeight = 0.001f;
        }
        float weightDiff = windWeight / objWeight;
        float vecX = (objX - windX) * weightDiff;
        float vecZ = (objZ - windZ) * weightDiff;
        vecX *= multiplier;
        vecZ *= multiplier;
        Vec3 newMotion = motion;
        double speedCheck = (double)(Math.abs(vecX) + Math.abs(vecZ)) / 2.0;
        if (speedCheck < (double)maxSpeed) {
            newMotion = new Vec3((double)(objX - vecX), motion.f_82480_, (double)(objZ - vecZ));
        } else {
            float speedDampen = (float)((double)maxSpeed / speedCheck);
            newMotion = new Vec3((double)(objX - vecX * speedDampen), motion.f_82480_, (double)(objZ - vecZ * speedDampen));
        }
        return newMotion;
    }

    public CompoundTag nbtSyncForClient() {
        CompoundTag data = new CompoundTag();
        data.m_128350_("windSpeedGlobal", this.windSpeedGlobal);
        data.m_128350_("windAngleGlobal", this.windAngleGlobal);
        data.m_128350_("windSpeedGust", this.windSpeedGust);
        data.m_128350_("windAngleGust", this.windAngleGust);
        data.m_128405_("windTimeGust", this.windTimeGust);
        return data;
    }

    public void nbtSyncFromServer(CompoundTag parNBT) {
        this.windSpeedGlobal = parNBT.m_128457_("windSpeedGlobal");
        this.windAngleGlobal = parNBT.m_128457_("windAngleGlobal");
        this.windSpeedGust = parNBT.m_128457_("windSpeedGust");
        this.windAngleGust = parNBT.m_128457_("windAngleGust");
        this.windTimeGust = parNBT.m_128451_("windTimeGust");
    }

    public Vec3 getWindForce(@Nullable BlockPos pos) {
        float windSpeed = this.getWindSpeed(pos);
        float windAngle = this.getWindAngle(null);
        float windX = (float)(-Math.sin(Math.toRadians(windAngle))) * windSpeed;
        float windZ = (float)Math.cos(Math.toRadians(windAngle)) * windSpeed;
        return new Vec3((double)windX, 0.0, (double)windZ);
    }

    public void syncData() {
        if (this.manager instanceof WeatherManagerServer) {
            ((WeatherManagerServer)this.manager).syncWindUpdate(this);
        }
    }

    public void reset() {
        this.manager = null;
    }

    public void read(CompoundTag data) {
        this.windSpeedGlobal = data.m_128457_("windSpeedGlobal");
        this.windAngleGlobal = data.m_128457_("windAngleGlobal");
        this.windSpeedGust = data.m_128457_("windSpeedGust");
        this.windAngleGust = data.m_128457_("windAngleGust");
        this.windTimeGust = data.m_128451_("windTimeGust");
        this.windSpeedEvent = data.m_128457_("windSpeedEvent");
        this.windAngleEvent = data.m_128457_("windAngleEvent");
        this.windTimeEvent = data.m_128451_("windTimeEvent");
        this.lowWindTimer = data.m_128451_("lowWindTimer");
        this.highWindTimer = data.m_128451_("highWindTimer");
    }

    public CompoundTag write(CompoundTag data) {
        data.m_128350_("windSpeedGlobal", this.windSpeedGlobal);
        data.m_128350_("windAngleGlobal", this.windAngleGlobal);
        data.m_128350_("windSpeedGust", this.windSpeedGust);
        data.m_128350_("windAngleGust", this.windAngleGust);
        data.m_128405_("windTimeGust", this.windTimeGust);
        data.m_128350_("windSpeedEvent", this.windSpeedEvent);
        data.m_128350_("windAngleEvent", this.windAngleEvent);
        data.m_128405_("windTimeEvent", this.windTimeEvent);
        data.m_128405_("lowWindTimer", this.lowWindTimer);
        data.m_128405_("highWindTimer", this.highWindTimer);
        return data;
    }

    public float getWindSpeedPerlinNoise(Vec3 pos) {
        PerlinNoise perlinNoise = PerlinNoiseHelper.get().getPerlinNoise();
        int indexX = (int)Math.floor(pos.f_82479_);
        int indexZ = (int)Math.floor(pos.f_82481_);
        double scale = 10.0;
        long time = Minecraft.m_91087_().f_91073_.m_46467_() * 2L;
        double posYAdj = 0.0;
        double noiseVal = perlinNoise.m_75408_((double)indexX * scale + (double)time, (double)indexZ * scale + (double)time, posYAdj);
        return (float)Math.max(-1.5, Math.min(1.5, noiseVal * 4.0));
    }
}

