/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.IConfigCategory;
import com.mojang.brigadier.CommandDispatcher;
import extendedrenderer.ParticleRegistry2ElectricBubbleoo;
import extendedrenderer.particle.ParticleRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import weather2.ClientRegistry;
import weather2.DeferredHelper;
import weather2.EventHandlerForge;
import weather2.SoundRegistry;
import weather2.WeatherBlocks;
import weather2.WeatherItems;
import weather2.WeatherNetworking;
import weather2.command.WeatherCommand;
import weather2.config.ConfigDebug;
import weather2.config.ConfigMisc;
import weather2.config.ConfigParticle;
import weather2.config.ConfigSand;
import weather2.config.ConfigSnow;
import weather2.config.ConfigSound;
import weather2.config.ConfigStorm;
import weather2.config.ConfigTornado;
import weather2.config.ConfigWind;
import weather2.data.BlockAndItemProvider;
import weather2.data.BlockLootTables;
import weather2.data.WeatherRecipeProvider;
import weather2.util.WeatherUtilSound;

@Mod(value="weather2")
public class Weather {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredHelper R = DeferredHelper.create("weather2");
    public static final String MODID = "weather2";
    public static boolean initProperNeededForWorld = true;
    public static List<IConfigCategory> listConfigs = new ArrayList<IConfigCategory>();
    public static ConfigMisc configMisc = null;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"weather2");
    public static final RegistryObject<CreativeModeTab> WEATHER_TAB = CREATIVE_MODE_TABS.register("weather_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.weather2")).m_257737_(() -> ((Item)WeatherItems.WEATHER_ITEM.get()).m_7968_()).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)WeatherItems.WEATHER_ITEM.get());
        output.m_246326_((ItemLike)WeatherItems.BLOCK_TORNADO_SIREN_ITEM.get());
        output.m_246326_((ItemLike)WeatherItems.BLOCK_TORNADO_SENSOR_ITEM.get());
        output.m_246326_((ItemLike)WeatherItems.BLOCK_DEFLECTOR_ITEM.get());
        output.m_246326_((ItemLike)WeatherItems.BLOCK_FORECAST_ITEM.get());
        output.m_246326_((ItemLike)WeatherItems.BLOCK_SAND_LAYER_ITEM.get());
        output.m_246326_((ItemLike)WeatherItems.BLOCK_ANEMOMETER_ITEM.get());
        output.m_246326_((ItemLike)WeatherItems.BLOCK_WIND_VANE_ITEM.get());
        output.m_246326_((ItemLike)WeatherItems.BLOCK_WIND_TURBINE_ITEM.get());
    }).m_257652_());

    public Weather() {
        ParticleRegistry2ElectricBubbleoo.bootstrap();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::serverStop);
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        CREATIVE_MODE_TABS.register(modBus);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::gatherData);
        modBus.addListener(this::processIMC);
        modBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
        WeatherBlocks.registerHandlers(modBus);
        WeatherItems.registerHandlers(modBus);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.register((Object)new WeatherBlocks());
        new File("./config/Weather2").mkdirs();
        configMisc = new ConfigMisc();
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(configMisc));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigWind()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigSand()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigSnow()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigStorm()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigTornado()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigParticle()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigDebug()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigSound()));
        SoundRegistry.init();
        if (FMLEnvironment.dist.isClient()) {
            modBus.addListener(ParticleRegistry::getRegisteredParticles);
            modBus.addListener(ClientRegistry::registerLayerDefinitions);
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(WeatherItems.WEATHER_ITEM);
        }
    }

    public static IConfigCategory addConfig(IConfigCategory config) {
        listConfigs.add(config);
        return config;
    }

    private void setup(FMLCommonSetupEvent event) {
        WeatherNetworking.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        WeatherUtilSound.init();
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void serverStart(ServerStartedEvent event) {
    }

    @SubscribeEvent
    public void serverStop(ServerStoppedEvent event) {
        initProperNeededForWorld = true;
    }

    public static void dbg(Object obj) {
        CULog.dbg((String)("" + obj));
    }

    public static boolean isLoveTropicsInstalled() {
        return ModList.get().isLoaded("ltminigames");
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        WeatherCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.addProvider(event.includeServer(), (DataProvider)new WeatherRecipeProvider(gen.getPackOutput()));
            gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(gen.getPackOutput(), Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTables::new, LootContextParamSets.f_81421_))));
        }
        if (event.includeClient()) {
            this.gatherClientData(event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void gatherClientData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new ParticleRegistry(packOutput, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockAndItemProvider(packOutput, existingFileHelper));
    }
}

