/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigMod;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import weather2.PacketNBTFromServer;
import weather2.WeatherNetworking;
import weather2.config.ClientConfigData;
import weather2.config.ConfigMisc;
import weather2.config.WeatherUtilConfig;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;

@Mod.EventBusSubscriber(modid="weather2")
public class ServerTickHandler {
    private static final Map<ResourceKey<Level>, WeatherManagerServer> MANAGERS = new Reference2ObjectOpenHashMap();
    private static final HashMap<String, WeatherManagerServer> MANAGERSLOOKUP = new HashMap();

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (!world.m_5776_() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            ResourceKey dimension = serverWorld.m_46472_();
            WeatherManagerServer weatherManagerServer = new WeatherManagerServer(serverWorld);
            if (WeatherUtilConfig.listDimensionsWeather.contains(weatherManagerServer.getWorld().m_46472_().m_135782_().toString())) {
                weatherManagerServer.read();
            }
            MANAGERS.put((ResourceKey<Level>)dimension, weatherManagerServer);
            MANAGERSLOOKUP.put(dimension.m_135782_().toString(), weatherManagerServer);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        if (!world.m_5776_() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            MANAGERS.remove(serverWorld.m_46472_());
            MANAGERSLOOKUP.remove(serverWorld.m_46472_().toString());
        }
    }

    @SubscribeEvent
    public static void tickServer(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (WeatherManagerServer manager : MANAGERS.values()) {
                manager.tick();
            }
            ServerTickHandler.processIMCMessages();
        }
    }

    @SubscribeEvent
    public static void tickServer(TickEvent.LevelTickEvent event) {
        if (event.level.m_46472_() == Level.f_46428_ && event.phase == TickEvent.Phase.END && !event.level.m_5776_() && ConfigMisc.Aesthetic_Only_Mode && !ConfigMisc.overcastMode) {
            ConfigMisc.overcastMode = true;
            CULog.dbg((String)"detected Aesthetic_Only_Mode on, setting overcast mode on");
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            ServerTickHandler.syncServerConfigToClient(null);
        }
    }

    public static void processIMCMessages() {
        InterModComms.getMessages((String)"weather2").forEach(msg -> {
            CompoundTag tag = (CompoundTag)msg.messageSupplier().get();
            String dimResource = tag.m_128461_("dimension");
            WeatherManagerServer wm = MANAGERSLOOKUP.get(dimResource);
            if (wm != null) {
                if (msg.method().equals("player_tornado")) {
                    int timeTicks = tag.m_128451_("time_ticks");
                    boolean baby = tag.m_128471_("baby");
                    String uuid = tag.m_128461_("uuid");
                    Player player = wm.getWorld().m_46003_(UUID.fromString(uuid));
                    if (player != null) {
                        StormObject stormObject = new StormObject(wm);
                        stormObject.setupStorm((Entity)player);
                        stormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                        stormObject.levelStormIntensityMax = StormObject.STATE_STAGE1;
                        stormObject.setupPlayerControlledTornado((Entity)player);
                        stormObject.setPlayerControlledTimeLeft(timeTicks);
                        stormObject.setBaby(baby);
                        wm.addStormObject(stormObject);
                        wm.syncStormNew(stormObject);
                        CULog.dbg((String)("processed imc message: " + tag));
                    } else {
                        CULog.err((String)("error cant find player in dimension " + dimResource + " for uuid " + uuid + " via IMC"));
                    }
                } else if (msg.method().equals("sharknado")) {
                    StormObject stormObject = new StormObject(wm);
                    stormObject.setupStorm(null);
                    stormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                    stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
                    stormObject.setSharknado(true);
                    stormObject.setupTornadoAwayFromPlayersAimAtPlayers();
                    wm.addStormObject(stormObject);
                    wm.syncStormNew(stormObject);
                    CULog.dbg((String)("processed imc message: " + tag));
                } else if (msg.method().equals("firenado")) {
                    StormObject stormObject = new StormObject(wm);
                    stormObject.setupStorm(null);
                    stormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                    stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
                    stormObject.isFirenado = true;
                    stormObject.setupTornadoAwayFromPlayersAimAtPlayers();
                    wm.addStormObject(stormObject);
                    wm.syncStormNew(stormObject);
                    CULog.dbg((String)("processed imc message: " + tag));
                } else if (msg.method().equals("tornado")) {
                    StormObject stormObject = new StormObject(wm);
                    stormObject.setupStorm(null);
                    stormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                    stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
                    stormObject.setSharknado(false);
                    stormObject.setupTornadoAwayFromPlayersAimAtPlayers();
                    wm.addStormObject(stormObject);
                    wm.syncStormNew(stormObject);
                    CULog.dbg((String)("processed imc message: " + tag));
                }
            } else {
                CULog.err((String)("error cant find WeatherManagerServer for dimension " + dimResource + " via IMC"));
            }
        });
    }

    @SubscribeEvent
    public static void tickPlayer(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_9236_().m_5776_()) {
            ServerTickHandler.syncServerConfigToClient(event.player);
        }
    }

    public static void joinPlayer(PlayerEvent.PlayerLoggedInEvent event) {
    }

    public static WeatherManagerServer getWeatherManagerFor(ResourceKey<Level> dimension) {
        return MANAGERS.get(dimension);
    }

    public static WeatherManagerServer getWeatherManagerFor(Level level) {
        return MANAGERS.get(level.m_46472_());
    }

    public static void playerClientRequestsFullSync(ServerPlayer entP) {
        WeatherManagerServer wm = MANAGERS.get(entP.m_9236_().m_46472_());
        if (wm != null) {
            wm.playerJoinedWorldSyncFull(entP);
        }
    }

    public static void syncServerConfigToClient(Player player) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("packetCommand", "ClientConfigData");
        data.m_128359_("command", "syncUpdate");
        ClientConfigData.writeNBT(data);
        if (player != null) {
            WeatherNetworking.HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PacketNBTFromServer(data));
        } else {
            WeatherNetworking.HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new PacketNBTFromServer(data));
        }
    }
}

