/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import weather2.ClientTickHandler;
import weather2.ClientWeatherHelper;
import weather2.Weather;
import weather2.client.SceneEnhancer;
import weather2.datatypes.PrecipitationType;
import weather2.ltcompat.ClientWeatherIntegration;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;

public final class ClientWeatherProxy {
    private static ClientWeatherProxy instance;
    private static boolean cacheIsSnowstorm;
    private static boolean cacheIsSandstorm;
    private static boolean cacheIsHail;
    private static int cacheRate;

    private ClientWeatherProxy() {
    }

    public static ClientWeatherProxy get() {
        if (instance == null) {
            instance = new ClientWeatherProxy();
        }
        return instance;
    }

    public void reset() {
        cacheIsSnowstorm = false;
        cacheIsSandstorm = false;
        cacheIsHail = false;
    }

    public float getRainAmount() {
        if (this.isWeatherEffectsServerSideControlled()) {
            return ClientWeatherIntegration.get().getRainAmount();
        }
        return ClientWeatherHelper.get().getPrecipitationStrength((Player)Minecraft.m_91087_().f_91074_);
    }

    public float getVanillaRainAmount() {
        if (Weather.isLoveTropicsInstalled()) {
            return ClientWeatherIntegration.get().getVanillaRainAmount();
        }
        return ClientWeatherHelper.get().getPrecipitationStrength((Player)Minecraft.m_91087_().f_91074_);
    }

    @Nullable
    public PrecipitationType getPrecipitationType(Biome biome) {
        if (Weather.isLoveTropicsInstalled()) {
            return ClientWeatherIntegration.get().getPrecipitationType();
        }
        if (biome == null) {
            return null;
        }
        if (biome.m_264473_() && biome.getModifiedClimateSettings().f_47682_() == Biome.TemperatureModifier.NONE) {
            return PrecipitationType.NORMAL;
        }
        if (biome.m_264473_() && biome.getModifiedClimateSettings().f_47682_() == Biome.TemperatureModifier.FROZEN) {
            return PrecipitationType.SNOW;
        }
        if (!biome.m_264473_()) {
            return null;
        }
        return null;
    }

    public float getWindSpeed() {
        return ClientWeatherIntegration.get().getWindSpeed();
    }

    public boolean isHeatwave() {
        return ClientWeatherIntegration.get().isHeatwave();
    }

    public boolean isSandstorm() {
        if (this.isWeatherEffectsServerSideControlled()) {
            return ClientWeatherIntegration.get().isSandstorm();
        }
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return false;
        }
        if (player.m_9236_().m_46467_() % (long)cacheRate == 0L) {
            Vec3 posPlayer = new Vec3(client.f_91074_.m_20185_(), 0.0, client.f_91074_.m_20189_());
            WeatherObjectParticleStorm storm = ClientTickHandler.weatherManager.getClosestParticleStormByIntensity(posPlayer, WeatherObjectParticleStorm.StormType.SANDSTORM);
            cacheIsSandstorm = storm != null && posPlayer.m_82554_(storm.pos) < (double)storm.getSize();
        }
        return cacheIsSandstorm;
    }

    public boolean isSnowstorm() {
        if (this.isWeatherEffectsServerSideControlled()) {
            return ClientWeatherIntegration.get().isSnowstorm();
        }
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return false;
        }
        if (player.m_9236_().m_46467_() % (long)cacheRate == 0L) {
            Vec3 posPlayer = new Vec3(client.f_91074_.m_20185_(), 0.0, client.f_91074_.m_20189_());
            WeatherObjectParticleStorm storm = ClientTickHandler.weatherManager.getClosestParticleStormByIntensity(posPlayer, WeatherObjectParticleStorm.StormType.SNOWSTORM);
            cacheIsSnowstorm = storm != null && posPlayer.m_82554_(storm.pos) < (double)storm.getSize();
        }
        return cacheIsSnowstorm;
    }

    public boolean isHail() {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return false;
        }
        if (player.m_9236_().m_46467_() % (long)cacheRate == 0L) {
            double maxStormDist;
            Vec3 posPlayer = new Vec3(client.f_91074_.m_20185_(), 0.0, client.f_91074_.m_20189_());
            StormObject storm = ClientTickHandler.weatherManager.getClosestStorm(posPlayer, maxStormDist = 384.0, StormObject.STATE_HAIL, StormObject.STATE_HAIL, false);
            cacheIsHail = storm != null && posPlayer.m_82554_(storm.posGround) < (double)storm.getSize();
        }
        return cacheIsHail;
    }

    public boolean hasWeather() {
        if (SceneEnhancer.FORCE_ON_DEBUG_TESTING) {
            return true;
        }
        return ClientWeatherIntegration.get().hasWeather();
    }

    public boolean isWeatherEffectsServerSideControlled() {
        return Weather.isLoveTropicsInstalled();
    }

    static {
        cacheIsSnowstorm = false;
        cacheIsSandstorm = false;
        cacheIsHail = false;
        cacheRate = 40;
    }
}

