/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.behavior;

import com.corosus.coroutil.util.CoroUtilBlock;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ParticleBehaviorSandstorm
extends ParticleBehaviors {
    public int curTick = 0;
    public int ticksMax = 1;

    public ParticleBehaviorSandstorm(Vec3 source) {
        super(source);
    }

    @Override
    public EntityRotFX initParticle(EntityRotFX particle) {
        super.initParticle(particle);
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(50) - this.rand.nextInt(50);
        particle.m_107257_(450 + this.rand.nextInt(10));
        float randFloat = this.rand.nextFloat() * 0.6f;
        float baseBright = 0.7f;
        float finalBright = Math.min(1.0f, baseBright + randFloat);
        particle.m_107253_(finalBright, finalBright, finalBright);
        particle.brightness = 1.0f;
        particle.m_107271_(1.0f);
        float sizeBase = (float)(30.0 + this.rand.nextDouble() * 4.0);
        particle.setScale(sizeBase);
        particle.setCanCollide(true);
        particle.renderRange = 2048.0f;
        particle.setFacePlayer(true);
        particle.setGravity(0.03f);
        return particle;
    }

    @Override
    public void tickUpdateAct(EntityRotFX particle) {
        if (!particle.m_107276_()) {
            this.particles.remove(particle);
        } else {
            particle.rotationYaw = particle.getEntityId() % 2 == 0 ? (float)((double)particle.rotationYaw - 0.1) : (float)((double)particle.rotationYaw + 0.1);
            float ticksFadeInMax = 10.0f;
            float ticksFadeOutMax = 10.0f;
            if ((float)particle.getAge() < ticksFadeInMax) {
                particle.m_107271_(Math.min(1.0f, (float)particle.getAge() / ticksFadeInMax));
            } else if ((float)particle.getAge() > (float)particle.m_107273_() - ticksFadeOutMax) {
                float count = (float)particle.getAge() - ((float)particle.m_107273_() - ticksFadeOutMax);
                float val = (ticksFadeOutMax - count) / ticksFadeOutMax;
                particle.m_107271_(val);
            }
            double moveSpeed = 0.001;
            BlockPos pos = CoroUtilBlock.blockPos((double)particle.getPosX(), (double)(particle.getPosY() - particle.aboveGroundHeight), (double)particle.getPosZ());
            BlockState state = particle.getWorld().m_8055_(pos);
            if (!state.m_60795_()) {
                if (particle.getMotionY() < particle.bounceSpeedMax) {
                    particle.setMotionY(particle.getMotionY() + particle.bounceSpeed);
                }
            } else {
                double aheadMultiplier = 20.0;
                BlockPos posAhead = CoroUtilBlock.blockPos((double)(particle.getPosX() + particle.getMotionX() * aheadMultiplier), (double)(particle.getPosY() - particle.aboveGroundHeight), (double)(particle.getPosZ() + particle.getMotionZ() * aheadMultiplier));
                BlockState stateAhead = particle.getWorld().m_8055_(posAhead);
                if (!stateAhead.m_60795_() && particle.getMotionY() < particle.bounceSpeedMaxAhead) {
                    particle.setMotionY(particle.getMotionY() + particle.bounceSpeedAhead);
                }
            }
            double moveSpeedRand = 0.005;
            particle.setMotionX(particle.getMotionX() + (this.rand.nextDouble() * moveSpeedRand - this.rand.nextDouble() * moveSpeedRand));
            particle.setMotionZ(particle.getMotionZ() + (this.rand.nextDouble() * moveSpeedRand - this.rand.nextDouble() * moveSpeedRand));
            if (particle.spawnY != -1.0f) {
                particle.m_107264_(particle.getPosX(), particle.spawnY, particle.getPosZ());
            }
        }
    }
}

