/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.DualControllerBuilder;
import com.faboslav.structurify.common.config.client.api.option.HolderOption;
import com.faboslav.structurify.common.config.client.api.option.OptionPair;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class StructureSetsConfigScreen {
    @Nullable
    public YACLScreen structureSetsScreen = null;
    public Map<String, AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>>> structureSetOptions = new HashMap<String, AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>>>();
    public Map<String, OptionGroup> optionGroups = new HashMap<String, OptionGroup>();
    public Option<Boolean> enableGlobalSpacingAndSeparationOption = null;
    public Option<Double> globalSpacingAndSeparationModifierOption = null;

    public void createStructureSetsScreen(StructurifyConfig config, Screen parent) {
        LoadConfigEvent.EVENT.invoke(new LoadConfigEvent());
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((Component)Component.m_237115_((String)"gui.structurify.structure_sets_category.title")).save(config::save);
        this.createStructureSetsTab(yacl, config);
        this.structureSetsScreen = (YACLScreen)yacl.build().generateScreen(parent);
    }

    @Nullable
    public YACLScreen getStructureSetsScreen() {
        return this.structureSetsScreen;
    }

    public void createStructureSetsTab(YetAnotherConfigLib.Builder yacl, StructurifyConfig config) {
        ConfigCategory.Builder structureSetCategoryBuilder = ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets_category.title")).tooltip(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets_category.description").m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.spacing.description")).m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.separation.description"))});
        this.addGlobalOptions(structureSetCategoryBuilder, config);
        Map<String, StructureSetData> structureSets = WorldgenDataProvider.getStructureSets();
        ArrayList<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
        OptionGroup.Builder currentGroupBuilder = null;
        String currentNamespace = null;
        for (Map.Entry<String, StructureSetData> entry : structureSets.entrySet()) {
            String structureSetStringId = entry.getKey();
            ResourceLocation structureSetId = Structurify.makeNamespacedId(structureSetStringId);
            String namespace = structureSetId.m_135827_();
            if (!namespace.equals(currentNamespace)) {
                if (currentGroupBuilder != null) {
                    optionGroups.add(currentGroupBuilder.build());
                }
                currentGroupBuilder = OptionGroup.createBuilder().name((Component)Component.m_237110_((String)"gui.structurify.structure_sets.structure_group.title", (Object[])new Object[]{LanguageUtil.translateId(null, namespace)})).description(OptionDescription.of((Component[])new Component[]{Component.m_237110_((String)"gui.structurify.structure_sets.structure_group.description", (Object[])new Object[]{namespace})}));
                currentNamespace = namespace;
            }
            MutableComponent translatedStructureSetName = LanguageUtil.translateId("structure", structureSetStringId);
            OptionDescription.Builder saltDescriptionBuilder = OptionDescription.createBuilder();
            saltDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.salt.description")});
            Option saltOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.salt.title")).description(saltDescriptionBuilder.build()).binding((Object)config.getStructureSetData().get(structureSetStringId).getDefaultSalt(), () -> config.getStructureSetData().get(structureSetStringId).getSalt(), salt -> config.getStructureSetData().get(structureSetStringId).setSalt((int)salt)).controller(opt -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)opt).range((Number)0, (Number)Integer.MAX_VALUE)).formatValue(value -> Component.m_237113_((String)value.toString()))).build();
            OptionDescription.Builder frequencyDescriptionBuilder = OptionDescription.createBuilder();
            saltDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.frequency.description")});
            Option frequencyOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.frequency.title")).description(frequencyDescriptionBuilder.build()).binding((Object)Float.valueOf(config.getStructureSetData().get(structureSetStringId).getDefaultFrequency()), () -> Float.valueOf(config.getStructureSetData().get(structureSetStringId).getFrequency()), frequency -> config.getStructureSetData().get(structureSetStringId).setFrequency(frequency.floatValue())).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.01f))).formatValue(value -> Component.m_237113_((String)String.format(Locale.ROOT, "%.2f", value)))).build();
            currentGroupBuilder.option((Option)LabelOption.createBuilder().line((Component)translatedStructureSetName).build());
            currentGroupBuilder.option(saltOption);
            currentGroupBuilder.option(frequencyOption);
            int defaultSpacing = config.getStructureSetData().get(structureSetStringId).getDefaultSpacing();
            int defaultSeparation = config.getStructureSetData().get(structureSetStringId).getDefaultSeparation();
            if (defaultSpacing == 0 || defaultSeparation == 0) continue;
            OptionDescription.Builder overrideGlobalSpacingAndSeparationModifierDescriptionBuilder = OptionDescription.createBuilder();
            overrideGlobalSpacingAndSeparationModifierDescriptionBuilder.text(new Component[]{Component.m_237110_((String)"gui.structurify.structure_sets.override_global_spacing_and_separation_modifier.description", (Object[])new Object[]{translatedStructureSetName})});
            Option overrideGlobalSpacingAndSeparationModifierOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.override_global_spacing_and_separation_modifier.title")).description(overrideGlobalSpacingAndSeparationModifierDescriptionBuilder.build()).binding((Object)false, () -> config.getStructureSetData().get(structureSetStringId).overrideGlobalSpacingAndSeparationModifier(), overrideGlobalSpacingAndSeparationModifier -> config.getStructureSetData().get(structureSetStringId).setOverrideGlobalSpacingAndSeparationModifier((boolean)overrideGlobalSpacingAndSeparationModifier)).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes") : Component.m_237115_((String)"gui.structurify.label.no"))).coloured(true)).available(config.enableGlobalSpacingAndSeparationModifier).build();
            overrideGlobalSpacingAndSeparationModifierOption.addListener((opt, enableGlobalSpacingAndSeparationModifier) -> {
                boolean available = false;
                if (enableGlobalSpacingAndSeparationModifier.booleanValue()) {
                    available = true;
                }
                AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>> structureSetOption = this.structureSetOptions.get(structureSetStringId);
                structureSetOption.getValue().setAvailable(available);
            });
            OptionDescription.Builder spacingDescriptionBuilder = OptionDescription.createBuilder();
            spacingDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.spacing.description")});
            Option spacingOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.spacing.title")).description(spacingDescriptionBuilder.build()).binding((Object)config.getStructureSetData().get(structureSetStringId).getDefaultSpacing(), () -> config.getStructureSetData().get(structureSetStringId).getSpacing(), spacing -> config.getStructureSetData().get(structureSetStringId).setSpacing((int)spacing)).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).valueFormatter(spacing -> {
                AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>> structureSetOption = this.structureSetOptions.get(structureSetStringId);
                Boolean overrideSpacingAndSeparationModifierDescription = (Boolean)structureSetOption.getKey().pendingValue();
                if (((Boolean)this.enableGlobalSpacingAndSeparationOption.pendingValue()).booleanValue() && !overrideSpacingAndSeparationModifierDescription.booleanValue()) {
                    spacing = (int)((double)spacing.intValue() * (Double)this.globalSpacingAndSeparationModifierOption.pendingValue());
                }
                return Component.m_237113_((String)String.valueOf(spacing));
            })).range((Number)0, (Number)512)).step((Number)1)).build();
            OptionDescription.Builder separationDescriptionBuilder = OptionDescription.createBuilder();
            separationDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.separation.description")});
            separationDescriptionBuilder.text(new Component[]{Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.warning")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW))});
            Option separationOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.separation.title")).description(separationDescriptionBuilder.build()).binding((Object)config.getStructureSetData().get(structureSetStringId).getDefaultSeparation(), () -> config.getStructureSetData().get(structureSetStringId).getSeparation(), separation -> config.getStructureSetData().get(structureSetStringId).setSeparation((int)separation)).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).valueFormatter(separation -> {
                AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>> structureSetOption = this.structureSetOptions.get(structureSetStringId);
                Boolean overrideSpacingAndSeparationModifierDescription = (Boolean)structureSetOption.getKey().pendingValue();
                if (((Boolean)this.enableGlobalSpacingAndSeparationOption.pendingValue()).booleanValue() && !overrideSpacingAndSeparationModifierDescription.booleanValue()) {
                    separation = (int)((double)separation.intValue() * (Double)this.globalSpacingAndSeparationModifierOption.pendingValue());
                }
                return Component.m_237113_((String)String.valueOf(separation));
            })).range((Number)0, (Number)512)).step((Number)1)).build();
            spacingOption.addListener((opt, spacing) -> {
                if (spacing <= (Integer)separationOption.pendingValue()) {
                    spacingOption.requestSet((Object)((Integer)separationOption.pendingValue() + 1));
                }
            });
            separationOption.addListener((opt, separation) -> {
                if (separation >= (Integer)spacingOption.pendingValue()) {
                    separationOption.requestSet((Object)((Integer)spacingOption.pendingValue() - 1));
                }
            });
            Option spacingAndSeparationOption = HolderOption.createBuilder().controller(opt -> DualControllerBuilder.create(LabelOption.createBuilder().line((Component)translatedStructureSetName).build(), spacingOption, separationOption)).available(!config.enableGlobalSpacingAndSeparationModifier || config.getStructureSetData().get(structureSetStringId).overrideGlobalSpacingAndSeparationModifier()).build();
            currentGroupBuilder.option(overrideGlobalSpacingAndSeparationModifierOption);
            currentGroupBuilder.option(spacingAndSeparationOption);
            this.structureSetOptions.put(structureSetStringId, new AbstractMap.SimpleEntry<Option, Option>(overrideGlobalSpacingAndSeparationModifierOption, spacingAndSeparationOption));
        }
        if (currentGroupBuilder != null) {
            OptionGroup buildedGroup = currentGroupBuilder.build();
            this.optionGroups.put(buildedGroup.name().getString(), buildedGroup);
            optionGroups.add(buildedGroup);
        }
        for (OptionGroup structureOptionGroup : optionGroups) {
            structureSetCategoryBuilder.group(structureOptionGroup);
        }
        yacl.category(structureSetCategoryBuilder.build());
    }

    public void addGlobalOptions(ConfigCategory.Builder categoryBuilder, StructurifyConfig config) {
        OptionGroup.Builder generalStructuresSetsGroupBuilder = OptionGroup.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.global_spacing_and_separation.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.global_spacing_and_separation.description")}));
        OptionDescription.Builder enableGlobalSpacingAndSeparationDescriptionBuilder = OptionDescription.createBuilder();
        enableGlobalSpacingAndSeparationDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.enable_global_spacing_and_separation_modifier.description")});
        enableGlobalSpacingAndSeparationDescriptionBuilder.text(new Component[]{Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.warning")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW))});
        this.enableGlobalSpacingAndSeparationOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.enable_global_spacing_and_separation_modifier.title")).description(enableGlobalSpacingAndSeparationDescriptionBuilder.build()).binding((Object)false, () -> config.enableGlobalSpacingAndSeparationModifier, enableGlobalSpacingAndSeparationModifier -> {
            config.enableGlobalSpacingAndSeparationModifier = enableGlobalSpacingAndSeparationModifier;
        }).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes") : Component.m_237115_((String)"gui.structurify.label.no"))).coloured(true)).build();
        generalStructuresSetsGroupBuilder.option(this.enableGlobalSpacingAndSeparationOption);
        this.enableGlobalSpacingAndSeparationOption.addListener((opt, enableGlobalSpacingAndSeparationModifier) -> {
            for (Map.Entry<String, AbstractMap.SimpleEntry<Option<Boolean>, Option<OptionPair<Option<Integer>, Option<Integer>>>>> structureSetOption : this.structureSetOptions.entrySet()) {
                Option<Boolean> structureSetOptionOverride = structureSetOption.getValue().getKey();
                Option<OptionPair<Option<Integer>, Option<Integer>>> structureSetOptionPair = structureSetOption.getValue().getValue();
                structureSetOptionOverride.setAvailable(enableGlobalSpacingAndSeparationModifier.booleanValue());
                structureSetOptionPair.setAvailable(enableGlobalSpacingAndSeparationModifier == false || (Boolean)structureSetOptionOverride.pendingValue() != false);
            }
        });
        OptionDescription.Builder globalSpacingAndSeparationModifierDescriptionBuilder = OptionDescription.createBuilder();
        globalSpacingAndSeparationModifierDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.global_spacing_and_separation_modifier.description")});
        globalSpacingAndSeparationModifierDescriptionBuilder.text(new Component[]{Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.warning")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW))});
        this.globalSpacingAndSeparationModifierOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.global_spacing_and_separation_modifier.title")).description(globalSpacingAndSeparationModifierDescriptionBuilder.build()).binding((Object)1.0, () -> config.globalSpacingAndSeparationModifier, modifier -> {
            config.globalSpacingAndSeparationModifier = modifier;
        }).controller(opt -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)0.1, (Number)100.0)).step((Number)0.1)).build();
        generalStructuresSetsGroupBuilder.option(this.globalSpacingAndSeparationModifierOption);
        categoryBuilder.group(generalStructuresSetsGroupBuilder.build());
    }
}

