/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.tact;

import com.telepathicgrunt.tact.Config;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.resource.PathPackResources;

public class DataAndResourcePacks {
    static void setupBuiltInDataPack(AddPackFindersEvent event) {
        try {
            Pack pack;
            Path resourcePath;
            if (((Boolean)Config.APPLY_TAG_ADJUSTMENTS.get()).booleanValue() && event.getPackType() == PackType.SERVER_DATA) {
                resourcePath = ModList.get().getModFileById("tact").getFile().findResource(new String[]{"datapacks/apply_tag_adjustments"});
                pack = Pack.m_245429_((String)"tact/apply_tag_adjustments", (Component)Component.m_237113_((String)"TACT - Adjusted Tags"), (boolean)true, path -> new PathPackResources(path, false, resourcePath), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
                event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
            }
            if (((Boolean)Config.APPLY_SPELUNKERY_COMPAT_ADJUSTMENTS.get()).booleanValue() && event.getPackType() == PackType.SERVER_DATA && ModList.get().isLoaded("spelunkery")) {
                resourcePath = ModList.get().getModFileById("tact").getFile().findResource(new String[]{"datapacks/spelunkery_compat_adjustments"});
                pack = Pack.m_245429_((String)"tact/spelunkery_compat_adjustments", (Component)Component.m_237113_((String)"TACT - Spelunkery Compat Adjustments"), (boolean)true, path -> new PathPackResources(path, false, resourcePath), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
                event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
            }
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                DataAndResourcePacks.loadTACTConfigsEarly();
                if (((Boolean)Config.RESTORE_END_STORY.get()).booleanValue()) {
                    resourcePath = ModList.get().getModFileById("tact").getFile().findResource(new String[]{"resourcepacks/restore_end_story"});
                    pack = Pack.m_245429_((String)"tact/restore_end_story", (Component)Component.m_237113_((String)"TACT - Restore End Story"), (boolean)true, path -> new PathPackResources(path, false, resourcePath), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_);
                    event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void loadTACTConfigsEarly() {
        Optional modContainerById = ModList.get().getModContainerById("tact");
        modContainerById.ifPresent(container -> ((Set)ConfigTracker.INSTANCE.configSets().get(ModConfig.Type.COMMON)).forEach(c -> {
            if (c.getFileName().equals("tact-common.toml")) {
                try {
                    Method method = ConfigTracker.INSTANCE.getClass().getDeclaredMethod("openConfig", ModConfig.class, Path.class);
                    method.setAccessible(true);
                    method.invoke((Object)ConfigTracker.INSTANCE, c, FMLPaths.CONFIGDIR.get());
                    method.setAccessible(false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }
}

