/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.core.registry;

import com.peeko32213.unusualprehistory.common.data.ItemWeightedPairCodec;
import com.peeko32213.unusualprehistory.common.data.LootFruitCodec;
import com.peeko32213.unusualprehistory.common.data.LootFruitJsonManager;
import com.peeko32213.unusualprehistory.common.data.RollableItemCodec;
import com.peeko32213.unusualprehistory.common.item.MusicalTameItem;
import com.peeko32213.unusualprehistory.core.registry.UPBlocks;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class UPTabs {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"unusualprehistory");
    private static final CreativeModeTab UP = new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 9).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.unusual_prehistory")).m_257737_(() -> new ItemStack((ItemLike)UPItems.AMMONITE_SHELL_ICON.get())).m_257501_((d, entries) -> {
        for (RegistryObject item : UPItems.ITEMS.getEntries()) {
            if (item.get() instanceof ForgeSpawnEggItem) continue;
            d.f_268485_().m_254861_(Registries.f_257010_).ifPresent(p_270036_ -> UPTabs.generateInstrumentTypes(entries, (HolderLookup<Instrument>)p_270036_, (Item)UPItems.BARINA_WHISTLE.get(), UPTags.OCARINA_WHISTLE, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            if (!((Item)item.get()).m_7968_().m_150930_((Item)UPItems.BARINA_WHISTLE.get()) && !((Item)item.get()).m_7968_().m_150930_(((Block)UPBlocks.FRUIT_LOOT_BOX.get()).m_5456_())) {
                entries.m_246326_((ItemLike)item.get());
            }
            UPTabs.addTagToLootFruit(entries, ((Block)UPBlocks.FRUIT_LOOT_BOX.get()).m_5456_(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }).m_257652_();
    private static final CreativeModeTab UP_EGGS = new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 9).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.unusual_prehistory_eggs")).m_257737_(() -> new ItemStack((ItemLike)UPItems.MAJUNGA_EGG.get())).m_257501_((d, entries) -> UPItems.ITEMS.getEntries().forEach(i -> {
        if (i.get() instanceof ForgeSpawnEggItem) {
            entries.m_246326_((ItemLike)i.get());
        }
    })).m_257652_();
    public static final RegistryObject<CreativeModeTab> UP_TAB = TABS.register("unusual_prehistory", () -> UP);
    public static final RegistryObject<CreativeModeTab> UP_EGG_TAB = TABS.register("unusual_prehistory_egg", () -> UP_EGGS);
    private static final LootFruitCodec LOOT_FRUIT = new LootFruitCodec(2, "unusualprehistory.loot_fruit_box.default", Items.f_41911_, Collections.emptyList(), TextColor.m_131266_((int)12345), 2);
    private static final List<LootFruitCodec> LOOT_FRUIT_LIST = new ArrayList<LootFruitCodec>(){
        {
            this.add(LOOT_FRUIT);
        }
    };

    private static void generateInstrumentTypes(CreativeModeTab.Output pOutput, HolderLookup<Instrument> pInstruments, Item pItem, TagKey<Instrument> pInstrument, CreativeModeTab.TabVisibility pTabVisibility) {
        pInstruments.m_254901_(pInstrument).ifPresent(p_270021_ -> p_270021_.m_203614_().map(p_269995_ -> MusicalTameItem.create(pItem, (Holder<Instrument>)p_269995_)).forEach(p_270011_ -> pOutput.m_246267_(p_270011_, pTabVisibility)));
    }

    private static void generateEnchantsForBoots(CreativeModeTab.Output output, Item item, CreativeModeTab.TabVisibility tabVisibility) {
        ItemStack soulsuckerBoots = new ItemStack((ItemLike)item);
        soulsuckerBoots.m_41663_(Enchantments.f_44976_, 3);
        output.m_246267_(soulsuckerBoots, tabVisibility);
    }

    private static void addTagToDinosaurWhistle(CreativeModeTab.Output output, Item item, CreativeModeTab.TabVisibility tabVisibility) {
        ItemStack dinoWhistle = new ItemStack((ItemLike)item);
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("command", 0);
        dinoWhistle.m_41751_(compoundTag);
        output.m_246267_(dinoWhistle, tabVisibility);
    }

    private static void addTagToLootFruit(CreativeModeTab.Output output, Item item, CreativeModeTab.TabVisibility tabVisibility) {
        boolean isEmpty = LootFruitJsonManager.getTierTrades().isEmpty();
        if (!isEmpty) {
            Map<Integer, List<LootFruitCodec>> lootFruitItem = LootFruitJsonManager.getTierTrades();
            for (List<LootFruitCodec> lootFruitCodecs : lootFruitItem.values()) {
                for (LootFruitCodec lootFruitCodec : lootFruitCodecs) {
                    ItemStack istack = new ItemStack((ItemLike)item);
                    CompoundTag lootFruitTag = istack.m_41784_();
                    int color = lootFruitCodec.getColor().m_131265_();
                    lootFruitTag.m_128359_("translationKey", lootFruitCodec.getTranslationKey());
                    lootFruitTag.m_128405_("color", color);
                    lootFruitTag.m_128365_("tradeItem", (Tag)lootFruitCodec.getTradeItem().m_7968_().serializeNBT());
                    lootFruitTag.m_128405_("CustomModelData", lootFruitCodec.getCustomModelData());
                    istack.m_41751_(lootFruitTag);
                    output.m_246267_(istack, tabVisibility);
                }
            }
        } else {
            ItemStack istack = new ItemStack((ItemLike)item);
            ArrayList<ItemWeightedPairCodec> itemWeightedPairCodecs = new ArrayList<ItemWeightedPairCodec>();
            itemWeightedPairCodecs.add(new ItemWeightedPairCodec((Item)UPItems.PALEO_FOSSIL.get(), 100, 1));
            ArrayList<RollableItemCodec> rollableItemCodecs = new ArrayList<RollableItemCodec>();
            rollableItemCodecs.add(new RollableItemCodec(1, itemWeightedPairCodecs));
            LootFruitCodec lootFruitCodec = LOOT_FRUIT;
            CompoundTag lootFruitTag = istack.m_41784_();
            if (lootFruitCodec == null) {
                return;
            }
            int color = lootFruitCodec.getColor().m_131265_();
            lootFruitTag.m_128359_("translationKey", lootFruitCodec.getTranslationKey());
            lootFruitTag.m_128405_("color", color);
            lootFruitTag.m_128405_("CustomModelData", lootFruitCodec.getCustomModelData());
            lootFruitTag.m_128365_("tradeItem", (Tag)lootFruitCodec.getTradeItem().m_7968_().serializeNBT());
            istack.m_41751_(lootFruitTag);
            output.m_246267_(istack, tabVisibility);
        }
    }
}

