/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.world.feature.tree;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public final class FeaturePlacers {
    public static final BiFunction<LevelSimulatedReader, BlockPos, Boolean> VALID_TREE_POS = TreeFeature::m_67272_;

    public static void placeProvidedBlock(LevelSimulatedReader world, FoliagePlacer.FoliageSetter setter, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos pos, BlockStateProvider config, RandomSource random) {
        if (predicate.apply(world, pos).booleanValue()) {
            setter.m_271838_(pos, config.m_213972_(random, pos));
        }
    }

    public static void placeSpheroid(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius, float verticalBias, BlockStateProvider config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(0, y, 0), config, random);
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + ((float)y2 - verticalBias) * ((float)y2 - verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, y2, -x), config, random);
                        }
                        if (xzSquare + ((float)y2 + verticalBias) * ((float)y2 + verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, -y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, -y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, -y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, -y2, -x), config, random);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static <T extends Comparable<T>> BlockState transferStateKey(BlockState stateIn, BlockState stateOut, Property<T> property) {
        if (!stateIn.m_61138_(property) || !stateOut.m_61138_(property)) {
            return stateOut;
        }
        return (BlockState)stateOut.m_61124_(property, stateIn.m_61143_(property));
    }
}

