/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.world.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityWorldSpawnable;
import com.peeko32213.unusualprehistory.core.registry.UPBlocks;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import com.peeko32213.unusualprehistory.core.registry.util.FastNoiseLite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class IceFossilFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockState END_STONE = Blocks.f_50259_.m_49966_();
    private static final BlockState STONE = Blocks.f_50069_.m_49966_();
    private static final BlockState DIRT = Blocks.f_50493_.m_49966_();
    private static final BlockState COARSE_DIRT = Blocks.f_50546_.m_49966_();
    private static final BlockState SANDSTONE = Blocks.f_50062_.m_49966_();
    private static final BlockState SAND = Blocks.f_49992_.m_49966_();
    private static final BlockState TAR = ((Block)UPBlocks.TAR.get()).m_49966_();
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final BlockState WATER = Blocks.f_49990_.m_49966_();
    private static final BlockState WW = Blocks.f_50041_.m_49966_();
    private static final BlockState BW = Blocks.f_50106_.m_49966_();
    private static final BlockState RW = Blocks.f_50108_.m_49966_();
    private static final BlockState GW = Blocks.f_50107_.m_49966_();
    private static final BlockState BBW = Blocks.f_50105_.m_49966_();
    private static final BlockState YW = Blocks.f_50098_.m_49966_();
    private static final BlockState OW = Blocks.f_50042_.m_49966_();
    private static final BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();

    public IceFossilFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel worldGenLevel = pContext.m_159774_();
        BlockPos blockPos = pContext.m_159777_();
        BlockState firstState = worldGenLevel.m_8055_(blockPos);
        RandomSource random = pContext.m_225041_();
        FastNoiseLite noiseIceBerg = IceFossilFeature.createNoise(worldGenLevel.m_7328_() + random.m_188505_(), 0.11f);
        FastNoiseLite noiseBlueIce = IceFossilFeature.createNoise(worldGenLevel.m_7328_() + random.m_188505_(), 0.11f);
        FastNoiseLite noiseFossil = IceFossilFeature.createNoise(worldGenLevel.m_7328_() + random.m_188505_(), 0.1f);
        IceFossilFeature.createIceBerg(worldGenLevel, random, blockPos, noiseBlueIce);
        IceFossilFeature.addFossil(worldGenLevel, random, blockPos, noiseFossil);
        return true;
    }

    public static void createIceBerg(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise) {
        BlockState block = Blocks.f_50354_.m_49966_();
        boolean changeDenseIce = rand.m_188499_();
        if (changeDenseIce) {
            block = ((Block)UPBlocks.PERMAFROST.get()).m_49966_();
        }
        BlockState block2 = Blocks.f_50126_.m_49966_();
        BlockState block3 = Blocks.f_50016_.m_49966_();
        origin = origin.m_7918_(0, -4, 0);
        int[][] icebergConfigs = new int[][]{{8, 35}, {5, 40}, {12, 25}, {14, 15}, {15, 15}};
        for (int i = 0; i < icebergConfigs.length; ++i) {
            int radius = icebergConfigs[i][0];
            int height = icebergConfigs[i][1];
            boolean finalSection = false;
            if (i + 1 >= icebergConfigs.length) {
                finalSection = true;
            }
            IceFossilFeature.createIceBergSection(worldgenlevel, origin, radius, height, block, block2, block3, noise, finalSection);
        }
    }

    private static void createIceBergSection(WorldGenLevel worldgenlevel, BlockPos origin, int radius, int height, BlockState block, BlockState block2, BlockState block3, FastNoiseLite noise, boolean finalSection) {
        BlockState block4 = ((Block)UPBlocks.PERMAFROST_FOSSIL.get()).m_49966_();
        BlockState block5 = Blocks.f_50127_.m_49966_();
        BlockState block6 = Blocks.f_49990_.m_49966_();
        int heightLower = 0;
        if (finalSection) {
            heightLower = -height;
        }
        for (int x = -radius; x < radius; ++x) {
            for (int y = heightLower; y < height; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos = origin.m_7918_(x, y, z);
                    double distance = IceFossilFeature.distance(x, y, z, radius, height, radius);
                    float f = noise.GetNoise(x, y, z);
                    if (!(distance < 1.0)) continue;
                    if (f < 0.0f && (double)f > -0.3) {
                        if ((double)f > -0.25 && (double)f < -0.245) {
                            worldgenlevel.m_7731_(pos, block4, 3);
                            continue;
                        }
                        worldgenlevel.m_7731_(pos, block, 3);
                        continue;
                    }
                    if ((double)f <= 0.4 && f > 0.0f) {
                        worldgenlevel.m_7731_(pos, block2, 3);
                        continue;
                    }
                    if ((double)f > 0.4 && (double)f < 0.9 && pos.m_123342_() > origin.m_123342_() + 15) {
                        worldgenlevel.m_7731_(pos, block5, 3);
                        continue;
                    }
                    if (pos.m_123342_() < 63) {
                        worldgenlevel.m_7731_(pos, block6, 3);
                        continue;
                    }
                    worldgenlevel.m_7731_(pos, block3, 3);
                }
            }
        }
    }

    public static void addFossil(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise) {
        EntityWorldSpawnable entityWorldSpawnable = (EntityWorldSpawnable)((EntityType)UPEntities.ICEBERG_SMILODON.get()).m_20615_((Level)worldgenlevel.m_6018_());
        if (rand.m_188499_()) {
            entityWorldSpawnable = (EntityWorldSpawnable)((EntityType)UPEntities.ICEBERG_MAMMOTH.get()).m_20615_((Level)worldgenlevel.m_6018_());
        }
        int height = (int)entityWorldSpawnable.m_20206_() * 3;
        int radius = (int)entityWorldSpawnable.m_20205_() * 2;
        BlockState block = Blocks.f_50126_.m_49966_();
        BlockState block2 = Blocks.f_50016_.m_49966_();
        origin = origin.m_7918_(0, -radius / 2 - 1, 0);
        for (int x = -radius; x < radius; ++x) {
            for (int y = -height; y < height; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos = origin.m_7918_(x, y, z);
                    double distance = IceFossilFeature.distance(x, y, z, radius, height, radius);
                    float f = noise.GetNoise(x, y, z);
                    if (!(distance < 1.0)) continue;
                    if ((double)f < 0.5) {
                        worldgenlevel.m_7731_(pos, block, 3);
                        continue;
                    }
                    worldgenlevel.m_7731_(pos, block2, 3);
                }
            }
        }
        float randomRot = rand.m_188503_(360);
        entityWorldSpawnable.m_146922_(randomRot);
        entityWorldSpawnable.m_146884_(new Vec3((double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_()));
        worldgenlevel.m_6018_().m_7967_((Entity)entityWorldSpawnable);
    }

    public static double distance(double x, double y, double z, double xRadius, double yRadius, double zRadius) {
        return Mth.m_144952_((double)(x / xRadius)) + Mth.m_144952_((double)(y / yRadius)) + Mth.m_144952_((double)(z / zRadius));
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFrequency(frequency);
        return noise;
    }
}

