/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.util.dino;

import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.common.entity.EntityTyrannosaurusRex;
import com.peeko32213.unusualprehistory.common.entity.IBookEntity;
import com.peeko32213.unusualprehistory.common.entity.IHatchableEntity;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class EntityBaseDinosaurAnimal
extends Animal
implements GeoAnimatable,
IHatchableEntity,
IBookEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> HUNGRY = SynchedEntityData.m_135353_(EntityBaseDinosaurAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIME_TILL_HUNGRY = SynchedEntityData.m_135353_(EntityBaseDinosaurAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(EntityBaseDinosaurAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PASSIVE = SynchedEntityData.m_135353_(EntityBaseDinosaurAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_FROM_EGG = SynchedEntityData.m_135353_(EntityBaseDinosaurAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRADING = SynchedEntityData.m_135353_(EntityBaseDinosaurAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BOOK = SynchedEntityData.m_135353_(EntityBaseDinosaurAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityBaseDinosaurAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean tradingAndGottenItem;
    int lastTimeSinceHungry;
    private int tradingCooldownTimer;
    public final int TRADING_COOLDOWN = 6000;

    protected EntityBaseDinosaurAnimal(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        if (this.hasAvoidEntity()) {
            this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityTyrannosaurusRex.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        }
        if (this.hasTargets()) {
            this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, false, false, entity -> entity.m_6095_().m_204039_(this.getTargetTag())){

                public boolean m_8036_() {
                    return ((EntityBaseDinosaurAnimal)this.f_26135_).isHungry() && super.m_8036_();
                }
            });
        }
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.tradingCooldownTimer > 0) {
            --this.tradingCooldownTimer;
        }
        this.tickHunger();
    }

    public void tickHunger() {
        if (!this.canGetHungry()) {
            return;
        }
        if (!this.isHungry() && this.lastTimeSinceHungry < this.getTimeTillHungry()) {
            ++this.lastTimeSinceHungry;
        }
        if (this.lastTimeSinceHungry >= this.getTimeTillHungry()) {
            this.setHungry(true);
            this.lastTimeSinceHungry = 0;
        }
    }

    public void killed() {
        this.m_5634_(this.getKillHealAmount());
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (prev && this.m_6162_()) {
            return false;
        }
        return prev;
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn) && this.getAttackSound() != null) {
            this.m_5496_(this.getAttackSound(), 0.1f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        int i;
        if (pFallDistance > 1.0f) {
            this.m_5496_(SoundEvents.f_11980_, 0.4f, 1.0f);
        }
        if ((i = this.m_5639_(pFallDistance, pMultiplier)) <= 0) {
            return false;
        }
        this.m_6469_(pSource, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(pSource, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected abstract SoundEvent getAttackSound();

    protected abstract int getKillHealAmount();

    protected abstract boolean canGetHungry();

    protected abstract boolean hasTargets();

    protected abstract boolean hasAvoidEntity();

    protected abstract boolean hasCustomNavigation();

    protected abstract boolean hasMakeStuckInBlock();

    protected abstract boolean customMakeStuckInBlockCheck(BlockState var1);

    protected abstract TagKey<EntityType<?>> getTargetTag();

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HUNGRY, (Object)true);
        this.f_19804_.m_135372_(TIME_TILL_HUNGRY, (Object)0);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(PASSIVE, (Object)0);
        this.f_19804_.m_135372_(IS_FROM_EGG, (Object)false);
        this.f_19804_.m_135372_(TRADING, (Object)false);
        this.f_19804_.m_135372_(FROM_BOOK, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsHungry", this.isHungry());
        compound.m_128405_("TimeTillHungry", this.getTimeTillHungry());
        compound.m_128379_("Saddle", this.isSaddled());
        compound.m_128405_("PassiveTicks", this.getPassiveTicks());
        compound.m_128379_("fromEgg", this.isFromEgg());
        compound.m_128379_("trading", this.isTrading());
        compound.m_128405_("tradingCooldown", this.getTradingCooldownTimer());
        compound.m_128379_("tradingAndGotItem", this.getTradingAndGottenItem());
        compound.m_128405_("variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHungry(compound.m_128471_("IsHungry"));
        this.setTimeTillHungry(compound.m_128451_("TimeTillHungry"));
        this.setSaddled(compound.m_128471_("Saddle"));
        this.setPassiveTicks(compound.m_128451_("PassiveTicks"));
        this.setIsFromEgg(compound.m_128471_("fromEgg"));
        this.setIsTrading(compound.m_128471_("trading"));
        this.setTradingCooldownTimer(compound.m_128451_("tradingCooldown"));
        this.setTradingAndGottenItem(compound.m_128471_("tradingAndGotItem"));
        this.setVariant(compound.m_128451_("variant"));
    }

    public boolean isHungry() {
        return (Boolean)this.f_19804_.m_135370_(HUNGRY);
    }

    public void setHungry(boolean hungry) {
        this.f_19804_.m_135381_(HUNGRY, (Object)hungry);
    }

    public int getTimeTillHungry() {
        return (Integer)this.f_19804_.m_135370_(TIME_TILL_HUNGRY);
    }

    public void setTimeTillHungry(int ticks) {
        this.f_19804_.m_135381_(TIME_TILL_HUNGRY, (Object)ticks);
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public boolean isTrading() {
        return (Boolean)this.f_19804_.m_135370_(TRADING);
    }

    public void setIsTrading(boolean trading) {
        this.f_19804_.m_135381_(TRADING, (Object)trading);
    }

    public int getPassiveTicks() {
        return (Integer)this.f_19804_.m_135370_(PASSIVE);
    }

    public void setPassiveTicks(int passiveTicks) {
        this.f_19804_.m_135381_(PASSIVE, (Object)passiveTicks);
    }

    public boolean isFromEgg() {
        return (Boolean)this.f_19804_.m_135370_(IS_FROM_EGG);
    }

    public void setIsFromEgg(boolean fromEgg) {
        this.f_19804_.m_135381_(IS_FROM_EGG, (Object)fromEgg);
    }

    public boolean isFromBook() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOOK);
    }

    public void setIsFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    @Override
    public void setFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    public boolean m_8023_() {
        return this.isFromEgg();
    }

    public boolean m_6785_(double d) {
        return !this.isFromEgg();
    }

    public void setTradingAndGottenItem(boolean tradingAndGottenItem) {
        this.tradingAndGottenItem = tradingAndGottenItem;
    }

    public boolean getTradingAndGottenItem() {
        return this.tradingAndGottenItem;
    }

    public int getTradingCooldownTimer() {
        return this.tradingCooldownTimer;
    }

    public void setTradingCooldownTimer(int tradingCooldownTimer) {
        this.tradingCooldownTimer = tradingCooldownTimer;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void determineVariant(int variantChange) {
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        spawnGroupData = super.m_6518_(levelAccessor, difficultyInstance, spawnType, spawnGroupData, tag);
        ServerLevel level = levelAccessor.m_6018_();
        this.determineVariant(this.f_19796_.m_188503_(100));
        if (level instanceof ServerLevel) {
            this.m_21530_();
        }
        return spawnGroupData;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    public void m_7601_(BlockState blockstate, Vec3 vec3) {
        if (!this.hasMakeStuckInBlock()) {
            super.m_7601_(blockstate, vec3);
        }
        if (this.customMakeStuckInBlockCheck(blockstate)) {
            super.m_7601_(blockstate, vec3);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        if (this.hasCustomNavigation()) {
            return new DinoCustomNavigation((Mob)this, level);
        }
        return super.m_6037_(level);
    }

    public static boolean checkSurfaceDinoSpawnRules(EntityType<? extends EntityBaseDinosaurAnimal> dino, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource p_186242_) {
        boolean canSpawn = level.m_8055_(pos.m_7495_()).m_204336_(UPTags.DINO_NATURAL_SPAWNABLE) && EntityBaseDinosaurAnimal.m_186209_((BlockAndTintGetter)level, (BlockPos)pos) && (Boolean)UnusualPrehistoryConfig.DINO_NATURAL_SPAWNING.get() != false;
        return canSpawn;
    }

    static class DinoCustomNavigation
    extends GroundPathNavigation {
        public DinoCustomNavigation(Mob p_33379_, Level p_33380_) {
            super(p_33379_, p_33380_);
        }

        protected PathFinder m_5532_(int p_33382_) {
            this.f_26508_ = new CustomNodeEvaluator();
            return new PathFinder(this.f_26508_, p_33382_);
        }
    }

    static class CustomNodeEvaluator
    extends WalkNodeEvaluator {
        CustomNodeEvaluator() {
        }

        protected BlockPathTypes m_264405_(BlockGetter p_33387_, BlockPos p_33390_, BlockPathTypes p_33391_) {
            return p_33391_ == BlockPathTypes.LEAVES ? BlockPathTypes.OPEN : super.m_264405_(p_33387_, p_33390_, p_33391_);
        }
    }
}

