/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.baby;

import com.peeko32213.unusualprehistory.common.entity.msc.baby.EntityBrachiosaurusTeen;
import com.peeko32213.unusualprehistory.common.entity.msc.util.BabyPanicGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.LandCreaturePathNavigation;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityBabyBrachi
extends PathfinderMob
implements GeoAnimatable {
    public static final int MAX_TADPOLE_AGE = Math.abs(-30000);
    public static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42028_, (ItemLike)UPItems.GINKGO_FRUIT.get()});
    private int age;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation BABY_WALK = RawAnimation.begin().thenLoop("animation.babybrachy.walk");
    private static final RawAnimation BABY_IDLE = RawAnimation.begin().thenLoop("animation.babybrachy.idle");
    private static final RawAnimation BABY_SWIM = RawAnimation.begin().thenLoop("animation.babybrachy.swim");

    public EntityBabyBrachi(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected PathNavigation m_6037_(Level level) {
        return new LandCreaturePathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22279_, 0.09);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal(this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.BRACHI_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.BRACHI_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.BRACHI_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.BRACHI_STEP.get(), 0.15f, 1.0f);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.setAge(this.age + 1);
        }
        super.m_8107_();
    }

    public InteractionResult m_6071_(Player p_218703_, InteractionHand p_218704_) {
        ItemStack itemstack = p_218703_.m_21120_(p_218704_);
        if (this.isFood(itemstack)) {
            this.eatFood(p_218703_, itemstack);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    private boolean isFood(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    private void eatFood(Player player, ItemStack stack) {
        this.decrementItem(player, stack);
        this.increaseAge((int)((float)(this.getTicksUntilGrowth() / 20) * 0.1f));
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
    }

    private void decrementItem(Player player, ItemStack stack) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    public void m_7380_(CompoundTag p_218709_) {
        super.m_7380_(p_218709_);
        p_218709_.m_128405_("Age", this.age);
    }

    public void m_7378_(CompoundTag p_218698_) {
        super.m_7378_(p_218698_);
        this.setAge(p_218698_.m_128451_("Age"));
    }

    private void increaseAge(int seconds) {
        this.setAge(this.age + seconds * 20);
    }

    public void setAge(int age) {
        this.age = age;
        if (this.age >= MAX_TADPOLE_AGE) {
            this.growUp();
        }
    }

    private void growUp() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            EntityBrachiosaurusTeen frog = (EntityBrachiosaurusTeen)((EntityType)UPEntities.BRACHI_TEEN.get()).m_20615_(this.m_9236_());
            if (frog == null) {
                return;
            }
            frog.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            frog.m_6518_((ServerLevelAccessor)server, this.m_9236_().m_6436_(frog.m_20183_()), MobSpawnType.CONVERSION, null, null);
            frog.m_21557_(this.m_21525_());
            if (this.m_8077_()) {
                frog.m_6593_(this.m_7770_());
                frog.m_20340_(this.m_20151_());
            }
            frog.m_21530_();
            this.m_5496_(SoundEvents.f_12275_, 0.15f, 1.0f);
            server.m_47205_((Entity)frog);
            this.m_146870_();
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    private int getTicksUntilGrowth() {
        return Math.max(0, MAX_TADPOLE_AGE - this.age);
    }

    public boolean m_6149_() {
        return false;
    }

    protected <E extends EntityBabyBrachi> PlayState Controller(AnimationState<E> event) {
        if (this.m_20069_()) {
            event.setAndContinue(BABY_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.setAndContinue(BABY_WALK);
            event.getController().setAnimationSpeed(1.5);
        } else {
            event.setAndContinue(BABY_IDLE);
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }
}

