/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.entity.EntityMajungasaurus;
import com.peeko32213.unusualprehistory.common.entity.EntityTyrannosaurusRex;
import com.peeko32213.unusualprehistory.common.entity.msc.util.BabyPanicGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.HitboxHelper;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEffects;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntityPachycephalosaurus
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntityPachycephalosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMBAT_STATE = SynchedEntityData.m_135353_(EntityPachycephalosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(EntityPachycephalosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation PACHY_HEADSWING_1 = RawAnimation.begin().thenLoop("animation.pachy.headswing1");
    private static final RawAnimation PACHY_HEADSWING_2 = RawAnimation.begin().thenLoop("animation.pachy.headswing2");
    private static final RawAnimation PACHY_ATTACK = RawAnimation.begin().thenLoop("animation.pachy.attack");
    private static final RawAnimation PACHY_KICK = RawAnimation.begin().thenLoop("animation.pachy.kick");
    private static final RawAnimation PACHY_SWIM = RawAnimation.begin().thenLoop("animation.pachy.swim");
    private static final RawAnimation PACHY_WALK = RawAnimation.begin().thenLoop("animation.pachy.walk");
    private static final RawAnimation PACHY_IDLE = RawAnimation.begin().thenLoop("animation.pachy.idle");

    public EntityPachycephalosaurus(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, 2.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PachyMeleeAttackGoal(this, 1.3f, true));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityMajungasaurus.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityTyrannosaurusRex.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 100, true, false, this::isAngryAt));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.PACHY_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.PACHY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.PACHY_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    @Override
    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean isAngryAt(LivingEntity p_21675_) {
        return this.m_6779_(p_21675_);
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_7306_((Entity)this);
    }

    @Override
    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (prev && this.m_6162_()) {
            return false;
        }
        return prev;
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    public boolean isUlti() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && s.toLowerCase().contains("ulti");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(COMBAT_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public int getCombatState() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_STATE);
    }

    public void setCombatState(int anim) {
        this.f_19804_.m_135381_(COMBAT_STATE, (Object)anim);
    }

    public int getEntityState() {
        return (Integer)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    public void setEntityState(int anim) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)anim);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UPTags.PACHY_FOOD);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (this.m_6898_(itemstack) && (this.getPassiveTicks() <= 0 || this.m_21223_() < this.m_21233_())) {
            if (!this.m_9236_().f_46443_) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(2.0f);
                this.setPassiveTicks(this.getPassiveTicks() + 1500);
                player.m_7292_(new MobEffectInstance((MobEffect)UPEffects.PACHYS_MIGHT.get(), 2400));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)UPEntities.PACHY.get()).m_20615_((Level)serverLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_5448_() != null && this.m_5448_().m_21023_((MobEffect)UPEffects.PACHYS_MIGHT.get())) {
            this.m_6710_(null);
            this.m_6703_(null);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean prev = super.m_6469_(source, amount);
        if (prev) {
            LivingEntity hurter;
            Entity entity;
            if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity && (hurter = (LivingEntity)entity).m_21023_((MobEffect)UPEffects.PACHYS_MIGHT.get())) {
                hurter.m_21195_((MobEffect)UPEffects.PACHYS_MIGHT.get());
            }
            return prev;
        }
        return prev;
    }

    protected <E extends EntityPachycephalosaurus> PlayState Controller(AnimationState<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        int animState = this.getAnimationState();
        switch (animState) {
            case 21: {
                event.setAndContinue(PACHY_HEADSWING_1);
                break;
            }
            case 22: {
                event.setAndContinue(PACHY_HEADSWING_2);
                break;
            }
            case 23: {
                event.setAndContinue(PACHY_ATTACK);
                break;
            }
            case 24: {
                event.setAndContinue(PACHY_KICK);
                break;
            }
            default: {
                if (this.m_20069_()) {
                    event.setAndContinue(PACHY_SWIM);
                    event.getController().setAnimationSpeed(1.0);
                    return PlayState.CONTINUE;
                }
                if (!(event.getLimbSwingAmount() > -0.06f) || !(event.getLimbSwingAmount() < 0.06f) || this.m_20069_()) {
                    event.setAndContinue(PACHY_WALK);
                    return PlayState.CONTINUE;
                }
                if (this.m_20069_()) break;
                event.setAndContinue(PACHY_IDLE);
                event.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    @Override
    public double getTick(Object o) {
        return this.f_19797_;
    }

    static class PachyMeleeAttackGoal
    extends Goal {
        protected final EntityPachycephalosaurus mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;

        public PachyMeleeAttackGoal(EntityPachycephalosaurus p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.m_9236_().m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
            this.mob.m_21561_(false);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            Vec3 aim = this.mob.m_20154_();
            Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
            switch (animState) {
                case 21: {
                    this.tickLightAttack1();
                    break;
                }
                case 22: {
                    this.tickLightAttack2();
                    break;
                }
                case 23: {
                    this.tickStrongHeadbuttAttack();
                    break;
                }
                case 24: {
                    this.tickKickAttack();
                    break;
                }
                default: {
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                int r = this.mob.m_217043_().m_188503_(2048);
                if (r <= 800) {
                    this.mob.setAnimationState(21);
                } else if (r <= 1300) {
                    this.mob.setAnimationState(22);
                } else if (r <= 1850) {
                    this.mob.setAnimationState(23);
                } else {
                    this.mob.setAnimationState(24);
                }
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= (double)1.3f * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickLightAttack1() {
            ++this.animTime;
            if (this.animTime == 4) {
                this.performLightAttack();
            }
            if (this.animTime >= 8) {
                this.animTime = 0;
                if (this.getRangeCheck()) {
                    this.mob.setAnimationState(22);
                } else {
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.ticksUntilNextPathRecalculation = 0;
                }
            }
        }

        protected void tickLightAttack2() {
            ++this.animTime;
            if (this.animTime == 4) {
                this.performLightAttack();
            }
            if (this.animTime >= 7) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickStrongHeadbuttAttack() {
            ++this.animTime;
            if (this.animTime == 8) {
                this.performStrongAttack();
            }
            if (this.animTime >= 14) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickKickAttack() {
            ++this.animTime;
            if (this.animTime == 7) {
                this.performAttackKick();
            }
            if (this.animTime >= 12) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void performLightAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.PACHY_HEADBUTT.get(), 2.0f, 0.2f);
            HitboxHelper.LargeAttackWithTargetCheck(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 8.0f, 0.1f, (PathfinderMob)this.mob, pos, 2.1f, -0.6283185307179586, 1.0471975511965976, -1.0, 3.0);
        }

        protected void performStrongAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.PACHY_HEADBUTT.get(), 0.5f, 0.5f);
            HitboxHelper.LargeAttackWithTargetCheck(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 12.0f, 0.1f, (PathfinderMob)this.mob, pos, 2.1f, -0.6283185307179586, 1.0471975511965976, -1.0, 3.0);
        }

        protected void performAttackKick() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.PACHY_KICK.get(), 0.5f, 0.5f);
            HitboxHelper.LargeAttackWithTargetCheck(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 15.0f, 1.0f, (PathfinderMob)this.mob, pos, 2.1f, -0.6283185307179586, 1.0471975511965976, -1.0, 3.0);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 0;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 3;
        }

        protected double getAttackReachSqr(LivingEntity p_25556_) {
            return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 1.3f + p_25556_.m_20205_();
        }
    }
}

