/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.entity.msc.util.BabyPanicGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntityMajungasaurus
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Integer> CHARGE_COOLDOWN_TICKS = SynchedEntityData.m_135353_(EntityMajungasaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.m_135353_(EntityMajungasaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int stunnedTick;
    private boolean canBePushed = true;
    private static final RawAnimation MAJUNGA_WALK = RawAnimation.begin().thenLoop("animation.majungasaurus.walk");
    private static final RawAnimation MAJUNGA_IDLE = RawAnimation.begin().thenLoop("animation.majungasaurus.idle");
    private static final RawAnimation MAJUNGA_RUN = RawAnimation.begin().thenLoop("animation.majungasaurus.run");
    private static final RawAnimation MAJUNGA_CHARGE_PREP = RawAnimation.begin().thenLoop("animation.majungasaurus.prep");
    private static final RawAnimation MAJUNGA_STUNNED = RawAnimation.begin().thenLoop("animation.majungasaurus.stunned");
    private static final RawAnimation MAJUNGA_SWIM = RawAnimation.begin().thenLoop("animation.majungasaurus.swim");
    private static final RawAnimation MAJUNGA_BITE = RawAnimation.begin().thenLoop("animation.majungasaurus.bite");

    public EntityMajungasaurus(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, 0.6);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MajungaMeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(2, (Goal)new MajungaPrepareChargeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new MajungaChargeGoal(this, 2.5));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34){

            @Override
            public boolean m_8036_() {
                Vec3 vec3d;
                if (this.f_25725_.m_20160_()) {
                    return false;
                }
                if (!this.f_25731_) {
                    if (this.f_25725_.m_21216_() >= 100) {
                        return false;
                    }
                    if (((EntityMajungasaurus)this.f_25725_).isHungry() ? this.f_25725_.m_217043_().m_188503_(60) != 0 : this.f_25725_.m_217043_().m_188503_(30) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.m_7037_()) == null) {
                    return false;
                }
                this.f_25726_ = vec3d.f_82479_;
                this.f_25727_ = vec3d.f_82480_;
                this.f_25728_ = vec3d.f_82481_;
                this.f_25731_ = false;
                return true;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 100, true, false, this::isAngryAt));
    }

    @Override
    public boolean m_7327_(Entity target) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        boolean shouldHurt = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
        if (shouldHurt) {
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, target);
            this.m_21335_(target);
        }
        if (shouldHurt && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            this.m_5496_((SoundEvent)UPSounds.MAJUNGA_ATTACK.get(), 0.1f, 1.0f);
        }
        return shouldHurt;
    }

    public boolean isAngryAt(LivingEntity p_21675_) {
        return this.m_6779_(p_21675_);
    }

    @Override
    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (this.m_6162_() || this.getPassiveTicks() > 0) {
            return false;
        }
        return prev;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)UPEntities.MAJUNGA.get()).m_20615_((Level)serverLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE_COOLDOWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(HAS_TARGET, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("StunTick", this.stunnedTick);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.stunnedTick = compound.m_128451_("StunTick");
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UPTags.MAJUNGA_FOOD);
    }

    private void attack(LivingEntity entity) {
        entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (this.m_6898_(itemstack) && (this.getPassiveTicks() <= 0 || this.m_21223_() < this.m_21233_())) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_5634_(10.0f);
            this.setPassiveTicks(this.getPassiveTicks() + 2500);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.MAJUNGA_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.MAJUNGA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.MAJUNGA_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.MAJUNGA_STEP.get(), 0.1f, 1.0f);
    }

    @Override
    protected SoundEvent getAttackSound() {
        return (SoundEvent)UPSounds.MAJUNGA_ATTACK.get();
    }

    @Override
    protected int getKillHealAmount() {
        return 10;
    }

    @Override
    protected boolean canGetHungry() {
        return true;
    }

    @Override
    protected boolean hasTargets() {
        return true;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return UPTags.MAJUNGA_TARGETS;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return true;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    public void setChargeCooldownTicks(int ticks) {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN_TICKS, (Object)ticks);
    }

    public int getChargeCooldownTicks() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_COOLDOWN_TICKS);
    }

    public boolean hasChargeCooldown() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_COOLDOWN_TICKS) > 0;
    }

    public void resetChargeCooldownTicks() {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN_TICKS, (Object)50);
    }

    public void setHasTarget(boolean hasTarget) {
        this.f_19804_.m_135381_(HAS_TARGET, (Object)hasTarget);
    }

    public boolean hasTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_TARGET);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_6084_()) {
            return;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(this.m_6107_() ? 0.0 : 0.2);
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
            if (this.f_19796_.m_188501_() <= 0.1f && this.f_19796_.m_188501_() < 0.1f) {
                this.m_19998_((ItemLike)UPItems.MAJUNGA_SCUTE.get());
            }
        }
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double e = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double f = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123797_, true, this.m_20185_(), this.m_20188_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.stunnedTick > 0;
    }

    protected void m_6731_(LivingEntity defender) {
        this.stunnedTick = 60;
        this.resetChargeCooldownTicks();
        this.m_21573_().m_26573_();
        this.m_5496_(SoundEvents.f_12362_, 1.0f, 1.0f);
        this.m_9236_().m_7605_((Entity)this, (byte)39);
        defender.m_7334_((Entity)this);
        defender.f_19864_ = true;
    }

    public void m_7822_(byte id) {
        if (id == 39) {
            this.stunnedTick = 60;
        }
        super.m_7822_(id);
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.5);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    private boolean isWithinYRange(LivingEntity target) {
        if (target == null) {
            return false;
        }
        return Math.abs(target.m_20186_() - this.m_20186_()) < 3.0;
    }

    public boolean m_6094_() {
        return this.canBePushed;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 5, this::attackController)});
    }

    protected <E extends EntityMajungasaurus> PlayState Controller(AnimationState<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.setAndContinue(MAJUNGA_SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.stunnedTick > 0) {
            event.setAndContinue(MAJUNGA_STUNNED);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.m_20142_() && !this.m_20069_()) {
                event.setAndContinue(MAJUNGA_RUN);
                event.getController().setAnimationSpeed(3.0);
                return PlayState.CONTINUE;
            }
            event.setAndContinue(MAJUNGA_WALK);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.hasChargeCooldown() && this.hasTarget()) {
            event.setAndContinue(MAJUNGA_CHARGE_PREP);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!this.m_20069_()) {
            event.setAndContinue(MAJUNGA_IDLE);
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    protected <E extends EntityMajungasaurus> PlayState attackController(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.PAUSED)) {
            event.getController().forceAnimationReset();
            event.setAndContinue(MAJUNGA_BITE);
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public double getTick(Object o) {
        return this.f_19797_;
    }

    static class MajungaMeleeAttackGoal
    extends MeleeAttackGoal {
        public MajungaMeleeAttackGoal(PathfinderMob pathfinderMob, double speedModifier, boolean followEvenIfNotSeen) {
            super(pathfinderMob, speedModifier, followEvenIfNotSeen);
        }

        public boolean m_8036_() {
            LivingEntity target = this.f_25540_.m_5448_();
            if (target instanceof Player) {
                return false;
            }
            return super.m_8036_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                ((EntityMajungasaurus)this.f_25540_).setHungry(false);
                ((EntityMajungasaurus)this.f_25540_).attack(enemy);
                ((EntityMajungasaurus)this.f_25540_).setTimeTillHungry(this.f_25540_.m_217043_().m_188503_(300) + 300);
            }
        }

        protected double m_6639_(LivingEntity p_25556_) {
            return this.f_25540_.m_20205_() * 2.0f * this.f_25540_.m_20205_() * 0.9f + p_25556_.m_20205_();
        }
    }

    static class MajungaPrepareChargeGoal
    extends Goal {
        protected final EntityMajungasaurus majunga;

        public MajungaPrepareChargeGoal(EntityMajungasaurus majunga) {
            this.majunga = majunga;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.majunga.m_5448_();
            if (target == null || !target.m_6084_() || this.majunga.stunnedTick > 0 || !this.majunga.isWithinYRange(target)) {
                this.majunga.resetChargeCooldownTicks();
                return false;
            }
            return target instanceof Player && this.majunga.hasChargeCooldown();
        }

        public void m_8056_() {
            LivingEntity target = this.majunga.m_5448_();
            if (target == null) {
                return;
            }
            this.majunga.setHasTarget(true);
            this.majunga.resetChargeCooldownTicks();
            this.majunga.canBePushed = false;
        }

        public void m_8041_() {
            this.majunga.setHasTarget(false);
            this.majunga.canBePushed = true;
        }

        public void m_8037_() {
            LivingEntity target = this.majunga.m_5448_();
            if (target == null) {
                return;
            }
            this.majunga.m_21563_().m_148051_((Entity)target);
            this.majunga.setChargeCooldownTicks(Math.max(0, this.majunga.getChargeCooldownTicks() - 1));
        }
    }

    static class MajungaChargeGoal
    extends Goal {
        protected final EntityMajungasaurus mob;
        private final double speedModifier;
        private Path path;
        private Vec3 chargeDirection;

        public MajungaChargeGoal(EntityMajungasaurus pathfinderMob, double speedModifier) {
            this.mob = pathfinderMob;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.chargeDirection = Vec3.f_82478_;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_() || this.mob.hasChargeCooldown() || this.mob.stunnedTick > 0) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
            return target instanceof Player && this.path != null;
        }

        public boolean m_8045_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_() || this.mob.hasChargeCooldown() || this.mob.stunnedTick > 0) {
                return false;
            }
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            BlockPos blockPosition = this.mob.m_20183_();
            BlockPos target = this.path.m_77406_();
            this.chargeDirection = new Vec3((double)(blockPosition.m_123341_() - target.m_123341_()), 0.0, (double)(blockPosition.m_123343_() - target.m_123343_())).m_82541_();
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            this.mob.resetChargeCooldownTicks();
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.mob.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.path.m_77406_()));
            if (this.mob.f_19862_ && this.mob.m_20096_()) {
                this.mob.m_6135_();
            }
            if (this.mob.m_9236_().m_46467_() % 2L == 0L) {
                this.mob.m_5496_((SoundEvent)UPSounds.MAJUNGA_STEP.get(), 0.5f, this.mob.m_6100_());
            }
            this.tryToHurt();
        }

        protected void tryToHurt() {
            LivingEntity livingEntity;
            List nearbyEntities = this.mob.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this.mob, this.mob.m_20191_());
            if (!nearbyEntities.isEmpty() && !((livingEntity = (LivingEntity)nearbyEntities.get(0)) instanceof EntityMajungasaurus)) {
                livingEntity.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
                float speed = Mth.m_14036_((float)(this.mob.m_6113_() * 1.65f), (float)0.2f, (float)3.0f);
                float shieldBlockModifier = livingEntity.m_21275_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob)) ? 0.5f : 1.0f;
                livingEntity.m_147240_((double)(shieldBlockModifier * speed) * 2.0, this.chargeDirection.m_7096_(), this.chargeDirection.m_7094_());
                double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(0.0, (double)0.4f * knockbackResistance, 0.0));
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                if (livingEntity.equals((Object)this.mob.m_5448_())) {
                    this.m_8041_();
                }
            }
        }
    }
}

