/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.block;

import com.peeko32213.unusualprehistory.common.entity.IHatchableEntity;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockDinosaurWaterEggs
extends Block {
    public static final Logger LOGGER = LogManager.getLogger();
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
    private Supplier<? extends EntityType> dinosaur;
    private boolean properHabitat;
    private static int hatchTimeMax;
    private static int hatchTimeMin;

    public BlockDinosaurWaterEggs(BlockBehaviour.Properties properties, Supplier<? extends EntityType> dinosaur, boolean placableOnLand) {
        this(properties, dinosaur, placableOnLand, 1200, 3600);
    }

    public BlockDinosaurWaterEggs(BlockBehaviour.Properties properties, Supplier<? extends EntityType> dinosaur, boolean placableOnLand, int hatchTimeMin, int hatchTimeMax) {
        super(properties);
        this.dinosaur = dinosaur;
        this.properHabitat = placableOnLand;
        if (hatchTimeMin > hatchTimeMax) {
            try {
                LOGGER.debug("Min higher than Max, for block with entity {}", (Object)dinosaur.get());
                throw new Exception("Something went wrong setting creating block");
            }
            catch (Exception e) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)e, (String)"Something went wrong setting creating block");
                crashreport.m_127514_("Min higher than Max");
                throw new ReportedException(crashreport);
            }
        }
        BlockDinosaurWaterEggs.hatchTimeMax = hatchTimeMax;
        BlockDinosaurWaterEggs.hatchTimeMin = hatchTimeMin;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        if (this.properHabitat) {
            return BlockDinosaurWaterEggs.isProperHabitat((BlockGetter)reader, pos.m_7495_());
        }
        return BlockDinosaurWaterEggs.mayPlaceOn(reader, pos.m_7495_());
    }

    public void m_6807_(BlockState p_221227_, Level p_221228_, BlockPos p_221229_, BlockState p_221230_, boolean p_221231_) {
        p_221228_.m_186460_(p_221229_, (Block)this, BlockDinosaurWaterEggs.getSpawnHatchDelay(p_221228_.m_213780_()));
    }

    public static boolean isProperHabitat(BlockGetter reader, BlockPos pos) {
        return reader.m_8055_(pos).m_204336_(UPTags.DINO_HATCHABLE_BLOCKS);
    }

    private static int getSpawnHatchDelay(RandomSource randomSource) {
        return randomSource.m_216339_(hatchTimeMin, hatchTimeMax);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor access, BlockPos pos, BlockPos neighborPos) {
        return !this.m_7898_(state, (LevelReader)access, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, access, pos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            this.hatch((Level)level, pos);
        } else {
            this.onHatch(level, pos, random);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_6095_().equals(EntityType.f_20450_)) {
            this.hatch(level, pos);
        }
    }

    private static boolean mayPlaceOn(LevelReader reader, BlockPos pos) {
        FluidState fluidState = reader.m_6425_(pos);
        FluidState topFluidState = reader.m_6425_(pos.m_7494_());
        return fluidState.m_76152_() == Fluids.f_76193_ && topFluidState.m_76152_() == Fluids.f_76191_;
    }

    private void onHatch(ServerLevel level, BlockPos pos, RandomSource random) {
        this.hatch((Level)level, pos);
        level.m_5594_(null, pos, SoundEvents.f_12535_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.createDinosaur(level, pos, random);
    }

    private void hatch(Level level, BlockPos blockPos) {
        level.m_46961_(blockPos, false);
    }

    private void createDinosaur(ServerLevel level, BlockPos pos, RandomSource random) {
        int i = random.m_216339_(1, 2);
        for (int index = 1; index <= i; ++index) {
            Mob entityToSpawn = (Mob)this.dinosaur.get().m_20615_((Level)level);
            if (entityToSpawn instanceof IHatchableEntity) {
                IHatchableEntity hatchableEntity = (IHatchableEntity)entityToSpawn;
                hatchableEntity.determineVariant(random.m_188503_(100));
            }
            if (entityToSpawn instanceof Animal) {
                Animal animal = (Animal)entityToSpawn;
                animal.m_146762_(-24000);
                animal.m_21446_(pos, 20);
            }
            if (entityToSpawn == null) continue;
            double x = (double)pos.m_123341_() + this.getSpawnOffset(random);
            double z = (double)pos.m_123343_() + this.getSpawnOffset(random);
            int yaw = random.m_216339_(1, 361);
            entityToSpawn.m_7678_(x, (double)pos.m_123342_() - 0.5, z, (float)yaw, 0.0f);
            entityToSpawn.m_21530_();
            level.m_7967_((Entity)entityToSpawn);
        }
    }

    private double getSpawnOffset(RandomSource random) {
        return Mth.m_14008_((double)random.m_188500_(), (double)0.2f, (double)0.8f);
    }
}

