/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.forge.common.entity;

import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.forge.common.inventory.ForgeSaddleBagMenu;
import net.chococraft.forge.common.inventory.SaddleItemStackHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeChocobo
extends AbstractChocobo {
    public final ItemStackHandler inventory = new ItemStackHandler(45){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (ForgeChocobo.this.getSaddle().m_41619_()) {
                return false;
            }
            Item item = ForgeChocobo.this.getSaddle().m_41720_();
            if (item instanceof ChocoboSaddleItem) {
                ChocoboSaddleItem saddleItem = (ChocoboSaddleItem)item;
                switch (saddleItem.getInventorySize()) {
                    case 18: {
                        return (slot > 10 && slot < 16 || slot > 19 && slot < 25 || slot > 28 && slot < 34) && super.isItemValid(slot, stack);
                    }
                    case 45: {
                        return super.isItemValid(slot, stack);
                    }
                }
                return false;
            }
            return super.isItemValid(slot, stack);
        }
    };
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);
    public final SaddleItemStackHandler saddleItemStackHandler = new SaddleItemStackHandler(){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41619_() || stack.m_41720_() instanceof ChocoboSaddleItem;
        }

        @Override
        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            ForgeChocobo.this.setSaddleType(stack);
            super.setStackInSlot(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            ForgeChocobo.this.setSaddleType(this.getStackInSlot(slot));
            super.onContentsChanged(slot);
        }
    };
    private final LazyOptional<IItemHandler> saddleHolder = LazyOptional.of(() -> this.saddleItemStackHandler);

    public ForgeChocobo(EntityType<? extends AbstractChocobo> type, Level world) {
        super(type, world);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Saddle", (Tag)this.saddleItemStackHandler.serializeNBT());
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @Override
    protected void setSaddled(Player player, InteractionHand hand, ItemStack heldItemStack) {
        if (!this.m_9236_().f_46443_) {
            this.saddleItemStackHandler.setStackInSlot(0, heldItemStack.m_41720_().m_7968_());
            this.setSaddleType(heldItemStack);
            this.m_142075_(player, hand, heldItemStack);
        }
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            serverPlayer.m_9217_();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((ix, playerInventory, playerEntityx) -> new ForgeSaddleBagMenu(ix, playerInventory, this), this.m_5446_()), buf -> buf.m_130077_(this.m_20148_()));
        }
    }

    @Override
    protected void reconfigureInventory(ItemStack oldSaddle, ItemStack newSaddle) {
        if (!this.m_20193_().f_46443_) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (!this.m_6084_()) continue;
                ItemStack stack = this.inventory.extractItem(i, Integer.MAX_VALUE, false);
                Containers.m_18992_((Level)this.m_20193_(), (double)this.m_20185_(), (double)(this.m_20186_() + 0.5), (double)this.m_20189_(), (ItemStack)stack);
            }
        }
        for (Player player : this.m_9236_().m_6907_()) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (!(abstractContainerMenu instanceof ForgeSaddleBagMenu)) continue;
            ForgeSaddleBagMenu bagContainer = (ForgeSaddleBagMenu)abstractContainerMenu;
            bagContainer.refreshSlots(bagContainer.getChocobo(), player.m_150109_());
        }
    }

    @Override
    protected void dropInventory() {
        if (this.inventory != null && this.isSaddled()) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).m_41619_()) continue;
                this.m_5552_(this.inventory.getStackInSlot(i), 0.0f);
            }
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.saddleItemStackHandler.deserializeNBT(compound.m_128469_("Saddle"));
        this.setSaddleType(this.saddleItemStackHandler.getStackInSlot(0));
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public float getStepHeight() {
        return this.getAbilityInfo().getStepHeight(this.m_20160_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.inventoryHolder.cast();
            }
            return this.saddleHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
        this.saddleHolder.invalidate();
    }
}

