/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.forge;

import com.google.gson.internal.LinkedTreeMap;
import java.nio.file.Path;
import java.util.List;
import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.chococraft.common.entity.properties.MovementType;
import net.chococraft.common.inventory.SaddleBagMenu;
import net.chococraft.common.items.armor.AbstractChocoDisguiseItem;
import net.chococraft.forge.common.config.BreedingConfig;
import net.chococraft.forge.common.config.ForgeChocoConfig;
import net.chococraft.forge.common.entity.ForgeChocobo;
import net.chococraft.forge.common.inventory.ForgeSaddleBagMenu;
import net.chococraft.forge.common.items.ForgeChocoDisguiseItem;
import net.chococraft.forge.registry.ModDataSerializers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class ChococraftExpectPlatformImpl {
    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static boolean isModLoaded(String modID) {
        return ModList.get().isLoaded(modID);
    }

    public static EntityType.Builder<? extends AbstractChocobo> constructChocoboEntityType() {
        return EntityType.Builder.m_20704_(ForgeChocobo::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.2f, 2.8f).m_20702_(64);
    }

    public static SaddleBagMenu constructMenu(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        return ForgeSaddleBagMenu.create(i, inventory, friendlyByteBuf);
    }

    public static SaddleBagMenu constructMenu(int i, Inventory inventory, AbstractChocobo abstractChocobo) {
        return new ForgeSaddleBagMenu(i, inventory, (ForgeChocobo)abstractChocobo);
    }

    public static AbstractChocoDisguiseItem constructChocoDisguise(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        return new ForgeChocoDisguiseItem(material, type, properties);
    }

    public static LinkedTreeMap<String, LinkedTreeMap<String, List<LinkedTreeMap<String, String>>>> getBreedingInfoMap() {
        return BreedingConfig.breedingInfoHashmap;
    }

    public static float getTameChance() {
        return ((Double)ForgeChocoConfig.COMMON.tameChance.get()).floatValue();
    }

    public static boolean canChocobosFly() {
        return (Boolean)ForgeChocoConfig.COMMON.canChocobosFly.get();
    }

    public static int kwehIntervalLimit() {
        return (Integer)ForgeChocoConfig.COMMON.kwehIntervalLimit.get();
    }

    public static boolean nameTamedChocobos() {
        return (Boolean)ForgeChocoConfig.COMMON.nameTamedChocobos.get();
    }

    public static List<? extends String> getConfiguredMaleNames() {
        return (List)ForgeChocoConfig.COMMON.maleNames.get();
    }

    public static List<? extends String> getConfiguredFemaleNames() {
        return (List)ForgeChocoConfig.COMMON.femaleNames.get();
    }

    public static EntityDataSerializer<ChocoboColor> getColorSerializer() {
        return (EntityDataSerializer)ModDataSerializers.CHOCOBO_COLOR.get();
    }

    public static EntityDataSerializer<MovementType> getMovementSerializer() {
        return (EntityDataSerializer)ModDataSerializers.MOVEMENT_TYPE.get();
    }
}

