/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entity;

import net.chococraft.ChococraftExpectPlatform;
import net.chococraft.common.entity.DefaultNames;
import net.chococraft.common.entity.breeding.BreedingHelper;
import net.chococraft.common.entity.breeding.ChocoboAbilityInfo;
import net.chococraft.common.entity.goal.ChocoboFollowOwnerGoal;
import net.chococraft.common.entity.goal.ChocoboHealInPenGoal;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.chococraft.common.entity.properties.MovementType;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.common.items.armor.AbstractChocoDisguiseItem;
import net.chococraft.registry.ModEntities;
import net.chococraft.registry.ModRegistry;
import net.chococraft.registry.ModSounds;
import net.chococraft.utils.RandomHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChocobo
extends TamableAnimal
implements HasCustomInventoryScreen {
    private static final String NBTKEY_CHOCOBO_COLOR = "Color";
    private static final String NBTKEY_CHOCOBO_IS_MALE = "Male";
    private static final String NBTKEY_MOVEMENTTYPE = "MovementType";
    protected static final String NBTKEY_SADDLE_ITEM = "Saddle";
    protected static final String NBTKEY_INVENTORY = "Inventory";
    private static final String NBTKEY_CHOCOBO_GENERATION = "Generation";
    private static final String NBTKEY_ALLOWED_FLIGHT = "AllowedFlight";
    private static final EntityDataAccessor<ChocoboColor> PARAM_COLOR = SynchedEntityData.m_135353_(AbstractChocobo.class, ChococraftExpectPlatform.getColorSerializer());
    private static final EntityDataAccessor<Boolean> PARAM_IS_MALE = SynchedEntityData.m_135353_(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PARAM_FED_GOLD_GYSAHL = SynchedEntityData.m_135353_(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<MovementType> PARAM_MOVEMENT_TYPE = SynchedEntityData.m_135353_(AbstractChocobo.class, ChococraftExpectPlatform.getMovementSerializer());
    private static final EntityDataAccessor<ItemStack> PARAM_SADDLE_ITEM = SynchedEntityData.m_135353_(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> ALLOWED_FLIGHT = SynchedEntityData.m_135353_(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PARAM_GENERATION = SynchedEntityData.m_135353_(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AvoidEntityGoal<Player> chocoboAvoidPlayerGoal;
    private ChocoboHealInPenGoal healInPenGoal;
    private float wingRotation;
    private float destPos;
    private float wingRotDelta;
    public int timeSinceFeatherChance = 0;
    private final ChocoboFollowOwnerGoal follow = new ChocoboFollowOwnerGoal(this, 2.0, 3.0f, 10.0f);

    public AbstractChocobo(EntityType<? extends AbstractChocobo> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new ChocoboFollowOwnerGoal(this, 1.0, 5.0f, 5.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22280_, 0.0).m_22268_(Attributes.f_22276_, 30.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARAM_COLOR, (Object)ChocoboColor.YELLOW);
        this.f_19804_.m_135372_(PARAM_IS_MALE, (Object)false);
        this.f_19804_.m_135372_(PARAM_FED_GOLD_GYSAHL, (Object)false);
        this.f_19804_.m_135372_(PARAM_MOVEMENT_TYPE, (Object)MovementType.WANDER);
        this.f_19804_.m_135372_(PARAM_SADDLE_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(PARAM_GENERATION, (Object)0);
        this.f_19804_.m_135372_(ALLOWED_FLIGHT, (Object)true);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (levelAccessor.m_204166_(new BlockPos((Vec3i)this.m_20183_().m_7495_())).m_203656_(BiomeTags.f_207612_)) {
            this.setChocoboColor(ChocoboColor.FLAME);
        }
        this.finalizeChocobo(this);
        return super.m_6518_(levelAccessor, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void finalizeChocobo(AbstractChocobo chocobo) {
        chocobo.setMale(this.f_19796_.m_188499_());
        chocobo.m_21051_(Attributes.f_22276_).m_22100_((double)this.getChocoboColor().getAbilityInfo().getMaxHP());
        chocobo.m_21153_(this.m_21233_());
        chocobo.m_21051_(Attributes.f_22279_).m_22100_((double)(this.getChocoboColor().getAbilityInfo().getLandSpeed() / 100.0f));
        chocobo.m_21051_(Attributes.f_22280_).m_22100_((double)(this.getChocoboColor().getAbilityInfo().getAirbornSpeed() / 100.0f));
        chocobo.setAllowedFlight(ChococraftExpectPlatform.canChocobosFly());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setChocoboColor(ChocoboColor.values()[compound.m_128445_(NBTKEY_CHOCOBO_COLOR)]);
        this.setMale(compound.m_128471_(NBTKEY_CHOCOBO_IS_MALE));
        this.setMovementType(MovementType.values()[compound.m_128445_(NBTKEY_MOVEMENTTYPE)]);
        this.setGeneration(compound.m_128451_(NBTKEY_CHOCOBO_GENERATION));
        if (compound.m_128425_("wornSaddle", 10)) {
            this.setSaddleType(ItemStack.m_41712_((CompoundTag)compound.m_128469_("wornSaddle")));
        }
        this.setAllowedFlight(compound.m_128471_(NBTKEY_ALLOWED_FLIGHT));
        this.m_5849_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_(NBTKEY_CHOCOBO_COLOR, (byte)this.getChocoboColor().ordinal());
        compound.m_128379_(NBTKEY_CHOCOBO_IS_MALE, this.isMale());
        compound.m_128344_(NBTKEY_MOVEMENTTYPE, (byte)this.getMovementType().ordinal());
        compound.m_128405_(NBTKEY_CHOCOBO_GENERATION, this.getGeneration());
        if (!this.getSaddle().m_41619_()) {
            compound.m_128365_("wornSaddle", (Tag)this.getSaddle().m_41739_(new CompoundTag()));
        }
        compound.m_128379_(NBTKEY_ALLOWED_FLIGHT, this.allowedFlight());
    }

    public ChocoboColor getChocoboColor() {
        return (ChocoboColor)((Object)this.f_19804_.m_135370_(PARAM_COLOR));
    }

    public void setChocoboColor(ChocoboColor color) {
        this.f_19804_.m_135381_(PARAM_COLOR, (Object)color);
    }

    public boolean m_5825_() {
        return this.getChocoboColor().getAbilityInfo().isImmuneToFire();
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(PARAM_IS_MALE);
    }

    public void setMale(boolean isMale) {
        this.f_19804_.m_135381_(PARAM_IS_MALE, (Object)isMale);
    }

    public boolean isFedGoldGysahl() {
        return (Boolean)this.f_19804_.m_135370_(PARAM_FED_GOLD_GYSAHL);
    }

    public void setFedGoldGysahl(boolean value) {
        this.f_19804_.m_135381_(PARAM_FED_GOLD_GYSAHL, (Object)value);
    }

    public MovementType getMovementType() {
        return (MovementType)((Object)this.f_19804_.m_135370_(PARAM_MOVEMENT_TYPE));
    }

    public void setMovementType(MovementType type) {
        this.f_19804_.m_135381_(PARAM_MOVEMENT_TYPE, (Object)type);
    }

    public boolean isSaddled() {
        return !this.getSaddle().m_41619_();
    }

    public ItemStack getSaddle() {
        return (ItemStack)this.f_19804_.m_135370_(PARAM_SADDLE_ITEM);
    }

    protected void setSaddleType(ItemStack saddleStack) {
        ItemStack newStack = saddleStack;
        ItemStack oldStack = this.getSaddle();
        if (oldStack.m_41720_() != newStack.m_41720_()) {
            this.f_19804_.m_135381_(PARAM_SADDLE_ITEM, (Object)newStack.m_41777_());
            this.reconfigureInventory(oldStack, newStack);
        }
    }

    public int getGeneration() {
        return (Integer)this.f_19804_.m_135370_(PARAM_GENERATION);
    }

    public void setGeneration(int value) {
        this.f_19804_.m_135381_(PARAM_GENERATION, (Object)value);
    }

    public boolean allowedFlight() {
        return (Boolean)this.f_19804_.m_135370_(ALLOWED_FLIGHT);
    }

    public void setAllowedFlight(boolean value) {
        this.f_19804_.m_135381_(ALLOWED_FLIGHT, (Object)value);
    }

    public double m_6048_() {
        return 1.65;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return this.canBeControlledBy(livingEntity) ? livingEntity : null;
        }
        return null;
    }

    private boolean canBeControlledBy(LivingEntity entity) {
        return this.m_21824_() && this.isSaddled();
    }

    protected boolean m_20073_() {
        return super.m_20073_();
    }

    public boolean m_203441_(FluidState fluidState) {
        boolean flag = this.m_6688_() != null && this.m_6688_().f_20899_;
        return fluidState.m_205070_(FluidTags.f_13131_) && this.getAbilityInfo().canWalkOnWater() && !flag;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.m_6688_();
            if (this.m_20160_() && livingentity != null) {
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float strafe = livingentity.f_20900_ * 0.5f;
                float forward = livingentity.f_20902_;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (livingentity.f_20899_ && this.getAbilityInfo().getCanFly() && this.allowedFlight()) {
                    this.m_6862_(true);
                    this.m_6135_();
                    this.f_19812_ = true;
                    this.m_19920_(this.getChocoboColor().getAbilityInfo().getAirbornSpeed() / 100.0f, travelVector);
                } else if (livingentity.f_20899_ && !this.f_20899_) {
                    if (this.m_20069_()) {
                        if (this.getAbilityInfo().canWalkOnWater()) {
                            if (this.m_5842_()) {
                                this.m_203347_(FluidTags.f_13131_);
                            }
                        } else {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(0.01f + this.f_19796_.m_188501_() * 0.09f), 0.0));
                        }
                    } else if (this.m_20069_() && this.getAbilityInfo().canWalkOnWater()) {
                        this.m_21208_();
                    } else if (this.m_20096_()) {
                        this.m_6135_();
                        livingentity.m_6862_(false);
                        this.m_6862_(true);
                    }
                }
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)strafe, travelVector.f_82480_, (double)forward));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.m_20096_()) {
                    this.m_6862_(false);
                }
                this.m_267651_(false);
                this.m_146872_();
            } else {
                super.m_7023_(travelVector);
            }
        }
    }

    protected ChocoboAbilityInfo getAbilityInfo() {
        return this.getChocoboColor().getAbilityInfo();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        super.m_19956_(passenger, moveFunction);
        if (passenger instanceof Mob && this.m_6688_() == passenger) {
            this.f_20883_ = ((LivingEntity)passenger).f_20883_;
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob partner) {
        AbstractChocobo babyChocobo = (AbstractChocobo)((EntityType)ModEntities.CHOCOBO.get()).m_20615_((Level)level);
        babyChocobo.setChocoboColor(BreedingHelper.getColor(this, (AbstractChocobo)partner));
        this.finalizeChocobo(babyChocobo);
        this.setFedGoldGysahl(false);
        ((AbstractChocobo)partner).setFedGoldGysahl(false);
        return babyChocobo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_27563_(ServerLevel level, Animal partner) {
        if (partner instanceof AbstractChocobo) {
            AbstractChocobo target = (AbstractChocobo)partner;
            if (this.getChocoboColor() == ChocoboColor.PURPLE && target.getChocoboColor() == ChocoboColor.PURPLE) {
                this.m_5552_(new ItemStack((ItemLike)ModRegistry.PURPLE_CHOCOBO_SPAWN_EGG.get()), 0.0f);
                this.m_146762_(6000);
                target.m_146762_(6000);
                this.m_27594_();
                target.m_27594_();
                return;
            }
        }
        super.m_27563_(level, partner);
    }

    public boolean m_7848_(Animal parent) {
        if (parent == this || !(parent instanceof AbstractChocobo)) {
            return false;
        }
        AbstractChocobo otherChocobo = (AbstractChocobo)parent;
        if (!this.m_27593_() || !parent.m_27593_()) {
            return false;
        }
        return otherChocobo.isMale() != this.isMale();
    }

    public void dropFeather() {
        if (this.m_20193_().f_46443_) {
            return;
        }
        if (this.m_6162_()) {
            return;
        }
        this.m_5552_(new ItemStack((ItemLike)ModRegistry.CHOCOBO_FEATHER.get(), 1), 0.0f);
    }

    protected boolean m_7341_(Entity entityIn) {
        return !this.getSaddle().m_41619_() && super.m_7341_(entityIn);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.m_183634_();
        if (this.timeSinceFeatherChance == 3000) {
            this.timeSinceFeatherChance = 0;
            if ((double)((float)Math.random()) < 0.25) {
                this.dropFeather();
            }
        } else {
            ++this.timeSinceFeatherChance;
        }
        if (!this.m_9236_().f_46443_ && this.m_20159_() && this.m_20160_()) {
            this.m_8127_();
        }
        if (this.m_20193_().f_46443_) {
            this.destPos += (float)((double)(this.m_20096_() ? -1 : 4) * 0.3);
            this.destPos = Mth.m_14036_((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.m_20096_()) {
                this.wingRotDelta = Math.min(this.wingRotation, 1.0f);
            }
            this.wingRotDelta *= 0.9f;
            this.wingRotation += this.wingRotDelta * 2.0f;
            if (this.m_20096_()) {
                this.m_267651_(false);
            } else {
                this.f_267362_.m_267590_(0.0f);
                this.f_267362_.m_267771_(0.0f);
            }
        }
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (this.m_20160_() && (entity = this.m_146895_()) instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)entity;
            this.getAbilityInfo().getRiderAbilities().forEach(ability -> {
                passenger.m_7292_((MobEffectInstance)ability.get());
                this.m_7292_((MobEffectInstance)ability.get());
            });
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_((Item)ModRegistry.LOVERLY_GYSAHL_GREEN.get()) || stack.m_150930_((Item)ModRegistry.GOLD_GYSAHL.get()) || stack.m_150930_((Item)ModRegistry.GYSAHL_CAKE.get());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItemStack = player.m_21120_(hand);
        if (this.m_6898_(heldItemStack)) {
            boolean fedCake;
            boolean bl = fedCake = heldItemStack.m_41720_() == ModRegistry.GYSAHL_CAKE.get();
            if (this.m_6162_()) {
                if (fedCake) {
                    this.m_142075_(player, hand, heldItemStack);
                    this.m_6863_(false);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            } else {
                int i = this.m_146764_();
                if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_() && !fedCake) {
                    if (heldItemStack.m_41720_() == ModRegistry.GOLD_GYSAHL.get()) {
                        this.setFedGoldGysahl(true);
                    }
                    this.m_142075_(player, hand, heldItemStack);
                    this.m_27595_(player);
                    return InteractionResult.SUCCESS;
                }
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        if (this.m_9236_().f_46443_) {
            return InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.isSaddled() && !this.m_20160_() && player.m_21205_().m_41619_() && !player.m_6144_() && !this.m_6162_()) {
                player.m_20329_((Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && !this.m_6162_() && player.m_21205_().m_41619_()) {
                this.m_213583_((Player)((ServerPlayer)player));
                return InteractionResult.SUCCESS;
            }
            if (heldItemStack.m_150930_((Item)ModRegistry.CHOCOBO_WHISTLE.get()) && !this.m_6162_()) {
                if (this.m_21830_((LivingEntity)player)) {
                    if (this.getMovementType() == MovementType.STANDSTILL) {
                        this.m_5496_((SoundEvent)ModSounds.WHISTLE_SOUND_FOLLOW.get(), 1.0f, 1.0f);
                        this.m_21557_(false);
                        this.f_21345_.m_25352_(0, (Goal)this.follow);
                        this.setMovementType(MovementType.FOLLOW_OWNER);
                        player.m_5661_((Component)Component.m_237115_((String)"chococraft.entity_chocobo.chocobo_followcmd"), true);
                    } else if (this.getMovementType() == MovementType.FOLLOW_OWNER) {
                        this.m_5496_((SoundEvent)ModSounds.WHISTLE_SOUND_WANDER.get(), 1.0f, 1.0f);
                        this.f_21345_.m_25363_((Goal)this.follow);
                        this.setMovementType(MovementType.WANDER);
                        player.m_5661_((Component)Component.m_237115_((String)"chococraft.entity_chocobo.chocobo_wandercmd"), true);
                    } else if (this.getMovementType() == MovementType.WANDER) {
                        this.m_5496_((SoundEvent)ModSounds.WHISTLE_SOUND_STAY.get(), 1.0f, 1.0f);
                        this.m_21557_(true);
                        this.setMovementType(MovementType.STANDSTILL);
                        player.m_5661_((Component)Component.m_237115_((String)"chococraft.entity_chocobo.chocobo_staycmd"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"chococraft.entity_chocobo.not_owner"), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (heldItemStack.m_150930_((Item)ModRegistry.GYSAHL_GREEN_ITEM.get())) {
                if (this.m_21223_() != this.m_21233_()) {
                    this.m_142075_(player, hand, heldItemStack);
                    this.m_5634_(5.0f);
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)Component.m_237115_((String)"chococraft.entity_chocobo.heal_fail"), true);
                return InteractionResult.PASS;
            }
            if (this.getChocoboColor() == ChocoboColor.GOLD) {
                if (heldItemStack.m_41720_() == ModRegistry.RED_GYSAHL.get()) {
                    this.m_142075_(player, hand, heldItemStack);
                    this.setChocoboColor(ChocoboColor.RED);
                    return InteractionResult.SUCCESS;
                }
                if (heldItemStack.m_41720_() == ModRegistry.PINK_GYSAHL.get()) {
                    this.m_142075_(player, hand, heldItemStack);
                    this.setChocoboColor(ChocoboColor.PINK);
                    return InteractionResult.SUCCESS;
                }
            }
            if (heldItemStack.m_41720_() instanceof ChocoboSaddleItem && !this.isSaddled() && !this.m_6162_()) {
                this.setSaddled(player, hand, new ItemStack((ItemLike)heldItemStack.m_41720_()));
                if (!player.m_150110_().f_35937_) {
                    heldItemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (heldItemStack.m_150930_((Item)ModRegistry.GYSAHL_GREEN_ITEM.get())) {
            this.m_142075_(player, hand, heldItemStack);
            if ((float)Math.random() < ChococraftExpectPlatform.getTameChance()) {
                this.m_21816_(player.m_20148_());
                this.m_7105_(true);
                if (ChococraftExpectPlatform.nameTamedChocobos() && !this.m_8077_()) {
                    this.m_6593_((Component)DefaultNames.getRandomName(this.f_19796_, this.isMale()));
                }
                player.m_5661_((Component)Component.m_237115_((String)"chococraft.entity_chocobo.tame_success"), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"chococraft.entity_chocobo.tame_fail"), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected abstract void setSaddled(Player var1, InteractionHand var2, ItemStack var3);

    protected abstract void reconfigureInventory(ItemStack var1, ItemStack var2);

    protected void m_7625_(DamageSource damageSourceIn, boolean attackedRecently) {
        super.m_7625_(damageSourceIn, attackedRecently);
        this.dropInventory();
    }

    protected abstract void dropInventory();

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected float m_6121_() {
        return 0.6f;
    }

    public int m_8100_() {
        return 24 * (int)(Math.random() * (double)ChococraftExpectPlatform.kwehIntervalLimit());
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        if (this.m_9236_().m_204166_(new BlockPos((Vec3i)this.m_20183_())).m_203656_(BiomeTags.f_207612_)) {
            return 0.0f;
        }
        return super.m_5610_(pos, levelReader);
    }

    protected void m_5849_() {
        super.m_5849_();
        if (this.chocoboAvoidPlayerGoal == null) {
            this.chocoboAvoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 10.0f, 1.0, 1.2, livingEntity -> {
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    int chance = 0;
                    for (ItemStack stack : player.m_150109_().f_35975_) {
                        if (stack == null || !(stack.m_41720_() instanceof AbstractChocoDisguiseItem)) continue;
                        chance += 25;
                    }
                    return !RandomHelper.getChanceResult(this.m_217043_(), chance);
                }
                return false;
            });
        }
        if (this.healInPenGoal == null) {
            this.healInPenGoal = new ChocoboHealInPenGoal(this);
        }
        this.f_21345_.m_25363_(this.chocoboAvoidPlayerGoal);
        this.f_21345_.m_25363_((Goal)this.healInPenGoal);
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(4, (Goal)this.healInPenGoal);
        } else {
            this.f_21345_.m_25352_(5, this.chocoboAvoidPlayerGoal);
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.m_6162_()) {
            return super.m_6972_(pose).m_20388_(0.5f);
        }
        return super.m_6972_(pose);
    }

    public static boolean checkChocoboSpawnRules(EntityType<? extends AbstractChocobo> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        if (levelAccessor.m_204166_(new BlockPos((Vec3i)pos)).m_203656_(BiomeTags.f_207612_)) {
            BlockPos blockpos = pos.m_7495_();
            return spawnType == MobSpawnType.SPAWNER || levelAccessor.m_8055_(blockpos).m_60643_((BlockGetter)levelAccessor, blockpos, entityType);
        }
        return levelAccessor.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && AbstractChocobo.m_186209_((BlockAndTintGetter)levelAccessor, (BlockPos)pos);
    }
}

