/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ChocoboBookScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("chococraft", "textures/gui/chocobo_book.png");
    private final Component bookTitle = Component.m_237113_((String)"The Chocopedia").m_130940_(ChatFormatting.GOLD);
    private final Component bookAuthor = Component.m_237113_((String)"by Clienthax");
    private final int xSize = 192;
    private final int ySize = 192;
    private int currentPage = 0;
    private final int pageCount;
    private int guiLeft;
    private int guiTop;
    private Component pageMsg = CommonComponents.f_237098_;

    public ChocoboBookScreen() {
        super((Component)Component.m_237119_());
        int maxPages = 1;
        for (int i = 1; i < 128; ++i) {
            String unlocalized = "gui.chocobook.page" + i;
            if (!I18n.m_118938_((String)unlocalized, (Object[])new Object[0]).equals(unlocalized)) continue;
            maxPages = i - 1;
            break;
        }
        this.pageCount = maxPages;
    }

    public static void openScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new ChocoboBookScreen());
    }

    public void m_7856_() {
        Objects.requireNonNull(this);
        this.guiLeft = (this.f_96543_ - 192) / 2;
        Objects.requireNonNull(this);
        this.guiTop = (this.f_96544_ - 192) / 2;
        this.m_142416_((GuiEventListener)new PageButton(this.guiLeft + 192 - 66, this.guiTop + 158, true, p_98297_ -> {
            this.currentPage = this.currentPage >= this.pageCount ? 0 : this.currentPage + 1;
        }, true));
        this.m_142416_((GuiEventListener)new PageButton(this.guiLeft + 36, this.guiTop + 158, false, p_98287_ -> {
            this.currentPage = this.currentPage <= 0 ? this.pageCount : this.currentPage - 1;
        }, true));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.guiLeft, (float)this.guiTop, 0.0f);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        guiGraphics.m_280218_(TEXTURE, 0, 0, 0, 0, 192, 192);
        if (this.currentPage == 0) {
            Objects.requireNonNull(this);
            guiGraphics.m_280614_(this.f_96547_, this.bookTitle, 192 / 2 - this.f_96547_.m_92852_((FormattedText)this.bookTitle) / 2, 24, 0, false);
            Objects.requireNonNull(this);
            guiGraphics.m_280614_(this.f_96547_, this.bookAuthor, 192 / 2 - this.f_96547_.m_92852_((FormattedText)this.bookAuthor) / 2, 44, 0, false);
        } else {
            if (this.currentPage > 1) {
                this.pageMsg = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage - 1, Math.max(this.pageCount - 1, 1)});
                Objects.requireNonNull(this);
                guiGraphics.m_280614_(this.f_96547_, this.pageMsg, 192 / 2 - this.f_96547_.m_92852_((FormattedText)this.bookAuthor) / 2 - 6, 14, 0, false);
            }
            this.renderPage(guiGraphics);
        }
        poseStack.m_85849_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderPage(GuiGraphics guiGraphics) {
        Objects.requireNonNull(this);
        int i = (this.f_96543_ - 192) / 2;
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)("gui.chocobook.page" + this.currentPage)), i + 34, this.guiTop + 26, 120, 0);
    }
}

