/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.bargain.preview;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.bargain.DemandPreview;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.contents.Contents;

public final class HeartContainerDemandPreview
implements DemandPreview {
    private final int quantity;
    private final List<ItemStack> preview;

    public HeartContainerDemandPreview(int quantity) {
        this.quantity = quantity;
        this.preview = List.of(new ItemStack((ItemLike)Contents.get().heartContainer()));
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull ItemStack> preview() {
        return this.preview;
    }

    @Override
    public int quantity() {
        return this.quantity;
    }

    @Override
    public int count(@NotNull Player player) {
        return VesselContainer.get(player).heartContainer();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public @NotNull List<@NotNull Component> getTooltip(int previewIndex) {
        return List.of(this.quantity == 1 ? Component.m_237115_((String)"bargain.paraglider.heart_container") : Component.m_237110_((String)"bargain.paraglider.heart_container.s", (Object[])new Object[]{this.quantity}));
    }
}

