/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.FloatBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import mod.chloeprime.aaaparticles.AAAParticles;
import mod.chloeprime.aaaparticles.api.client.effekseer.DeviceType;
import mod.chloeprime.aaaparticles.api.client.effekseer.Effekseer;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.internal.EffekFpvRenderer;
import mod.chloeprime.aaaparticles.client.internal.RenderContext;
import mod.chloeprime.aaaparticles.client.internal.RenderStateCapture;
import mod.chloeprime.aaaparticles.client.loader.EffekAssetLoader;
import mod.chloeprime.aaaparticles.client.render.RenderUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.InteractionHand;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class EffekRenderer {
    private static final FloatBuffer CAMERA_TRANSFORM_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer PROJECTION_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final AtomicBoolean INIT = new AtomicBoolean();
    private static final float[] CAMERA_TRANSFORM_DATA = new float[16];
    private static final float[] PROJECTION_MATRIX_DATA = new float[16];
    private static final long[] lastDrawTimeByNanos = new long[256];

    public static void init() {
        if (INIT.compareAndExchange(false, true)) {
            return;
        }
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            AAAParticles.LOGGER.warn("AAAParticles is running un unsupported platform {}, this mod will be no-op!", (Object)NativePlatform.current());
            return;
        }
        if (Effekseer.getDeviceType() != DeviceType.OPENGL) {
            if (!Effekseer.init()) {
                throw new ExceptionInInitializerError("Failed to initialize Effekseer");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(Effekseer::terminate, "ShutdownHook Effekseer::terminate"));
        }
    }

    public static void renderWorldEffeks(float partial, boolean renderHand, ItemInHandRenderer itemInHandRenderer) {
        GL11.glDepthMask((boolean)true);
        GL11.glDepthFunc((int)515);
        if (RenderContext.renderLevelDeferred() && RenderStateCapture.LEVEL.hasCapture) {
            RenderStateCapture.LEVEL.hasCapture = false;
            RenderUtil.pasteToCurrentDepthFrom(RenderStateCapture.CAPTURED_WORLD_DEPTH_BUFFER);
            EffekRenderer.renderWorldEffeks(partial, RenderStateCapture.LEVEL.pose, RenderStateCapture.LEVEL.projection, RenderStateCapture.LEVEL.camera);
        }
        if (RenderContext.renderHandDeferred() && renderHand) {
            if (RenderContext.captureHandDepth()) {
                RenderUtil.pasteToCurrentDepthFrom(RenderStateCapture.CAPTURED_HAND_DEPTH_BUFFER);
            }
            ((EffekFpvRenderer)itemInHandRenderer).aaaParticles$renderFpvEffek(partial, MinecraftHolder.MINECRAFT.f_91074_);
        }
    }

    public static void renderWorldEffeks(float partialTick, PoseStack pose, Matrix4f projection, Camera camera) {
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            return;
        }
        EffekRenderer.draw(ParticleEmitter.Type.WORLD, partialTick, pose, projection, camera);
    }

    public static void onRenderHand(float partialTick, InteractionHand hand, PoseStack pose, Matrix4f projection, Camera camera) {
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            return;
        }
        ParticleEmitter.Type type = switch (hand) {
            default -> throw new IncompatibleClassChangeError();
            case InteractionHand.MAIN_HAND -> ParticleEmitter.Type.FIRST_PERSON_MAINHAND;
            case InteractionHand.OFF_HAND -> ParticleEmitter.Type.FIRST_PERSON_OFFHAND;
        };
        EffekRenderer.draw(type, partialTick, pose, projection, camera);
    }

    private static void draw(ParticleEmitter.Type type, float partialTick, PoseStack pose, Matrix4f projection, Camera camera) {
        int w = MinecraftHolder.MINECRAFT.m_91268_().m_85441_();
        int h = MinecraftHolder.MINECRAFT.m_91268_().m_85442_();
        projection.get(PROJECTION_BUFFER);
        EffekRenderer.transposeMatrix(PROJECTION_BUFFER);
        PROJECTION_BUFFER.get(PROJECTION_MATRIX_DATA);
        pose.m_85836_();
        if (type == ParticleEmitter.Type.WORLD) {
            pose.m_85837_(-camera.m_90583_().m_7096_(), -camera.m_90583_().m_7098_(), -camera.m_90583_().m_7094_());
        }
        pose.m_85850_().m_252922_().get(CAMERA_TRANSFORM_BUFFER);
        EffekRenderer.transposeMatrix(CAMERA_TRANSFORM_BUFFER);
        CAMERA_TRANSFORM_BUFFER.get(CAMERA_TRANSFORM_DATA);
        pose.m_85849_();
        Optional.ofNullable(MinecraftHolder.MINECRAFT.f_91060_.m_109830_()).ifPresent(rt -> RenderUtil.copyDepthSafely(MinecraftHolder.MINECRAFT.m_91385_(), rt));
        float deltaFrames = 60.0f * EffekRenderer.getDeltaTime(type);
        float realDelta = MinecraftHolder.MINECRAFT.m_91104_() ? 0.0f : deltaFrames;
        RenderType.f_110126_.m_110185_();
        RenderUtil.runPixelStoreCodeSafely(() -> {
            RenderTarget background = RenderUtil.prepareBackgroundBuffer().orElse(null);
            EffekAssetLoader.get().forEach((id, inst) -> inst.draw(type, camera.m_253058_(), camera.m_90583_().m_252839_(), w, h, CAMERA_TRANSFORM_DATA, PROJECTION_MATRIX_DATA, realDelta, partialTick, background));
        });
        RenderType.f_110126_.m_110188_();
        CAMERA_TRANSFORM_BUFFER.clear();
        PROJECTION_BUFFER.clear();
    }

    private static void transposeMatrix(FloatBuffer m) {
        float m00 = m.get(0);
        float m01 = m.get(1);
        float m02 = m.get(2);
        float m03 = m.get(3);
        float m10 = m.get(4);
        float m11 = m.get(5);
        float m12 = m.get(6);
        float m13 = m.get(7);
        float m20 = m.get(8);
        float m21 = m.get(9);
        float m22 = m.get(10);
        float m23 = m.get(11);
        float m30 = m.get(12);
        float m31 = m.get(13);
        float m32 = m.get(14);
        float m33 = m.get(15);
        m.put(0, m00);
        m.put(1, m10);
        m.put(2, m20);
        m.put(3, m30);
        m.put(4, m01);
        m.put(5, m11);
        m.put(6, m21);
        m.put(7, m31);
        m.put(8, m02);
        m.put(9, m12);
        m.put(10, m22);
        m.put(11, m32);
        m.put(12, m03);
        m.put(13, m13);
        m.put(14, m23);
        m.put(15, m33);
    }

    private static float getDeltaTime(ParticleEmitter.Type type) {
        long now;
        long last = lastDrawTimeByNanos[type.ordinal()];
        if (last == 0L) {
            EffekRenderer.lastDrawTimeByNanos[type.ordinal()] = System.nanoTime();
            return 0.016666668f;
        }
        EffekRenderer.lastDrawTimeByNanos[type.ordinal()] = now = System.nanoTime();
        return (float)((double)(now - last) * 1.0E-9);
    }

    public static final class MinecraftHolder {
        public static final Minecraft MINECRAFT = Minecraft.m_91087_();
    }
}

