/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client.installer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

public class JarExtractor {
    public static void extract(String from, File targetFile) throws IOException {
        try (InputStream input = Objects.requireNonNull(JarExtractor.class.getClassLoader().getResource(from)).openStream();
             FileOutputStream output = FileUtils.openOutputStream((File)targetFile);){
            input.transferTo(output);
        }
    }

    public static boolean update(String resource, File target) throws IOException {
        boolean isUpToDate;
        try (InputStream res = JarExtractor.getResource(resource);
             InputStream fs = Files.newInputStream(target.toPath(), new OpenOption[0]);){
            byte[] resHash = DigestUtils.sha1((InputStream)res);
            byte[] fileHash = DigestUtils.sha1((InputStream)fs);
            isUpToDate = Arrays.equals(resHash, fileHash);
        }
        if (isUpToDate) {
            return false;
        }
        if (!target.delete()) {
            throw new IOException("Failed to delete %s".formatted(target.getCanonicalPath()));
        }
        JarExtractor.extract(resource, target);
        return true;
    }

    private static InputStream getResource(String resource) throws IOException {
        return Objects.requireNonNull(JarExtractor.class.getClassLoader().getResource(resource)).openStream();
    }
}

