/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("curios");
    private Tag data;

    public CurioGraveData(ICuriosItemHandler curios, Collection<ItemEntity> drops) {
        this.data = curios.writeTag();
        for (Map.Entry entry : curios.getCurios().entrySet()) {
            ICurioStacksHandler curioItems = (ICurioStacksHandler)entry.getValue();
            NonNullList curioStacksList = NonNullList.m_122780_((int)curioItems.getSlots(), (Object)ItemStack.f_41583_);
            NonNullList curioCosmeticStacksList = NonNullList.m_122780_((int)curioItems.getSlots(), (Object)ItemStack.f_41583_);
            Iterator<ItemEntity> ite = drops.iterator();
            HashSet<Integer> stackSlotsChecked = new HashSet<Integer>();
            HashSet<Integer> cosmeticStacksSlotsChecked = new HashSet<Integer>();
            block1: while (ite.hasNext()) {
                ItemStack stack;
                int slot;
                ItemStack drop = ite.next().m_32055_();
                for (slot = 0; slot < curioItems.getSlots(); ++slot) {
                    if (stackSlotsChecked.contains(slot) || !ItemStack.m_41728_((ItemStack)(stack = curioItems.getStacks().getStackInSlot(slot)), (ItemStack)drop)) continue;
                    stackSlotsChecked.add(slot);
                    curioStacksList.set(slot, (Object)drop);
                    ite.remove();
                    continue block1;
                }
                for (slot = 0; slot < curioItems.getSlots(); ++slot) {
                    if (cosmeticStacksSlotsChecked.contains(slot) || !ItemStack.m_41728_((ItemStack)(stack = curioItems.getCosmeticStacks().getStackInSlot(slot)), (ItemStack)drop)) continue;
                    cosmeticStacksSlotsChecked.add(slot);
                    curioCosmeticStacksList.set(slot, (Object)drop);
                    ite.remove();
                    continue block1;
                }
            }
        }
    }

    public CurioGraveData(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public void restore(Player player) {
        if (this.data == null) {
            return;
        }
        LazyOptional optional = CuriosApi.getCuriosInventory((LivingEntity)player);
        optional.ifPresent(handler -> {
            handler.getCurios().values().forEach(curio -> {
                IDynamicStackHandler stacks = curio.getStacks();
                for (int slot = 0; slot < stacks.getSlots(); ++slot) {
                    ItemStack stack = stacks.getStackInSlot(slot);
                    if (stack.m_41619_()) continue;
                    PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, -1, stack);
                }
            });
            handler.readTag(this.data);
        });
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        if (this.data != null) {
            nbt.m_128365_("Data", this.data);
        }
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt) {
        if (nbt.m_128441_("Data")) {
            this.data = nbt.m_128423_("Data");
        }
    }
}

