/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.registry.RatsCapabilityRegistry;
import com.github.alexthe666.rats.server.capability.SelectedRat;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record UpdateSelectedRatPacket(int entityId, int ratId) {
    public UpdateSelectedRatPacket(Entity entity, SelectedRat cap) {
        this(entity.m_19879_(), cap.getSelectedRat().m_19879_());
    }

    public static UpdateSelectedRatPacket decode(FriendlyByteBuf buf) {
        return new UpdateSelectedRatPacket(buf.readInt(), buf.readInt());
    }

    public static void encode(UpdateSelectedRatPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityId());
        buf.writeInt(packet.ratId());
    }

    public static class Handler {
        public static void handle(final UpdateSelectedRatPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId());
                    if (entity instanceof LivingEntity) {
                        entity.getCapability(RatsCapabilityRegistry.SELECTED_RAT).ifPresent(cap -> cap.setSelectedRat((TamedRat)Minecraft.m_91087_().f_91073_.m_6815_(packet.ratId())));
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

