/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.server.entity.ai.goal.RatRangedAttackGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesAIUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.HoldsItemUpgrade;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RangedWeaponRatUpgradeItem
extends BaseRatUpgradeItem
implements HoldsItemUpgrade,
ChangesAIUpgrade {
    private final boolean crossbow;

    public RangedWeaponRatUpgradeItem(Item.Properties properties, boolean crossbow) {
        super(properties, 0, crossbow ? 2 : 1);
        this.crossbow = crossbow;
    }

    @Override
    public List<Goal> addNewWorkGoals(TamedRat rat) {
        return List.of(new RatRangedAttackGoal(rat, 1.0, 20, 15.0f));
    }

    @Override
    public void renderHeldItem(EntityRendererProvider.Context context, TamedRat rat, RatModel<?> model, PoseStack stack, MultiBufferSource buffer, int light, float ageInTicks) {
        this.translateToHand(model, false, stack);
        stack.m_85837_(0.01, 0.1, -0.02);
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        context.m_174025_().m_269128_(new ItemStack((ItemLike)(this.crossbow ? Items.f_42717_ : Items.f_42411_)), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
    }
}

