/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RatTubeItem
extends Item {
    public final DyeColor color;

    public RatTubeItem(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"block.rats.rat_tube.desc0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"block.rats.rat_tube.desc1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"block.rats.rat_tube.desc2").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult actionresulttype = this.tryPlace(new BlockPlaceContext(context));
        return actionresulttype != InteractionResult.SUCCESS && this.m_41472_() ? this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_() : actionresulttype;
    }

    public InteractionResult tryPlace(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockState placedState = this.getStateForPlacement(context);
        if (placedState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(context, placedState)) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        BlockState currentState = level.m_8055_(pos);
        Block block = currentState.m_60734_();
        if (block == placedState.m_60734_()) {
            currentState = this.stateWithTag(pos, level, stack, currentState);
            this.setBlockEntityTag(level, player, pos, stack);
            block.m_6402_(level, pos, currentState, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, stack);
            }
        }
        SoundType soundtype = currentState.getSoundType((LevelReader)level, pos, (Entity)context.m_43723_());
        level.m_5594_(player, pos, currentState.m_60827_().m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    protected BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = ((Block)RatsBlockRegistry.RAT_TUBE_COLOR.get()).m_5573_(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    private BlockState stateWithTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockState blockstate = state;
        CompoundTag compoundnbt = stack.m_41783_();
        if (compoundnbt != null) {
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("BlockStateTag");
            StateDefinition statecontainer = state.m_60734_().m_49965_();
            for (String s : compoundnbt1.m_128431_()) {
                Property iproperty = statecontainer.m_61081_(s);
                if (iproperty == null) continue;
                String s1 = compoundnbt1.m_128423_(s).m_7916_();
                blockstate = RatTubeItem.remapProperties(blockstate, iproperty, s1);
            }
        }
        if (blockstate != state) {
            level.m_7731_(pos, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState remapProperties(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(t -> (BlockState)state.m_61124_(property, t)).orElse(state);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_());
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    public void setBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        BlockEntity tileentity;
        CompoundTag compoundnbt;
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver != null && (compoundnbt = stack.m_41737_("BlockEntityTag")) != null && (tileentity = level.m_7702_(pos)) != null) {
            if (!(level.m_5776_() || !tileentity.m_6326_() || player != null && player.m_36337_())) {
                return;
            }
            CompoundTag compoundnbt1 = tileentity.serializeNBT();
            CompoundTag compoundnbt2 = compoundnbt1.m_6426_();
            compoundnbt1.m_128391_(compoundnbt);
            compoundnbt1.m_128405_("x", pos.m_123341_());
            compoundnbt1.m_128405_("y", pos.m_123342_());
            compoundnbt1.m_128405_("z", pos.m_123343_());
            if (!compoundnbt1.equals((Object)compoundnbt2)) {
                tileentity.m_142466_(compoundnbt1);
                tileentity.m_6596_();
            }
        }
    }
}

