/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.rat;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.block.entity.RatHoleBlockEntity;
import com.github.alexthe666.rats.server.entity.ai.goal.RatRaidChestsGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatRaidCropsGoal;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.misc.RatPathingHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public abstract class DiggingRat
extends AbstractRat {
    public int breakingTime;
    public int previousBreakProgress = -1;
    private BlockPos diggingPos = null;
    private int digCooldown = 0;

    protected DiggingRat(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new RatRaidChestsGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RatRaidCropsGoal(this));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.canDigThroughBlocks() && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && this.m_269323_() == null && this.m_21573_().m_26571_() && this.digCooldown-- <= 0 && RatConfig.ratsDigBlocks) {
            this.findDigTarget();
            this.digTarget();
        }
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.diggingPos == null;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("DigCooldown", this.digCooldown);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.digCooldown = tag.m_128451_("DigCooldown");
    }

    public boolean isOnDiggingCooldown() {
        return this.digCooldown > 0;
    }

    private void digTarget() {
        if (this.diggingPos != null) {
            ++this.breakingTime;
            this.m_21563_().m_24964_(this.diggingPos.m_252807_());
            int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            this.m_20334_(0.0, 0.0, 0.0);
            if (this.breakingTime % 40 == 0) {
                this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_DIG.get(), this.m_6121_(), this.m_6100_());
            }
            if (i != this.previousBreakProgress) {
                this.m_9236_().m_6801_(this.m_19879_(), this.diggingPos, i);
                this.previousBreakProgress = i;
            }
            if (this.breakingTime == 160) {
                BlockEntity be;
                this.breakingTime = 0;
                this.previousBreakProgress = -1;
                BlockState prevState = this.m_9236_().m_8055_(this.diggingPos);
                this.m_9236_().m_46597_(this.diggingPos, ((Block)RatsBlockRegistry.RAT_HOLE.get()).m_49966_());
                if (this.m_9236_().m_8055_(this.diggingPos).m_60713_((Block)RatsBlockRegistry.RAT_HOLE.get()) && (be = this.m_9236_().m_7702_(this.diggingPos)) instanceof RatHoleBlockEntity) {
                    RatHoleBlockEntity hole = (RatHoleBlockEntity)be;
                    hole.setImitatedBlockState(prevState);
                }
                this.digCooldown = 3000;
                this.diggingPos = null;
            }
            if (this.diggingPos != null && this.m_20275_(this.diggingPos.m_123341_(), this.diggingPos.m_123342_(), this.diggingPos.m_123343_()) > 2.0) {
                this.breakingTime = 0;
                this.previousBreakProgress = -1;
                this.m_9236_().m_6801_(this.m_19879_(), this.diggingPos, 0);
                this.diggingPos = null;
            }
        } else {
            this.breakingTime = 0;
            this.previousBreakProgress = -1;
        }
    }

    private void findDigTarget() {
        BlockPos digPos;
        if (this.m_21573_().m_26567_() != null && (digPos = this.rayTraceBlockPos(this.m_21573_().m_26567_())) != null && this.m_20275_(digPos.m_123341_(), digPos.m_123342_(), digPos.m_123343_()) < 2.0 && (this.m_9236_().m_7702_(digPos) == null || this.m_9236_().m_7702_(digPos) instanceof RatHoleBlockEntity) && this.canDigBlock(this.m_9236_(), digPos) && digPos.m_123342_() == (int)Math.round(this.m_20186_())) {
            this.diggingPos = digPos;
        }
    }

    @Nullable
    public BlockPos rayTraceBlockPos(BlockPos targetPos) {
        BlockHitResult result = RatPathingHelper.clipWithConditions((BlockGetter)this.m_9236_(), new ClipContext(this.m_20182_(), Vec3.m_82512_((Vec3i)targetPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), false);
        BlockPos pos = result.m_82425_();
        BlockPos sidePos = result.m_82425_().m_121945_(result.m_82434_());
        if (!this.m_9236_().m_46859_(sidePos)) {
            return sidePos;
        }
        if (!this.m_9236_().m_46859_(pos)) {
            return pos;
        }
        return null;
    }

    public boolean canDigThroughBlocks() {
        return true;
    }

    private boolean canDigBlock(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_204336_(RatsBlockTags.DIGGABLE_BLOCKS) && state.m_60804_((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldPlayIdleAnimations() {
        return this.diggingPos == null && super.shouldPlayIdleAnimations();
    }
}

